/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.editor.hints.options.ModelImpl;
import org.netbeans.modules.editor.hints.options.SeverityComboRenderer;
import org.netbeans.spi.editor.hints.ProviderDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.HtmlRenderer;

public class AdvancedPanelImpl
extends JPanel {
    private ModelImpl model;
    public JComboBox eagerCombo;
    public JCheckBox jCheckBox1;
    public JComboBox jComboBox1;
    public JLabel jLabel1;
    public JTable jTable1;
    private static final String[] SEVERITIES_ARRAY = new String[]{"<html><font color=\"#808080\">disabled", "<html><font color=\"#800000\">error", "<html><font color=\"#808000\">warning", "<html><font color=\"#000080\">verifier", "<html><font color=\"#000080\">hint", "<html><font color=\"#000080\">todo"};
    static final List SEVERITIES = Arrays.asList(SEVERITIES_ARRAY);

    public AdvancedPanelImpl(ModelImpl modelImpl) {
        this.model = modelImpl;
        this.initComponents();
        this.jTable1.setDefaultRenderer(Severity.class, new SeverityCellRenderer());
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{Severity.ERROR, Severity.WARNING, Severity.VERIFIER, Severity.HINT, Severity.TODO, Severity.DISABLED});
        jComboBox.setRenderer(new SeverityComboRenderer());
        this.jTable1.setDefaultEditor(Severity.class, new DefaultCellEditor(jComboBox));
        TableColumn tableColumn = this.jTable1.getColumnModel().getColumn(0);
        tableColumn.setHeaderValue("XXXXXXXXX");
        tableColumn.setHeaderRenderer(new HeaderTableCellRenderer());
        tableColumn.sizeWidthToFit();
        this.updateForCurrentProvider();
        this.eagerCombo.setSelectedIndex(2);
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.eagerCombo = new JComboBox();
        this.jComboBox1.setModel(new ComboModelImpl());
        this.jComboBox1.setSelectedIndex(this.jComboBox1.getModel().getSize() > 0 ? 0 : -1);
        this.jComboBox1.setRenderer(new RendererImpl());
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanelImpl.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.jCheckBox1.setText("Enabled");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanelImpl.this.jCheckBox1ActionPerformed(actionEvent);
            }
        });
        this.jTable1.setModel(new OptionsTableModel());
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jLabel1.setText("Eagerness:");
        this.eagerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<html>On Project Open <i>requires restart</i>", "<html>On Demand", "<html>Lazy"}));
        this.eagerCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanelImpl.this.eagerComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTable1, -1, 454, Short.MAX_VALUE).add((Component)this.jCheckBox1, -1, 454, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.eagerCombo, 0, 375, Short.MAX_VALUE)).add((Component)this.jComboBox1, 0, 454, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.eagerCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTable1, -2, -1, -2).add((Component)this.jCheckBox1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void eagerComboActionPerformed(ActionEvent actionEvent) {
    }

    private void jCheckBox1ActionPerformed(ActionEvent actionEvent) {
        this.model.setProviderEnabled(this.getProviderDescription().getKey(), this.jCheckBox1.isSelected());
        int n = this.jComboBox1.getSelectedIndex();
        ((ComboModelImpl)this.jComboBox1.getModel()).fireContentsChanged(n, n);
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.updateForCurrentProvider();
    }

    private void updateForCurrentProvider() {
        ProviderDescription providerDescription = this.getProviderDescription();
        if (providerDescription != null) {
            this.jCheckBox1.setSelected(this.model.isProviderEnabled(providerDescription.getKey()));
            this.jCheckBox1.setEnabled(true);
        } else {
            this.jCheckBox1.setSelected(false);
            this.jCheckBox1.setEnabled(false);
        }
        ((OptionsTableModel)this.jTable1.getModel()).fireTableDataChanged();
    }

    private ProviderDescription getProviderDescription() {
        return (ProviderDescription)this.jComboBox1.getSelectedItem();
    }

    private final class ComboModelImpl
    extends DefaultComboBoxModel {
        private ComboModelImpl() {
        }

        public int getSize() {
            return AdvancedPanelImpl.this.model.getDescriptions().size();
        }

        public Object getElementAt(int n) {
            return AdvancedPanelImpl.this.model.getDescriptions().get(n);
        }

        public void fireContentsChanged(int n, int n2) {
            super.fireContentsChanged(this, n, n2);
        }
    }

    private static final class HeaderTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private HeaderTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            return this;
        }
    }

    private final class OptionsTableModel
    extends AbstractTableModel {
        private OptionsTableModel() {
        }

        public int getRowCount() {
            ProviderDescription providerDescription = AdvancedPanelImpl.this.getProviderDescription();
            if (providerDescription == null) {
                return 0;
            }
            return providerDescription.getSupportedErrorKeys().size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Severity";
                }
                case 1: {
                    return "Name";
                }
            }
            throw new IllegalArgumentException("columnIndex=" + n);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Severity.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + n);
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + n2);
        }

        public Object getValueAt(int n, int n2) {
            ProviderDescription providerDescription = AdvancedPanelImpl.this.getProviderDescription();
            switch (n2) {
                case 0: {
                    return AdvancedPanelImpl.this.model.getErrorSeverity(providerDescription.getKey(), (String)providerDescription.getSupportedErrorKeys().get(n));
                }
                case 1: {
                    return providerDescription.getErrorDisplayName((String)providerDescription.getSupportedErrorKeys().get(n));
                }
            }
            throw new IllegalArgumentException("columnIndex=" + n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            ProviderDescription providerDescription = AdvancedPanelImpl.this.getProviderDescription();
            switch (n2) {
                case 0: {
                    AdvancedPanelImpl.this.model.setSeverity(providerDescription.getKey(), (String)providerDescription.getSupportedErrorKeys().get(n), (Severity)((Object)object));
                    return;
                }
            }
            throw new IllegalArgumentException("columnIndex=" + n2);
        }
    }

    private final class RendererImpl
    implements ListCellRenderer {
        private ListCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object == null) {
                string = "<none>";
            } else {
                string = ((ProviderDescription)object).getDisplayName();
                if (!AdvancedPanelImpl.this.model.isProviderEnabled(((ProviderDescription)object).getKey())) {
                    string = "<html><s>" + string;
                }
            }
            return this.delegateTo.getListCellRendererComponent(jList, string, n, bl, bl2);
        }
    }

    private static final class SeverityCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.delegateTo.getTableCellRendererComponent(jTable, SEVERITIES.get(((Severity)((Object)object)).ordinal()), bl, bl2, n, n2);
        }
    }
}

