/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.editor.hints.options.ProvidersListAccessor;
import org.netbeans.spi.editor.hints.ProviderDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProvidersList {
    private static final String PROVIDERS_LIST_FOLDER = "EditorHints/";
    private static final String CONFIG_FILE_NAME = "editorhintsconfig.xml";
    private static List<ProviderDescription> descriptions;
    private static Map<String, Boolean> key2Enabled;
    private static Map<String, ProviderDescription> key2Description;
    private static Map<String, Map<String, Severity>> key2Error2Severity;
    private static boolean initialized;

    private ProvidersList() {
    }

    static synchronized Collection<String> getInstalledProvidersList() {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        return key2Description.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        key2Description = new HashMap<String, ProviderDescription>();
        descriptions = new ArrayList<ProviderDescription>();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(PROVIDERS_LIST_FOLDER);
        FolderLookup folderLookup = new FolderLookup(DataFolder.findContainer((FileObject)fileObject));
        Collection collection = folderLookup.getLookup().lookupAll(ProviderDescription.class);
        for (Object object : collection) {
            key2Description.put(object.getKey(), (ProviderDescription)object);
            descriptions.add((ProviderDescription)object);
        }
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource(CONFIG_FILE_NAME);
        if (fileObject2 != null) {
            Object object;
            object = null;
            try {
                object = fileObject2.getInputStream();
                XMLDecoder xMLDecoder = new XMLDecoder((InputStream)object);
                key2Error2Severity = (Map)xMLDecoder.readObject();
                key2Enabled = (Map)xMLDecoder.readObject();
                xMLDecoder.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
        } else {
            key2Error2Severity = new HashMap<String, Map<String, Severity>>();
            key2Enabled = new HashMap<String, Boolean>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save() {
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            Object object;
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(CONFIG_FILE_NAME);
            if (fileObject == null) {
                object = Repository.getDefault().getDefaultFileSystem().getRoot();
                fileObject = FileUtil.createData((FileObject)object, (String)CONFIG_FILE_NAME);
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            object = new XMLEncoder(outputStream);
            ((XMLEncoder)object).writeObject(key2Error2Severity);
            ((XMLEncoder)object).writeObject(key2Enabled);
            ((XMLEncoder)object).close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static boolean isProviderEnabled(String string) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(string)) {
            throw new IllegalArgumentException("Unknown provider key: " + string);
        }
        Boolean bl = key2Enabled.get(string);
        if (bl == null) {
            ProviderDescription providerDescription = ProvidersList.getProviderDescription(string);
            return providerDescription.getDefaultState();
        }
        return bl;
    }

    public static synchronized Severity getErrorSeverity(String string, String string2) {
        Severity severity;
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(string)) {
            throw new IllegalArgumentException("Unknown provider key: " + string);
        }
        Map<String, Severity> map = key2Error2Severity.get(string);
        if (map == null) {
            map = new HashMap<String, Severity>();
            key2Error2Severity.put(string, map);
        }
        if ((severity = map.get(string2)) == null) {
            ProviderDescription providerDescription = ProvidersList.getProviderDescription(string);
            if (providerDescription.getSupportedErrorKeys().contains(string2)) {
                return providerDescription.getErrorDefaultSeverity(string2);
            }
            throw new IllegalArgumentException("Unknown error key: " + string2 + " for provider: " + string);
        }
        return severity;
    }

    static synchronized void setProviderEnabled(String string, boolean bl) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(string)) {
            throw new IllegalArgumentException("Unknown provider key: " + string);
        }
        key2Enabled.put(string, bl);
        ProvidersList.save();
    }

    static synchronized void setSeverity(String string, String string2, Severity severity) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!ProvidersList.getProviderDescription(string).getSupportedErrorKeys().contains(string2)) {
            throw new IllegalArgumentException("Unknown error key: " + string2 + " for provider: " + string);
        }
        Map<String, Severity> map = key2Error2Severity.get(string);
        if (map == null) {
            map = new HashMap<String, Severity>();
            key2Error2Severity.put(string, map);
        }
        map.put(string2, severity);
        ProvidersList.save();
    }

    static synchronized ProviderDescription getProviderDescription(String string) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(string)) {
            throw new IllegalArgumentException("Unknown provider key: " + string);
        }
        return key2Description.get(string);
    }

    static synchronized List<ProviderDescription> getDescriptions() {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        return descriptions;
    }

    static {
        ProvidersListAccessor.INSTANCE = new ProvidersListAccessor(){

            @Override
            public Collection<String> getInstalledProvidersList() {
                return ProvidersList.getInstalledProvidersList();
            }

            @Override
            public void setProviderEnabled(String string, boolean bl) {
                ProvidersList.setProviderEnabled(string, bl);
            }

            @Override
            public void setSeverity(String string, String string2, Severity severity) {
                ProvidersList.setSeverity(string, string2, severity);
            }

            @Override
            public ProviderDescription getProviderDescription(String string) {
                return ProvidersList.getProviderDescription(string);
            }

            @Override
            public List<ProviderDescription> getDescriptions() {
                return ProvidersList.getDescriptions();
            }
        };
        descriptions = null;
        key2Enabled = null;
        key2Description = null;
        key2Error2Severity = null;
        initialized = false;
    }
}

