/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public final class Utils {
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.palette");

    private Utils() {
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle(Utils.class);
    }

    public static String getBundleString(String string) {
        return Utils.getBundle().getString(string);
    }

    public static Action[] mergeActions(Action[] actionArray, Action[] actionArray2) {
        if (null == actionArray) {
            return actionArray2;
        }
        if (null == actionArray2) {
            return actionArray;
        }
        Action[] actionArray3 = new Action[actionArray.length + actionArray2.length + 1];
        System.arraycopy(actionArray, 0, actionArray3, 0, actionArray.length);
        actionArray3[actionArray.length] = null;
        System.arraycopy(actionArray2, 0, actionArray3, actionArray.length + 1, actionArray2.length);
        return actionArray3;
    }

    public static boolean isReadonly(Node node) {
        DataObject dataObject;
        Object object = node.getValue("isReadonly");
        if (null == object && null != (dataObject = (DataObject)node.getCookie(DataObject.class))) {
            object = dataObject.getPrimaryFile().getAttribute("isReadonly");
        }
        if (null != object) {
            return Boolean.valueOf(object.toString());
        }
        return !node.canDestroy();
    }

    public static HelpCtx getHelpCtx(Node node, HelpCtx helpCtx) {
        HelpCtx helpCtx2 = helpCtx;
        if (null == helpCtx2 || HelpCtx.DEFAULT_HELP.equals((Object)helpCtx2)) {
            DataObject dataObject;
            Object object = node.getValue("helpId");
            if (null == object && null != (dataObject = (DataObject)node.getCookie(DataObject.class))) {
                object = dataObject.getPrimaryFile().getAttribute("helpId");
            }
            if (null != object) {
                helpCtx2 = new HelpCtx(object.toString());
            }
        }
        return helpCtx2;
    }

    public static void addCustomizationMenuItems(JPopupMenu jPopupMenu, PaletteController paletteController, Settings settings) {
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShowNamesAction(settings));
        jPopupMenu.add(new ChangeIconSizeAction(settings));
        Utils.addResetMenuItem(jPopupMenu, paletteController, settings);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new ShowCustomizerAction(paletteController));
    }

    static void addResetMenuItem(JPopupMenu jPopupMenu, final PaletteController paletteController, final Settings settings) {
        JMenuItem jMenuItem = new JMenuItem(Utils.getBundleString("CTL_ResetPalettePopup"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.resetPalette(paletteController, settings);
            }
        });
        jPopupMenu.add(jMenuItem);
    }

    public static Node findCategoryNode(Node node, String string) {
        return node.getChildren().findChild(string);
    }

    public static void resetPalette(PaletteController paletteController, Settings settings) {
        Node node = (Node)paletteController.getRoot().lookup(Node.class);
        if (null != node) {
            Utils.resetPalette(node, paletteController, settings);
        }
    }

    public static void resetPalette(Node node, PaletteController paletteController, Settings settings) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Utils.getBundleString("MSG_ConfirmPaletteReset"), Utils.getBundleString("CTL_ConfirmResetTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
            Object object;
            FileObject fileObject;
            settings.reset();
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (null != dataObject && null != (fileObject = dataObject.getPrimaryFile()) && fileObject.isFolder() && null != (object = fileObject.getAttribute("removeWritables")) && object instanceof Callable) {
                try {
                    ((Callable)object).call();
                }
                catch (Exception exception) {
                    ERR.log(Level.INFO, exception.getLocalizedMessage(), exception);
                }
            }
            paletteController.refresh();
        }
    }

    private static class ChangeIconSizeAction
    extends AbstractAction {
        private Settings settings;

        public ChangeIconSizeAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.settings.getIconSize();
            int n2 = n == 1 ? 2 : 1;
            this.settings.setIconSize(n2);
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                String string2 = Utils.getBundleString("CTL_IconSize");
                return MessageFormat.format(string2, this.settings.getIconSize());
            }
            return super.getValue(string);
        }
    }

    public static class CopyItemAction
    extends AbstractAction {
        private Node itemNode;

        public CopyItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Copy"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Transferable transferable = this.itemNode.clipboardCopy();
                if (transferable != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    clipboard.setContents(transferable, new StringSelection(""));
                }
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }

        public boolean isEnabled() {
            return this.itemNode.canCopy();
        }
    }

    public static class CutItemAction
    extends AbstractAction {
        private Node itemNode;

        public CutItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Cut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Transferable transferable = this.itemNode.clipboardCut();
                if (transferable != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    clipboard.setContents(transferable, new StringSelection(""));
                }
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }

        public boolean isEnabled() {
            return this.itemNode.canCut();
        }
    }

    static class DeleteCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public DeleteCategoryAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_DeleteCategory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = MessageFormat.format(Utils.getBundleString("FMT_ConfirmCategoryDelete"), this.categoryNode.getName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, Utils.getBundleString("CTL_ConfirmCategoryTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                try {
                    this.categoryNode.destroy();
                }
                catch (IOException iOException) {
                    ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canDestroy();
        }
    }

    public static class NewCategoryAction
    extends AbstractAction {
        private Node paletteNode;

        public NewCategoryAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_CreateCategory"));
            this.paletteNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewType[] newTypeArray = this.paletteNode.getNewTypes();
            try {
                if (null != newTypeArray && newTypeArray.length > 0) {
                    newTypeArray[0].create();
                }
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    public static class PasteItemAction
    extends AbstractAction {
        private Node categoryNode;

        public PasteItemAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Paste"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PasteType pasteType = this.getPasteType();
            if (pasteType != null) {
                try {
                    Transferable transferable = pasteType.paste();
                    if (transferable != null) {
                        ClipboardOwner clipboardOwner = transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : new StringSelection("");
                        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
                        clipboard.setContents(transferable, clipboardOwner);
                    }
                }
                catch (IOException iOException) {
                    ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.getPasteType() != null;
        }

        private PasteType getPasteType() {
            PasteType[] pasteTypeArray;
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null && (pasteTypeArray = this.categoryNode.getPasteTypes(transferable)) != null && pasteTypeArray.length != 0) {
                return pasteTypeArray[0];
            }
            return null;
        }
    }

    static class RefreshPaletteAction
    extends AbstractAction {
        public RefreshPaletteAction() {
            this.putValue("Name", Utils.getBundleString("CTL_RefreshPalette"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PalettePanel.getDefault().doRefresh();
        }
    }

    static class RemoveItemAction
    extends AbstractAction {
        private Node itemNode;

        public RemoveItemAction(Node node) {
            this.itemNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_Delete"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = MessageFormat.format(Utils.getBundleString("FMT_ConfirmBeanDelete"), this.itemNode.getDisplayName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, Utils.getBundleString("CTL_ConfirmBeanTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
                try {
                    this.itemNode.destroy();
                }
                catch (IOException iOException) {
                    ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                }
            }
        }

        public boolean isEnabled() {
            return this.itemNode.canDestroy();
        }
    }

    static class RenameCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public RenameCategoryAction(Node node) {
            this.categoryNode = node;
            this.putValue("Name", Utils.getBundleString("CTL_RenameCategory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Utils.getBundleString("CTL_NewName"), Utils.getBundleString("CTL_Rename"));
            inputLine.setInputText(this.categoryNode.getDisplayName());
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine))) {
                try {
                    String string = inputLine.getInputText();
                    if (!"".equals(string)) {
                        this.categoryNode.setDisplayName(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ERR.log(Level.INFO, illegalArgumentException.getLocalizedMessage(), illegalArgumentException);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canRename();
        }
    }

    private static class ShowCustomizerAction
    extends AbstractAction {
        private PaletteController palette;

        public ShowCustomizerAction(PaletteController paletteController) {
            this.palette = paletteController;
            this.putValue("Name", Utils.getBundleString("CTL_ShowCustomizer"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.palette.showCustomizer();
        }
    }

    private static class ShowNamesAction
    extends AbstractAction {
        private Settings settings;

        public ShowNamesAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.settings.setShowItemNames(!this.settings.getShowItemNames());
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                boolean bl = this.settings.getShowItemNames();
                return Utils.getBundleString(bl ? "CTL_HideNames" : "CTL_ShowNames");
            }
            return super.getValue(string);
        }
    }

    static class SortCategoriesAction
    extends AbstractAction {
        private Node paletteNode;

        public SortCategoriesAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_SortCategories"));
            this.paletteNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Index index = (Index)this.paletteNode.getCookie(Index.class);
            if (index != null) {
                Node[] nodeArray = this.paletteNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodeArray, new Comparator<Node>(){

                    @Override
                    public int compare(Node node, Node node2) {
                        return node.getDisplayName().compareTo(node2.getDisplayName());
                    }
                });
                int[] nArray = new int[nodeArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = index.indexOf(nodeArray[i]);
                }
                index.reorder(nArray);
            }
        }

        public boolean isEnabled() {
            return this.paletteNode.getCookie(Index.class) != null;
        }
    }

    static class SortItemsAction
    extends AbstractAction {
        private Node categoryNode;

        public SortItemsAction(Node node) {
            this.putValue("Name", Utils.getBundleString("CTL_SortItems"));
            this.categoryNode = node;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Index index = (Index)this.categoryNode.getCookie(Index.class);
            if (index != null) {
                Node[] nodeArray = this.categoryNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodeArray, new Comparator<Node>(){

                    @Override
                    public int compare(Node node, Node node2) {
                        return node.getDisplayName().compareTo(node2.getDisplayName());
                    }
                });
                int[] nArray = new int[nodeArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = index.indexOf(nodeArray[i]);
                }
                index.reorder(nArray);
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.getCookie(Index.class) != null;
        }
    }
}

