/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.ui.CategoryButton;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.CategoryList;
import org.netbeans.modules.palette.ui.DropGlassPane;
import org.netbeans.modules.palette.ui.PalettePanel;

public class DnDSupport
implements DragGestureListener,
DropTargetListener {
    private static final int DELAY_TIME_FOR_EXPAND = 1000;
    private Set<DragGestureRecognizer> recognizers = new HashSet<DragGestureRecognizer>(5);
    private Set<DropTarget> dropTargets = new HashSet<DropTarget>(5);
    private Category draggingCategory;
    private Item draggingItem;
    private CategoryList dragSourceCategoryList;
    private Item targetItem;
    private boolean dropBefore;
    private DragSourceListener dragSourceListener;
    private DropGlassPane dropPane;
    private PalettePanel palette;
    private Timer timer;
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.palette");

    public DnDSupport(PalettePanel palettePanel) {
        this.palette = palettePanel;
    }

    void add(CategoryDescriptor categoryDescriptor) {
        CategoryList categoryList = categoryDescriptor.getList();
        this.recognizers.add(DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(categoryList, 2, this));
        this.dropTargets.add(new DropTarget(categoryList, this));
        CategoryButton categoryButton = categoryDescriptor.getButton();
        this.recognizers.add(DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(categoryButton, 2, this));
        this.dropTargets.add(new DropTarget(categoryButton, this));
    }

    void remove(CategoryDescriptor categoryDescriptor) {
        ArrayList<DragGestureRecognizer> arrayList = new ArrayList<DragGestureRecognizer>(2);
        for (DragGestureRecognizer object : this.recognizers) {
            if (object.getComponent() != categoryDescriptor.getButton() && object.getComponent() != categoryDescriptor.getList()) continue;
            arrayList.add(object);
            object.removeDragGestureListener(this);
        }
        this.recognizers.removeAll(arrayList);
        ArrayList arrayList2 = new ArrayList(2);
        for (DropTarget dropTarget : this.dropTargets) {
            if (dropTarget.getComponent() != categoryDescriptor.getButton() && dropTarget.getComponent() != categoryDescriptor.getList()) continue;
            arrayList2.add(dropTarget);
            dropTarget.removeDropTargetListener(this);
        }
        this.dropTargets.removeAll(arrayList2);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JComponent jComponent;
        Transferable transferable = null;
        if (dragGestureEvent.getComponent() instanceof CategoryButton) {
            jComponent = (CategoryButton)dragGestureEvent.getComponent();
            this.draggingCategory = ((CategoryButton)jComponent).getCategory();
            transferable = this.draggingCategory.getTransferable();
        } else if (dragGestureEvent.getComponent() instanceof CategoryList) {
            jComponent = (CategoryList)dragGestureEvent.getComponent();
            int n = ((JList)jComponent).locationToIndex(dragGestureEvent.getDragOrigin());
            this.draggingItem = ((CategoryList)jComponent).getItemAt(n);
            if (null == this.draggingItem) {
                return;
            }
            transferable = this.draggingItem.drag();
            this.dragSourceCategoryList = jComponent;
        }
        if (null != transferable) {
            dragGestureEvent.getDragSource().addDragSourceListener(this.getDragSourceListener());
            try {
                dragGestureEvent.startDrag(null, transferable);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                ERR.log(Level.INFO, invalidDnDOperationException.getMessage(), invalidDnDOperationException);
            }
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Component component = dropTargetDropEvent.getDropTargetContext().getComponent();
        Category category = null;
        if (component instanceof CategoryList) {
            category = ((CategoryList)component).getCategory();
        } else if (component instanceof CategoryButton) {
            category = ((CategoryButton)component).getCategory();
        }
        if (null != this.draggingCategory) {
            boolean bl = false;
            if (null != category && component instanceof CategoryButton) {
                bl = this.palette.getModel().moveCategory(this.draggingCategory, category, this.dropBefore);
            }
            dropTargetDropEvent.dropComplete(bl);
        } else {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            boolean bl = false;
            if (null != category) {
                Transferable transferable = null != this.draggingItem ? this.draggingItem.cut() : dropTargetDropEvent.getTransferable();
                bl = category.dropItem(transferable, dropTargetDropEvent.getDropAction(), this.targetItem, this.dropBefore);
            }
            dropTargetDropEvent.dropComplete(bl);
        }
        this.cleanupAfterDnD();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.removeDropLine();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
        this.removeTimer();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkStoredGlassPane();
        this.doDragOver(dropTargetDragEvent);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        CategoryButton categoryButton;
        this.checkStoredGlassPane();
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (!(!(component instanceof CategoryButton) || null != this.draggingCategory || (categoryButton = (CategoryButton)component).isSelected() || null != this.timer && this.timer.isRunning())) {
            this.removeTimer();
            this.timer = new Timer(1000, new ActionListener(){

                public final void actionPerformed(ActionEvent actionEvent) {
                    categoryButton.setExpanded(true);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
        this.doDragOver(dropTargetDragEvent);
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] actionListenerArray = (ActionListener[])this.timer.getListeners(ActionListener.class);
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.timer.removeActionListener(actionListenerArray[i]);
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    private void doDragOver(DropTargetDragEvent dropTargetDragEvent) {
        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
        if (null != this.draggingCategory) {
            Serializable serializable;
            Category category = null;
            if (component instanceof CategoryButton) {
                serializable = (CategoryButton)component;
                category = serializable.getCategory();
            }
            if (null == category || !this.palette.getModel().canReorderCategories()) {
                dropTargetDragEvent.rejectDrag();
                this.removeDropLine();
                return;
            }
            this.dropBefore = dropTargetDragEvent.getLocation().y < component.getHeight() / 2;
            serializable = component.getLocation();
            Point point = component.getLocation();
            point.x += component.getWidth();
            if (!this.dropBefore) {
                ((Point)serializable).y += component.getHeight();
                point.y += component.getHeight();
            }
            serializable = SwingUtilities.convertPoint(component, (Point)serializable, this.palette.getRootPane());
            point = SwingUtilities.convertPoint(component, point, this.palette.getRootPane());
            Line2D.Double double_ = new Line2D.Double(((Point)serializable).x, ((Point)serializable).y, point.x, point.y);
            this.dropPane.setDropLine(double_);
        } else {
            JComponent jComponent;
            Category category = null;
            if (component instanceof CategoryList) {
                jComponent = (CategoryList)component;
                category = ((CategoryList)jComponent).getCategory();
            } else if (component instanceof CategoryButton) {
                jComponent = (CategoryButton)component;
                category = ((CategoryButton)jComponent).getCategory();
            }
            if (null == category || !category.dragOver(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                this.removeDropLine();
                this.targetItem = null;
                return;
            }
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            if (component instanceof CategoryList) {
                jComponent = (CategoryList)component;
                int n = ((JList)jComponent).locationToIndex(dropTargetDragEvent.getLocation());
                if (n < 0) {
                    this.dropPane.setDropLine(null);
                    this.targetItem = null;
                } else {
                    boolean bl = ((CategoryList)jComponent).getColumnCount() > 1;
                    Rectangle rectangle = ((JList)jComponent).getCellBounds(n, n);
                    this.dropBefore = bl ? dropTargetDragEvent.getLocation().x < rectangle.x + rectangle.width / 2 : dropTargetDragEvent.getLocation().y < rectangle.y + rectangle.height / 2;
                    Point point = rectangle.getLocation();
                    Point point2 = rectangle.getLocation();
                    if (bl) {
                        point2.y += rectangle.height;
                        if (!this.dropBefore) {
                            point.x += rectangle.width;
                            point2.x += rectangle.width;
                        }
                    } else {
                        point2.x += rectangle.width;
                        if (!this.dropBefore) {
                            point.y += rectangle.height;
                            point2.y += rectangle.height;
                        }
                    }
                    point = SwingUtilities.convertPoint(jComponent, point, this.palette.getRootPane());
                    point2 = SwingUtilities.convertPoint(jComponent, point2, this.palette.getRootPane());
                    Line2D.Double double_ = new Line2D.Double(point.x, point.y, point2.x, point2.y);
                    this.dropPane.setDropLine(double_);
                    this.targetItem = (Item)((JList)jComponent).getModel().getElementAt(n);
                }
            } else {
                this.targetItem = null;
                this.dropBefore = false;
            }
        }
    }

    private DragSourceListener getDragSourceListener() {
        if (null == this.dragSourceListener) {
            this.dragSourceListener = new DragSourceAdapter(){

                public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                    dragSourceDropEvent.getDragSourceContext().getDragSource().removeDragSourceListener(this);
                    DnDSupport.this.cleanupAfterDnD();
                }
            };
        }
        return this.dragSourceListener;
    }

    private void cleanupAfterDnD() {
        this.draggingItem = null;
        this.draggingCategory = null;
        this.targetItem = null;
        if (null != this.dragSourceCategoryList) {
            this.dragSourceCategoryList.resetRollover();
        }
        this.dragSourceCategoryList = null;
        this.removeDropLine();
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
        }
        this.removeTimer();
    }

    private void checkStoredGlassPane() {
        if (!DropGlassPane.isOriginalPaneStored()) {
            Component component = this.palette.getRootPane().getGlassPane();
            DropGlassPane.setOriginalPane(this.palette, component, component.isVisible());
            this.dropPane = DropGlassPane.getDefault(this.palette);
            this.palette.getRootPane().setGlassPane(this.dropPane);
            this.dropPane.revalidate();
            this.dropPane.validate();
            this.dropPane.setVisible(true);
        }
    }

    private void removeDropLine() {
        if (null != this.dropPane) {
            this.dropPane.setDropLine(null);
        }
    }
}

