/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.refactoring.api.AccessorImpl;
import org.netbeans.modules.refactoring.api.Context;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.ProgressSupport;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.ProgressProvider;
import org.netbeans.modules.refactoring.spi.ReadOnlyFilesHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;

public abstract class AbstractRefactoring {
    public static final int INIT = 0;
    public static final int PRE_CHECK = 1;
    public static final int PARAMETERS_CHECK = 2;
    public static final int PREPARE = 3;
    private int currentState = 0;
    private static final int PLUGIN_STEPS = 30;
    private ArrayList plugins;
    private ArrayList pluginsWithProgress;
    private ArrayList gbHandlers;
    private ProgressListener progressListener = new ProgressL();
    private ProgressSupport progressSupport;
    AbstractRefactoring caller;
    Lookup refactoringSource;
    private Context scope;

    protected AbstractRefactoring(Lookup lookup) {
        this.refactoringSource = lookup;
    }

    private Collection getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(RefactoringPluginFactory.class));
            for (RefactoringPluginFactory refactoringPluginFactory : result.allInstances()) {
                RefactoringPlugin refactoringPlugin = refactoringPluginFactory.createInstance(this);
                if (refactoringPlugin == null || this.caller != null && !refactoringPluginFactory.getClass().getClassLoader().equals(this.getClass().getClassLoader()) && refactoringPluginFactory.createInstance(this.caller) != null) continue;
                this.plugins.add(refactoringPlugin);
            }
        }
        return this.plugins;
    }

    Collection getGBHandlers() {
        if (this.gbHandlers == null) {
            this.gbHandlers = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(GuardedBlockHandlerFactory.class));
            Iterator iterator = result.allInstances().iterator();
            while (iterator.hasNext()) {
                GuardedBlockHandler guardedBlockHandler = ((GuardedBlockHandlerFactory)iterator.next()).createInstance(this);
                if (guardedBlockHandler == null) continue;
                this.gbHandlers.add(guardedBlockHandler);
            }
        }
        return this.gbHandlers;
    }

    public final Problem preCheck() {
        this.currentState = 1;
        return this.pluginsPreCheck(null);
    }

    public final Problem prepare(RefactoringSession refactoringSession) {
        Problem problem = null;
        if (this.currentState < 2) {
            problem = this.checkParameters();
        }
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        problem = this.pluginsPrepare(problem, refactoringSession);
        return problem;
    }

    public final Problem checkParameters() {
        Problem problem = this.fastCheckParameters();
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        this.currentState = 2;
        return this.pluginsCheckParams(problem);
    }

    public final Problem fastCheckParameters() {
        Problem problem = null;
        if (this.currentState < 1) {
            problem = this.preCheck();
        }
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        return this.pluginsFastCheckParams(problem);
    }

    public final synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(progressListener);
        if (this.pluginsWithProgress == null) {
            this.pluginsWithProgress = new ArrayList();
            for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
                if (!(refactoringPlugin instanceof ProgressProvider)) continue;
                ((ProgressProvider)((Object)refactoringPlugin)).addProgressListener(this.progressListener);
                this.pluginsWithProgress.add(refactoringPlugin);
            }
        }
    }

    public final synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(progressListener);
        }
        if (this.pluginsWithProgress != null) {
            for (ProgressProvider progressProvider : this.pluginsWithProgress) {
                progressProvider.removeProgressListener(this.progressListener);
            }
            this.pluginsWithProgress.clear();
            this.pluginsWithProgress = null;
        }
    }

    public final Context getContext() {
        if (this.scope == null) {
            this.scope = new Context(new InstanceContent());
        }
        return this.scope;
    }

    public final Lookup getRefactoringSource() {
        return this.refactoringSource;
    }

    public final void cancelRequest() {
        for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
            refactoringPlugin.cancelRequest();
        }
    }

    private Problem pluginsPreCheck(Problem problem) {
        for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.preCheck(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsPrepare(Problem problem, RefactoringSession refactoringSession) {
        Object object2;
        RefactoringElementsBag refactoringElementsBag = refactoringSession.getElementsBag();
        for (Object object2 : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(object2.prepare(refactoringElementsBag), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        if (!(this instanceof WhereUsedQuery) && (object2 = this.getROHandler()) != null) {
            Collection collection = SPIAccessor.DEFAULT.getReadOnlyFiles(refactoringElementsBag);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (FileObject fileObject : collection) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    for (FileObject fileObject2 : dataObject.files()) {
                        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObject2)) != 1) continue;
                        hashSet.add(fileObject2);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    hashSet.add(fileObject);
                }
            }
            problem = AbstractRefactoring.chainProblems(object2.createProblem(refactoringSession, hashSet), problem);
        }
        return problem;
    }

    private ReadOnlyFilesHandler getROHandler() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ReadOnlyFilesHandler.class));
        List list = (List)result.allInstances();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of ReadOnlyFilesHandler found in Lookup; only using first one: " + list);
        }
        return (ReadOnlyFilesHandler)list.get(0);
    }

    private Problem pluginsCheckParams(Problem problem) {
        for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.checkParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsFastCheckParams(Problem problem) {
        for (RefactoringPlugin refactoringPlugin : this.getPlugins()) {
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.fastCheckParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    static {
        APIAccessor.DEFAULT = new AccessorImpl();
    }

    private class ProgressL
    implements ProgressListener {
        private float progressStep;
        private float current;

        private ProgressL() {
        }

        public void start(ProgressEvent progressEvent) {
            this.progressStep = 30.0f / (float)progressEvent.getCount();
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) == 0) {
                this.current = 0.0f;
                if (progressEvent.getCount() == -1) {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), -1);
                } else {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), 30 * AbstractRefactoring.this.pluginsWithProgress.size());
                }
            } else {
                this.current = AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) * 30;
                this.fireProgressListenerStep((int)this.current);
            }
        }

        public void step(ProgressEvent progressEvent) {
            this.current += this.progressStep;
            this.fireProgressListenerStep((int)this.current);
        }

        public void stop(ProgressEvent progressEvent) {
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) == AbstractRefactoring.this.pluginsWithProgress.size() - 1) {
                this.fireProgressListenerStop();
            }
        }

        private void fireProgressListenerStart(int n, int n2) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStart(this, n, n2);
            }
        }

        private void fireProgressListenerStep() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this);
            }
        }

        private void fireProgressListenerStep(int n) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this, n);
            }
        }

        private void fireProgressListenerStop() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStop(this);
            }
        }
    }
}

