/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.awt.Container;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JEditorPane;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.impl.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class SimpleRefactoringElementImplementation
implements RefactoringElementImplementation {
    private boolean enabled = true;
    private int status = 0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void openInEditor() {
        PositionBounds positionBounds = this.getPosition();
        if (positionBounds == null) {
            return;
        }
        PositionRef positionRef = positionBounds.getBegin();
        CloneableEditorSupport cloneableEditorSupport = positionRef.getCloneableEditorSupport();
        cloneableEditorSupport.edit();
        JEditorPane[] jEditorPaneArray = cloneableEditorSupport.getOpenedPanes();
        if (jEditorPaneArray != null) {
            jEditorPaneArray[0].setCaretPosition(positionBounds.getEnd().getOffset());
            jEditorPaneArray[0].moveCaretPosition(positionRef.getOffset());
            SimpleRefactoringElementImplementation.getTopComponent(jEditorPaneArray[0]).requestActive();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ParametersPanel.class, (String)"ERR_ErrorOpeningEditor")));
        }
    }

    public void showPreview() {
        try {
            Reader reader = this.getReader();
            if (reader != null) {
                DiffView diffView = null;
                Reader reader2 = this.getFirstReader();
                FileObject fileObject = this.getParentFile();
                diffView = Diff.getDefault().createDiff(StreamSource.createSource((String)fileObject.getName(), (String)fileObject.getNameExt(), (String)this.getMimeType(), (Reader)reader2), StreamSource.createSource((String)"Proposed refactoring", (String)("Refactored " + fileObject.getNameExt()), (String)this.getMimeType(), (Reader)reader));
                UI.setComponentForRefactoringPreview(diffView.getComponent());
            } else {
                UI.setComponentForRefactoringPreview(null);
            }
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    private Reader getReader() {
        String string = this.getNewFileContent();
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    protected String getNewFileContent() {
        return null;
    }

    private Reader getFirstReader() throws IOException {
        PositionRef positionRef = this.getPosition().getBegin();
        CloneableEditorSupport cloneableEditorSupport = positionRef.getCloneableEditorSupport();
        return new InputStreamReader(cloneableEditorSupport.getInputStream());
    }

    private String getMimeType() {
        return this.getParentFile().getMIMEType();
    }

    private static final TopComponent getTopComponent(Container container) {
        while (!(container instanceof TopComponent)) {
            container = container.getParent();
        }
        return (TopComponent)container;
    }

    public void undoChange() {
    }
}

