/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.Util;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoManager
extends FileChangeAdapter
implements DocumentListener,
ChangeListener {
    private LinkedList<LinkedList<UndoItem>> undoList;
    private LinkedList<LinkedList<UndoItem>> redoList;
    private final HashSet<CloneableEditorSupport> allCES = new HashSet();
    private final HashMap<Document, CloneableEditorSupport> documentToCES = new HashMap();
    private final HashMap<InvalidationListener, Collection<? extends CloneableEditorSupport>> listenerToCES = new HashMap();
    private boolean listenersRegistered = false;
    public static final String PROP_STATE = "state";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private boolean dontDeleteUndo = false;
    private IdentityHashMap<LinkedList, String> descriptionMap;
    private String description;
    private ProgressListener progress;
    private static UndoManager instance;
    private int stepCounter = 0;

    public static UndoManager getDefault() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    private UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
    }

    private UndoManager(ProgressListener progressListener) {
        this();
        this.progress = progressListener;
    }

    public void setUndoDescription(String string) {
        this.description = string;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.transactionStart = true;
        this.unregisterListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(boolean bl) {
        try {
            this.description = null;
            this.dontDeleteUndo = true;
            if (bl && !this.undoList.isEmpty()) {
                this.undoList.removeFirst();
            } else if (this.isUndoAvailable() && this.getUndoDescription() == null) {
                this.descriptionMap.remove(this.undoList.removeFirst());
                this.dontDeleteUndo = false;
            }
            this.invalidate(null);
            this.dontDeleteUndo = false;
        }
        finally {
            this.registerListeners();
        }
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.isUndoAvailable()) {
            boolean bl = true;
            try {
                this.transactionStarted();
                this.wasUndo = true;
                LinkedList<UndoItem> linkedList = this.undoList.getFirst();
                this.fireProgressListenerStart(0, linkedList.size());
                this.undoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.redoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.redoList.getFirst(), this.descriptionMap.remove(linkedList));
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.undo();
                    if (!(undoItem instanceof SessionUndoItem)) continue;
                    this.addItem(undoItem);
                }
                bl = false;
            }
            finally {
                try {
                    this.wasUndo = false;
                    this.transactionEnded(bl);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.isRedoAvailable()) {
            boolean bl = true;
            try {
                this.transactionStarted();
                this.wasRedo = true;
                LinkedList<UndoItem> linkedList = this.redoList.getFirst();
                this.fireProgressListenerStart(1, linkedList.size());
                this.redoList.removeFirst();
                Iterator iterator = linkedList.iterator();
                this.description = this.descriptionMap.remove(linkedList);
                while (iterator.hasNext()) {
                    this.fireProgressListenerStep();
                    UndoItem undoItem = (UndoItem)iterator.next();
                    undoItem.redo();
                    if (!(undoItem instanceof SessionUndoItem)) continue;
                    this.addItem(undoItem);
                }
                bl = false;
            }
            finally {
                try {
                    this.wasRedo = false;
                    this.transactionEnded(bl);
                }
                finally {
                    this.fireProgressListenerStop();
                    this.fireStateChange();
                }
            }
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        BackupFacility.getDefault().clear();
        this.fireStateChange();
    }

    public void addItem(RefactoringSession refactoringSession) {
        this.addItem(new SessionUndoItem(refactoringSession));
    }

    public void addItem(UndoItem undoItem) {
        if (this.wasUndo) {
            LinkedList<UndoItem> linkedList = this.redoList.getFirst();
            linkedList.addFirst(undoItem);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList<UndoItem> linkedList = this.undoList.getFirst();
            linkedList.addFirst(undoItem);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireStateChange() {
        this.pcs.firePropertyChange(PROP_STATE, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(Collection<? extends CloneableEditorSupport> collection, InvalidationListener invalidationListener) {
        HashSet<CloneableEditorSupport> hashSet = this.allCES;
        synchronized (hashSet) {
            this.registerListeners();
        }
        for (final CloneableEditorSupport cloneableEditorSupport : collection) {
            final StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            if (styledDocument != null) {
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        HashSet hashSet = UndoManager.this.allCES;
                        synchronized (hashSet) {
                            if (UndoManager.this.allCES.add(cloneableEditorSupport)) {
                                cloneableEditorSupport.addChangeListener((ChangeListener)UndoManager.this);
                                styledDocument.addDocumentListener(UndoManager.this);
                                UndoManager.this.documentToCES.put(styledDocument, cloneableEditorSupport);
                            }
                        }
                    }
                });
                continue;
            }
            HashSet<CloneableEditorSupport> hashSet2 = this.allCES;
            synchronized (hashSet2) {
                if (this.allCES.add(cloneableEditorSupport)) {
                    cloneableEditorSupport.addChangeListener((ChangeListener)this);
                }
            }
        }
        hashSet = this.allCES;
        synchronized (hashSet) {
            if (invalidationListener != null) {
                this.listenerToCES.put(invalidationListener, collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatching(InvalidationListener invalidationListener) {
        HashSet<CloneableEditorSupport> hashSet = this.allCES;
        synchronized (hashSet) {
            this.listenerToCES.remove(invalidationListener);
            this.clearIfPossible();
        }
    }

    private void registerListeners() {
        if (this.listenersRegistered) {
            return;
        }
        Util.addFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport object : this.allCES) {
            object.addChangeListener((ChangeListener)this);
        }
        for (Document document : this.documentToCES.keySet()) {
            document.addDocumentListener(this);
        }
        this.listenersRegistered = true;
    }

    private void unregisterListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        Util.removeFileSystemsListener((FileChangeListener)this);
        for (CloneableEditorSupport object : this.allCES) {
            object.removeChangeListener((ChangeListener)this);
        }
        for (Document document : this.documentToCES.keySet()) {
            document.removeDocumentListener(this);
        }
        this.listenersRegistered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(CloneableEditorSupport cloneableEditorSupport) {
        LinkedList<LinkedList<UndoItem>> linkedList = this.undoList;
        synchronized (linkedList) {
            if (!(this.wasRedo || this.wasUndo || this.dontDeleteUndo)) {
                this.clear();
            }
            HashSet<CloneableEditorSupport> hashSet = this.allCES;
            synchronized (hashSet) {
                if (cloneableEditorSupport == null) {
                    for (InvalidationListener invalidationListener : this.listenerToCES.keySet()) {
                        invalidationListener.invalidateObject();
                    }
                    this.listenerToCES.clear();
                } else {
                    Iterator<Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>>> iterator = this.listenerToCES.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<InvalidationListener, Collection<? extends CloneableEditorSupport>> entry = iterator.next();
                        if (!entry.getValue().contains(cloneableEditorSupport)) continue;
                        entry.getKey().invalidateObject();
                        iterator.remove();
                    }
                }
                this.clearIfPossible();
            }
        }
    }

    private void clearIfPossible() {
        if (this.listenerToCES.isEmpty() && this.undoList.isEmpty() && this.redoList.isEmpty()) {
            this.unregisterListeners();
            this.allCES.clear();
            this.documentToCES.clear();
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        if (fileObject != null) {
            CloneableEditorSupport cloneableEditorSupport;
            DataObject dataObject;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null && (cloneableEditorSupport = this.documentToCES.get(editorCookie.getDocument())) != null) {
                this.invalidate(cloneableEditorSupport);
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.invalidate(this.documentToCES.get(documentEvent.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.invalidate(this.documentToCES.get(documentEvent.getDocument()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        HashSet<CloneableEditorSupport> hashSet = this.allCES;
        synchronized (hashSet) {
            CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)changeEvent.getSource();
            StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            Iterator<Map.Entry<Document, CloneableEditorSupport>> iterator = this.documentToCES.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Document, CloneableEditorSupport> entry = iterator.next();
                if (entry.getValue() != cloneableEditorSupport) continue;
                entry.getKey().removeDocumentListener(this);
                iterator.remove();
                break;
            }
            if (styledDocument != null) {
                this.documentToCES.put(styledDocument, cloneableEditorSupport);
                styledDocument.addDocumentListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        HashSet<CloneableEditorSupport> hashSet = this.allCES;
        synchronized (hashSet) {
            this.unregisterListeners();
        }
        try {
            LifecycleManager.getDefault().saveAll();
        }
        finally {
            hashSet = this.allCES;
            synchronized (hashSet) {
                this.registerListeners();
            }
        }
    }

    private void fireProgressListenerStart(int n, int n2) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, n, n2));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    private final class SessionUndoItem
    implements UndoItem {
        private RefactoringSession change;

        public SessionUndoItem(RefactoringSession refactoringSession) {
            this.change = refactoringSession;
        }

        public void undo() {
            this.change.undoRefactoring(false);
        }

        public void redo() {
            this.change.doRefactoring(false);
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

