/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Cache {
    private static Map cache;

    Cache() {
    }

    public static void put(SuggestionContext suggestionContext, List list) {
        FileObject fileObject = suggestionContext.getFileObject();
        String string = Cache.createKey(fileObject);
        if (string == null) {
            return;
        }
        if (list == null || list.isEmpty()) {
            long l = fileObject.lastModified().getTime();
            Cache.cache().put(string, new long[]{l, System.currentTimeMillis()});
        } else {
            Cache.cache().remove(string);
        }
    }

    public static List get(SuggestionContext suggestionContext) {
        FileObject fileObject = suggestionContext.getFileObject();
        String string = Cache.createKey(fileObject);
        if (string == null) {
            return null;
        }
        Object v = Cache.cache().get(string);
        if (v != null) {
            if (((long[])v)[0] >= fileObject.lastModified().getTime()) {
                return Collections.EMPTY_LIST;
            }
            Cache.cache().remove(string);
        }
        return null;
    }

    private static String createKey(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private static Map cache() {
        if (cache == null) {
            Cache.load();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        ObjectInputStream objectInputStream = null;
        try {
            File file = Cache.getCacheFile(false);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            if (objectInputStream.readInt() == 1) {
                cache = (Map)objectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (cache == null) {
            cache = new HashMap(1113);
        }
        long l = System.currentTimeMillis() - 1468800000L;
        if (Settings.getDefault().getModificationTime() > l) {
            l = Settings.getDefault().getModificationTime();
        }
        Iterator iterator = cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((long[])entry.getValue())[1] >= l) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store() {
        if (cache == null) {
            return;
        }
        try {
            File file = Cache.getCacheFile(true);
            OutputStream outputStream = new FileOutputStream(file);
            outputStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(cache);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            cache = null;
        }
    }

    private static File getCacheFile(boolean bl) throws IOException {
        String string = System.getProperty("netbeans.user") + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "all-todos.ser";
        File file = new File(string);
        if (bl && !file.exists()) {
            File file2 = file.getParentFile();
            file2.mkdirs();
            file.createNewFile();
        }
        return file;
    }
}

