/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.docscan.Cache;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.docscan.SourceCodeCommentParser;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakSet;

public final class SourceTaskProvider
extends DocumentSuggestionProvider
implements PropertyChangeListener {
    static final String TYPE = "nb-tasklist-scannedtask";
    private WeakSet agents = new WeakSet();
    private SuggestionContext env;
    private Settings settings;

    public String getType() {
        return TYPE;
    }

    public void notifyFinish() {
        Cache.store();
        this.settings = null;
    }

    public void notifyPrepare() {
        this.settings = Settings.getDefault();
    }

    public void notifyRun() {
    }

    public void notifyStop() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (("taskTags".equals(propertyChangeEvent.getPropertyName()) || "skipComments".equals(propertyChangeEvent.getPropertyName())) && this.env == null) {
            return;
        }
    }

    public List scan(SuggestionContext suggestionContext) {
        SuggestionManager suggestionManager = SuggestionManager.getDefault();
        if (!suggestionManager.isEnabled(TYPE)) {
            return null;
        }
        try {
            List list;
            if (!DataObject.find((FileObject)suggestionContext.getFileObject()).isModified() && (list = Cache.get(suggestionContext)) != null) {
                return list;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        boolean bl = this.settings().getSkipComments();
        List list = bl ? this.scanCommentsOnly(suggestionContext) : this.scanAll(suggestionContext);
        Cache.put(suggestionContext, list);
        return list;
    }

    private List scanCommentsOnly(SuggestionContext suggestionContext) {
        ArrayList<Suggestion> arrayList = new ArrayList<Suggestion>();
        String string = suggestionContext.getFileObject().getExt();
        SourceCodeCommentParser sourceCodeCommentParser = string.equalsIgnoreCase("java") || string.equalsIgnoreCase("c") || string.equalsIgnoreCase("cpp") ? new SourceCodeCommentParser("//", "/*", "*/") : (string.equalsIgnoreCase("html") || string.equalsIgnoreCase("htm") || string.equalsIgnoreCase("xml") ? new SourceCodeCommentParser("<!--", "-->") : (string.equalsIgnoreCase("jsp") ? new SourceCodeCommentParser("<%--", "--%>") : (string.equalsIgnoreCase("sh") ? new SourceCodeCommentParser("#") : new SourceCodeCommentParser())));
        CharSequence charSequence = suggestionContext.getCharSequence();
        sourceCodeCommentParser.setDocument(suggestionContext);
        SourceCodeCommentParser.CommentRegion commentRegion = new SourceCodeCommentParser.CommentRegion();
        TaskTag taskTag = null;
        try {
            Matcher matcher = this.settings.getTaskTags().getScanRegexp().matcher(charSequence);
            int n = charSequence.length();
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            if (!sourceCodeCommentParser.nextRegion(commentRegion)) {
                return arrayList;
            }
            while (n3 < n && matcher.find(n3)) {
                boolean bl;
                int n5 = matcher.start();
                int n6 = matcher.end();
                boolean bl2 = false;
                do {
                    bl = true;
                    if (n5 < commentRegion.start) {
                        bl2 = true;
                        continue;
                    }
                    if (n5 <= commentRegion.stop) continue;
                    bl = false;
                    if (sourceCodeCommentParser.nextRegion(commentRegion)) continue;
                    return arrayList;
                } while (!bl);
                if (bl2) {
                    n3 = n6;
                    continue;
                }
                taskTag = this.getTag(charSequence, n5, n6);
                int n7 = 97;
                int n8 = n5;
                while (n5 >= n3) {
                    char c = charSequence.charAt(n5);
                    n7 = c;
                    if (c == '\n') break;
                    if (n7 != 32 && n7 != 9) {
                        n8 = n5;
                    }
                    --n5;
                }
                n5 = n8;
                n8 = n6;
                while (n6 < n && (n7 = (int)charSequence.charAt(n6)) != 10 && n7 != 13) {
                    if (n7 != 32 && n7 != 9) {
                        n8 = n6;
                    }
                    ++n6;
                }
                while (n4 <= n5) {
                    if (charSequence.charAt(n4) == '\n') {
                        ++n2;
                    }
                    ++n4;
                }
                n3 = n6;
                String string2 = ((Object)charSequence.subSequence(n5, n8 + 1)).toString();
                DataObject dataObject = DataObject.find((FileObject)suggestionContext.getFileObject());
                Line line = TLUtils.getLineByNumber((DataObject)dataObject, (int)n2);
                Suggestion suggestion = this.prepareSuggestion(taskTag, string2, line);
                arrayList.add(suggestion);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return arrayList;
    }

    private List scanAll(SuggestionContext suggestionContext) {
        ArrayList<Suggestion> arrayList = new ArrayList<Suggestion>();
        CharSequence charSequence = suggestionContext.getCharSequence();
        TaskTag taskTag = null;
        try {
            int n = 0;
            int n2 = 1;
            int n3 = charSequence.length();
            Matcher matcher = this.settings().getTaskTags().getScanRegexp().matcher(charSequence);
            while (n < n3 && matcher.find(n)) {
                int n4;
                int n5 = matcher.end();
                taskTag = this.getTag(charSequence, n4, n5);
                int n6 = 97;
                int n7 = n4;
                for (n4 = matcher.start(); n4 >= n; --n4) {
                    char c = charSequence.charAt(n4);
                    n6 = c;
                    if (c == '\n') break;
                    if (n6 == 32 || n6 == 9) continue;
                    n7 = n4;
                }
                n4 = n7;
                n7 = n5;
                while (n5 < n3 && (n6 = (int)charSequence.charAt(n5)) != 10 && n6 != 13) {
                    if (n6 != 32 && n6 != 9) {
                        n7 = n5;
                    }
                    ++n5;
                }
                for (int i = n; i <= n4; ++i) {
                    if (charSequence.charAt(i) != '\n') continue;
                    ++n2;
                }
                n = n5;
                String string = ((Object)charSequence.subSequence(n4, n7 + 1)).toString();
                DataObject dataObject = DataObject.find((FileObject)suggestionContext.getFileObject());
                Line line = TLUtils.getLineByNumber((DataObject)dataObject, (int)n2);
                Suggestion suggestion = this.prepareSuggestion(taskTag, string, line);
                arrayList.add(suggestion);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private Suggestion prepareSuggestion(TaskTag taskTag, String string, Line line) {
        SuggestionAgent suggestionAgent;
        Suggestion suggestion = null;
        if (line != null && (suggestionAgent = this.getAgent(line)) != null) {
            suggestion = suggestionAgent.getSuggestion();
            suggestionAgent.setSummary(string);
            if (taskTag != null) {
                suggestionAgent.setPriority(taskTag.getPriority());
            }
        }
        if (suggestion == null) {
            suggestionAgent = SuggestionManager.getDefault();
            SuggestionAgent suggestionAgent2 = suggestionAgent.createSuggestion(null, TYPE, string, null, (Object)this);
            suggestionAgent2.setLine(line);
            if (taskTag != null) {
                suggestionAgent2.setPriority(taskTag.getPriority());
            }
            this.agents.add((Object)suggestionAgent2);
            suggestion = suggestionAgent2.getSuggestion();
        }
        return suggestion;
    }

    private TaskTag getTag(CharSequence charSequence, int n, int n2) {
        TaskTag taskTag = this.settings().getTaskTags().getTag(charSequence, n + 1, n2 - n - 1);
        return taskTag;
    }

    private Settings settings() {
        if (this.settings == null) {
            this.settings = Settings.getDefault();
        }
        return this.settings;
    }

    private SuggestionAgent getAgent(Line line) {
        Iterator iterator = this.agents.iterator();
        while (iterator.hasNext()) {
            SuggestionAgent suggestionAgent = (SuggestionAgent)iterator.next();
            if (suggestionAgent == null || !line.equals(suggestionAgent.getSuggestion().getLine())) continue;
            return suggestionAgent;
        }
        return null;
    }
}

