/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.fold;

import java.util.Collection;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyExecution;
import org.netbeans.modules.editor.fold.FoldOperationImpl;

public final class FoldHierarchy {
    public static final FoldType ROOT_FOLD_TYPE = new FoldType("root-fold");
    private static boolean apiPackageAccessorRegistered;
    private FoldHierarchyExecution execution;

    private static void ensureApiAccessorRegistered() {
        if (!apiPackageAccessorRegistered) {
            apiPackageAccessorRegistered = true;
            ApiPackageAccessor.register(new ApiPackageAccessorImpl());
        }
    }

    public static synchronized FoldHierarchy get(JTextComponent jTextComponent) {
        return FoldHierarchyExecution.getOrCreateFoldHierarchy(jTextComponent);
    }

    private FoldHierarchy(FoldHierarchyExecution foldHierarchyExecution) {
        this.execution = foldHierarchyExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this.execution.lock();
    }

    public void unlock() {
        this.execution.unlock();
    }

    public void collapse(Fold fold) {
        this.collapse(Collections.singletonList(fold));
    }

    public void collapse(Collection collection) {
        this.execution.collapse(collection);
    }

    public void expand(Fold fold) {
        this.expand(Collections.singletonList(fold));
    }

    public void expand(Collection collection) {
        this.execution.expand(collection);
    }

    public void toggle(Fold fold) {
        if (fold.isCollapsed()) {
            this.expand(fold);
        } else {
            this.collapse(fold);
        }
    }

    public JTextComponent getComponent() {
        return this.execution.getComponent();
    }

    public Fold getRootFold() {
        return this.execution.getRootFold();
    }

    public void addFoldHierarchyListener(FoldHierarchyListener foldHierarchyListener) {
        this.execution.addFoldHierarchyListener(foldHierarchyListener);
    }

    public void removeFoldHierarchyListener(FoldHierarchyListener foldHierarchyListener) {
        this.execution.removeFoldHierarchyListener(foldHierarchyListener);
    }

    public String toString() {
        return this.execution.toString();
    }

    static {
        FoldHierarchy.ensureApiAccessorRegistered();
    }

    private static final class ApiPackageAccessorImpl
    extends ApiPackageAccessor {
        private ApiPackageAccessorImpl() {
        }

        public FoldHierarchy createFoldHierarchy(FoldHierarchyExecution foldHierarchyExecution) {
            return new FoldHierarchy(foldHierarchyExecution);
        }

        public Fold createFold(FoldOperationImpl foldOperationImpl, FoldType foldType, String string, boolean bl, Document document, int n, int n2, int n3, int n4, Object object) throws BadLocationException {
            return new Fold(foldOperationImpl, foldType, string, bl, document, n, n2, n3, n4, object);
        }

        public FoldHierarchyEvent createFoldHierarchyEvent(FoldHierarchy foldHierarchy, Fold[] foldArray, Fold[] foldArray2, FoldStateChange[] foldStateChangeArray, int n, int n2) {
            return new FoldHierarchyEvent(foldHierarchy, foldArray, foldArray2, foldStateChangeArray, n, n2);
        }

        public FoldStateChange createFoldStateChange(Fold fold) {
            return new FoldStateChange(fold);
        }

        public void foldSetParent(Fold fold, Fold fold2) {
            fold.setParent(fold2);
        }

        public void foldExtractToChildren(Fold fold, int n, int n2, Fold fold2) {
            fold.extractToChildren(n, n2, fold2);
        }

        public Fold foldReplaceByChildren(Fold fold, int n) {
            return fold.replaceByChildren(n);
        }

        public void foldSetCollapsed(Fold fold, boolean bl) {
            fold.setCollapsed(bl);
        }

        public void foldSetDescription(Fold fold, String string) {
            fold.setDescription(string);
        }

        public void foldSetStartOffset(Fold fold, Document document, int n) throws BadLocationException {
            fold.setStartOffset(document, n);
        }

        public void foldSetEndOffset(Fold fold, Document document, int n) throws BadLocationException {
            fold.setEndOffset(document, n);
        }

        public boolean foldIsStartDamaged(Fold fold) {
            return fold.isStartDamaged();
        }

        public boolean foldIsEndDamaged(Fold fold) {
            return fold.isEndDamaged();
        }

        public boolean foldIsExpandNecessary(Fold fold) {
            return fold.isExpandNecessary();
        }

        public void foldInsertUpdate(Fold fold, DocumentEvent documentEvent) {
            fold.insertUpdate(documentEvent);
        }

        public void foldRemoveUpdate(Fold fold, DocumentEvent documentEvent) {
            fold.removeUpdate(documentEvent);
        }

        public FoldOperationImpl foldGetOperation(Fold fold) {
            return fold.getOperation();
        }

        public int foldGetRawIndex(Fold fold) {
            return fold.getRawIndex();
        }

        public void foldSetRawIndex(Fold fold, int n) {
            fold.setRawIndex(n);
        }

        public void foldUpdateRawIndex(Fold fold, int n) {
            fold.updateRawIndex(n);
        }

        public Object foldGetExtraInfo(Fold fold) {
            return fold.getExtraInfo();
        }

        public void foldStateChangeCollapsedChanged(FoldStateChange foldStateChange) {
            foldStateChange.collapsedChanged();
        }

        public void foldStateChangeDescriptionChanged(FoldStateChange foldStateChange) {
            foldStateChange.descriptionChanged();
        }

        public void foldStateChangeStartOffsetChanged(FoldStateChange foldStateChange, int n) {
            foldStateChange.startOffsetChanged(n);
        }

        public void foldStateChangeEndOffsetChanged(FoldStateChange foldStateChange, int n) {
            foldStateChange.endOffsetChanged(n);
        }
    }
}

