/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseSettingsInitializer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.ext.ExtSettingsInitializer;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.impl.KitsTracker;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.BasePrintOptions;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.util.Utilities;

public class NbEditorSettingsInitializer
extends Settings.AbstractInitializer {
    private static final Logger LOG = Logger.getLogger(NbEditorSettingsInitializer.class.getName());
    public static final String NAME = "nb-editor-settings-initializer";
    private static boolean mainInitDone;

    public static void init() {
        if (!mainInitDone) {
            mainInitDone = true;
            Settings.addInitializer((Settings.Initializer)new BaseSettingsInitializer(), (int)0);
            Settings.addInitializer((Settings.Initializer)new ExtSettingsInitializer(), (int)0);
            Settings.addInitializer((Settings.Initializer)new NbEditorSettingsInitializer());
            Settings.reset();
            BasePrintOptions basePrintOptions = (BasePrintOptions)BasePrintOptions.findObject(BasePrintOptions.class, (boolean)true);
            basePrintOptions.init();
        }
    }

    public NbEditorSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class clazz, Map map) {
        if (clazz == BaseKit.class) {
            map.put("toolbarVisible", Boolean.TRUE);
            map.put("lineNumberVisible", SettingsDefaults.defaultLineNumberVisible);
            int n = Utilities.isMac() ? 4 : 128;
            map.put("hyperlink-activation-modifiers", n);
        }
        if (clazz == NbEditorKit.class && AllOptionsFolder.getDefault().baseInitialized()) {
            map.put("popup-menu-action-name-list", OptionUtilities.getPopupStrings(OptionUtilities.getGlobalPopupMenuItems()));
        }
        List list = KitsTracker.getInstance().getMimeTypesForKitClass(clazz);
        for (String string : list) {
            MimePath mimePath;
            BaseOptions baseOptions;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Initializing settings for '" + string + "', " + clazz);
            }
            if ((baseOptions = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)(mimePath = MimePath.parse((String)string))).lookup(BaseOptions.class))) != null || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Top level mime type '" + string + "' with no BaseOptions.");
        }
    }
}

