/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.SystemAction;

public class ActionsList {
    private static final Logger LOG = Logger.getLogger(ActionsList.class.getName());
    private final List all;
    private final List actions;

    protected ActionsList(List list) {
        this(list, false);
    }

    protected ActionsList(List list, boolean bl) {
        List[] listArray = ActionsList.convertImpl(list == null ? Collections.emptyList() : list, bl);
        this.all = listArray[0];
        this.actions = listArray[1];
    }

    public List getAllInstances() {
        return this.all;
    }

    public List getActionsOnly() {
        return this.actions;
    }

    public static List convert(List list) {
        List[] listArray = ActionsList.convertImpl(list, false);
        return listArray[0];
    }

    private static List[] convertImpl(List list, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            DataObject dataObject = null;
            if (e instanceof DataObject) {
                dataObject = (DataObject)e;
            } else if (e instanceof FileObject) {
                try {
                    dataObject = DataObject.find((FileObject)((FileObject)e));
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            if (dataObject != null) {
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                if (instanceCookie != null) {
                    try {
                        Object object;
                        if (Action.class.isAssignableFrom(instanceCookie.instanceClass()) || SystemAction.class.isAssignableFrom(instanceCookie.instanceClass())) {
                            object = instanceCookie.instanceCreate();
                            arrayList.add(object);
                            arrayList2.add(object);
                            continue;
                        }
                        if (DataFolder.class.isAssignableFrom(instanceCookie.instanceClass()) && bl) continue;
                        object = instanceCookie.instanceCreate();
                        arrayList.add(object);
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Can't instantiate object", exception);
                    }
                    continue;
                }
                if (dataObject instanceof DataFolder) {
                    arrayList.add(dataObject);
                    continue;
                }
                arrayList.add(dataObject.getName());
                continue;
            }
            arrayList.add(e);
            if (!(e instanceof Action) && !(e instanceof SystemAction)) continue;
            arrayList2.add(e);
        }
        return new List[]{arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList), arrayList2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList2)};
    }
}

