/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.DiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Version;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)Log.java\t1.64 06/07/28")
public class Log {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    public final int MaxErrors;
    public final int MaxWarnings;
    private final boolean showSourceLine;
    public boolean promptOnError;
    public boolean emitWarnings;
    private boolean enforceMandatoryWarnings;
    public boolean dumpOnError;
    public boolean multipleErrors;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter diagFormatter;
    private JCDiagnostic.Factory diags;
    protected JCDiagnostic.DiagnosticSource source;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    private Map<JavaFileObject, Map<JCTree, Integer>> endPosTables;
    private char[] buf = null;
    private int bp;
    private int line;
    private int lineStart;

    @Deprecated
    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        DiagnosticListener diagListener;
        context.put(logKey, this);
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-Xlint:none") == null;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
        this.showSourceLine = options.get("rawDiagnostics") == null;
        this.diagFormatter = DiagnosticFormatter.instance(context);
        this.diagListener = diagListener = context.get(DiagnosticListener.class);
        Source source = Source.instance(context);
        this.enforceMandatoryWarnings = source.enforceMandatoryWarnings();
    }

    private int getIntOption(Options options, String optionName, int defaultValue) {
        String s = options.get(optionName);
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter result = context.get(outKey);
        if (result == null) {
            result = new PrintWriter(System.err);
            context.put(outKey, result);
        }
        return result;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter defaultWriter) {
        this(context, defaultWriter, defaultWriter, defaultWriter);
    }

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject name, Map<JCTree, Integer> table) {
        if (this.endPosTables == null) {
            this.endPosTables = new HashMap<JavaFileObject, Map<JCTree, Integer>>();
        }
        this.endPosTables.put(name, table);
    }

    public JavaFileObject useSource(final JavaFileObject name) {
        JavaFileObject prev = this.currentSource();
        if (name != prev) {
            this.source = new JCDiagnostic.DiagnosticSource(){

                @Override
                public JavaFileObject getFile() {
                    return name;
                }

                @Override
                public CharSequence getName() {
                    return DefaultFileManager.getJavacBaseFileName(this.getFile());
                }

                @Override
                public int getLineNumber(int pos) {
                    return Log.this.getLineNumber(pos);
                }

                @Override
                public int getColumnNumber(int pos) {
                    return Log.this.getColumnNumber(pos);
                }

                @Override
                public Map<JCTree, Integer> getEndPosTable() {
                    return Log.this.endPosTables == null ? null : (Map)Log.this.endPosTables.get(name);
                }
            };
            this.buf = null;
        }
        return prev;
    }

    protected void setBuf(char[] newBuf) {
        this.buf = newBuf;
        this.bp = 0;
        this.lineStart = 0;
        this.line = 1;
    }

    protected char[] getBuf() {
        return this.buf;
    }

    public JavaFileObject currentSource() {
        return this.source == null ? null : this.source.getFile();
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    protected boolean shouldReport(JavaFileObject file, int pos) {
        boolean shouldReport;
        if (this.multipleErrors || file == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> coords = new Pair<JavaFileObject, Integer>(file, pos);
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int pos, PrintWriter writer) {
        int lineEnd;
        if (!this.findLine(pos)) {
            return;
        }
        for (lineEnd = this.lineStart; lineEnd < this.buf.length && this.buf[lineEnd] != '\r' && this.buf[lineEnd] != '\n'; ++lineEnd) {
        }
        if (lineEnd - this.lineStart == 0) {
            return;
        }
        Log.printLines(writer, new String(this.buf, this.lineStart, lineEnd - this.lineStart));
        this.bp = this.lineStart;
        while (this.bp < pos) {
            writer.print(this.buf[this.bp] == '\t' ? "\t" : " ");
            ++this.bp;
        }
        writer.println("^");
        writer.flush();
    }

    protected static char[] getCharContent(JavaFileObject fileObject) throws IOException {
        CharSequence cs = fileObject.getCharContent(true);
        if (cs instanceof CharBuffer) {
            return DefaultFileManager.toArray((CharBuffer)cs);
        }
        return ((Object)cs).toString().toCharArray();
    }

    private boolean findLine(int pos) {
        if (pos == -1 || this.currentSource() == null) {
            return false;
        }
        try {
            if (this.buf == null) {
                this.buf = Log.getCharContent(this.currentSource());
                this.lineStart = 0;
                this.line = 1;
            } else if (this.lineStart > pos) {
                this.lineStart = 0;
                this.line = 1;
            }
            this.bp = this.lineStart;
            while (this.bp < this.buf.length && this.bp < pos) {
                switch (this.buf[this.bp++]) {
                    case '\r': {
                        if (this.bp >= this.buf.length || this.buf[this.bp] == '\n') {
                            // empty if block
                        }
                        ++this.line;
                        this.lineStart = ++this.bp;
                        break;
                    }
                    case '\n': {
                        ++this.line;
                        this.lineStart = this.bp;
                    }
                }
            }
            return this.bp <= this.buf.length;
        }
        catch (IOException e) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable", new Object[0]));
            this.errWriter.flush();
            this.buf = new char[0];
            return false;
        }
    }

    public static void printLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    public void error(String key, Object ... args) {
        this.report(this.diags.error(this.source, null, key, args));
    }

    public void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.error(this.source, pos, key, args));
    }

    public void error(int pos, String key, Object ... args) {
        this.report(this.diags.error(this.source, this.wrap(pos), key, args));
    }

    public void warning(String key, Object ... args) {
        this.report(this.diags.warning(this.source, null, key, args));
    }

    public void warning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.warning(this.source, pos, key, args));
    }

    public void warning(int pos, String key, Object ... args) {
        this.report(this.diags.warning(this.source, this.wrap(pos), key, args));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        if (this.enforceMandatoryWarnings) {
            this.report(this.diags.mandatoryWarning(this.source, pos, key, args));
        } else {
            this.report(this.diags.warning(this.source, pos, key, args));
        }
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.writeDiagnostic(this.diags.warning(this.source, pos, key, args));
        ++this.nwarnings;
    }

    public void note(String key, Object ... args) {
        this.report(this.diags.note(this.source, null, key, args));
    }

    public void note(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.note(this.source, pos, key, args));
    }

    public void note(int pos, String key, Object ... args) {
        this.report(this.diags.note(this.source, this.wrap(pos), key, args));
    }

    public void mandatoryNote(String key, Object ... args) {
        if (this.enforceMandatoryWarnings) {
            this.report(this.diags.mandatoryNote(key, args));
        } else {
            this.report(this.diags.note(key, args));
        }
    }

    private JCDiagnostic.DiagnosticPosition wrap(int pos) {
        return pos == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(pos);
    }

    public void report(JCDiagnostic diagnostic) {
        switch (diagnostic.getType()) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                if (!this.emitWarnings && !diagnostic.isMandatory()) break;
                this.writeDiagnostic(diagnostic);
                break;
            }
            case WARNING: {
                if (!this.emitWarnings && !diagnostic.isMandatory() || this.nwarnings >= this.MaxWarnings) break;
                this.writeDiagnostic(diagnostic);
                ++this.nwarnings;
                break;
            }
            case ERROR: {
                if (this.nerrors >= this.MaxErrors || !this.shouldReport(diagnostic.getSource(), diagnostic.getIntPosition())) break;
                this.writeDiagnostic(diagnostic);
                ++this.nerrors;
            }
        }
    }

    protected void writeDiagnostic(JCDiagnostic diag) {
        int pos;
        if (this.diagListener != null) {
            try {
                this.diagListener.report(diag);
                return;
            }
            catch (Throwable t) {
                throw new ClientCodeException(t);
            }
        }
        PrintWriter writer = this.getWriterForDiagnosticType(diag.getType());
        Log.printLines(writer, this.diagFormatter.format(diag));
        if (this.showSourceLine && (pos = diag.getIntPosition()) != -1) {
            JavaFileObject prev = this.useSource(diag.getSource());
            this.printErrLine(pos, writer);
            this.useSource(prev);
        }
        if (this.promptOnError) {
            switch (diag.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String key, Object ... args) {
        return Messages.getDefaultLocalizedString("compiler.misc." + key, args);
    }

    private void printRawError(int pos, String msg) {
        if (!this.findLine(pos)) {
            Log.printLines(this.errWriter, "error: " + msg);
        } else {
            JavaFileObject file = this.currentSource();
            if (file != null) {
                Log.printLines(this.errWriter, DefaultFileManager.getJavacFileName(file) + ":" + this.line + ": " + msg);
            }
            this.printErrLine(pos, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int pos, String msg) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSource(), pos)) {
            this.printRawError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(pos, "warning: " + msg);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    protected int getLineNumber(int pos) {
        if (this.findLine(pos)) {
            return this.line;
        }
        return 0;
    }

    protected int getColumnNumber(int pos) {
        if (this.findLine(pos)) {
            int column = 0;
            this.bp = this.lineStart;
            while (this.bp < pos) {
                if (this.bp >= this.buf.length) {
                    return 0;
                }
                column = this.buf[this.bp] == '\t' ? column / 8 * 8 + 8 : ++column;
                ++this.bp;
            }
            return column + 1;
        }
        return 0;
    }

    public static String format(String fmt, Object ... args) {
        return String.format((Locale)null, fmt, args);
    }
}

