/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class ChildrenSupport {
    static final int NO_CHILDREN_CACHED = 0;
    static final int SOME_CHILDREN_CACHED = 1;
    static final int ALL_CHILDREN_CACHED = 2;
    private Set notExistingChildren;
    private Set existingChildren;
    private int status = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Set getCachedChildren() {
        return this.getExisting(false);
    }

    public synchronized Set getChildren(FileNaming fileNaming, boolean bl) {
        if (bl || !this.isStatus(2)) {
            this.rescanChildren(fileNaming);
            this.setStatus(2);
        }
        return this.getExisting(false);
    }

    public synchronized FileNaming getChild(String string, FileNaming fileNaming, boolean bl) {
        FileNaming fileNaming2 = null;
        if (bl || this.isStatus(0)) {
            fileNaming2 = this.rescanChild(fileNaming, string);
        } else if (this.isStatus(1)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
            if (fileNaming2 == null && this.lookupChildInCache(fileNaming, string, false) == null) {
                fileNaming2 = this.rescanChild(fileNaming, string);
            }
        } else if (this.isStatus(2)) {
            fileNaming2 = this.lookupChildInCache(fileNaming, string, true);
        }
        this.setStatus(1);
        return fileNaming2;
    }

    public synchronized void removeChild(FileNaming fileNaming, FileNaming fileNaming2) {
        if (!$assertionsDisabled && fileNaming2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !fileNaming2.getParent().equals(fileNaming)) {
            throw new AssertionError();
        }
        this.getExisting().remove(fileNaming2);
        this.getNotExisting().add(fileNaming2);
    }

    private synchronized void addChild(FileNaming fileNaming, FileNaming fileNaming2) {
        if (!$assertionsDisabled && fileNaming2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !fileNaming2.getParent().equals(fileNaming)) {
            throw new AssertionError();
        }
        this.getExisting().add(fileNaming2);
        this.getNotExisting().remove(fileNaming2);
    }

    public synchronized Map refresh(FileNaming fileNaming) {
        Map<FileNaming, Integer> map = new HashMap();
        HashSet hashSet = new HashSet(this.getExisting(false));
        HashSet hashSet2 = new HashSet(this.getNotExisting(false));
        if (this.isStatus(1)) {
            FileNaming fileNaming2;
            Object object;
            HashSet hashSet3 = new HashSet(hashSet);
            Object object2 = hashSet3.iterator();
            while (object2.hasNext()) {
                object = (FileNaming)object2.next();
                fileNaming2 = this.rescanChild(fileNaming, object.getName());
                if (fileNaming2 == null) {
                    map.put((FileNaming)object, ChildrenCache.REMOVED_CHILD);
                    continue;
                }
                if (!$assertionsDisabled && !object.equals(fileNaming2)) {
                    throw new AssertionError();
                }
            }
            object2 = new HashSet(hashSet2);
            object = object2.iterator();
            while (object.hasNext()) {
                fileNaming2 = (FileNaming)object.next();
                if (!$assertionsDisabled && fileNaming2 == null) {
                    throw new AssertionError();
                }
                FileNaming fileNaming3 = this.rescanChild(fileNaming, fileNaming2.getName());
                if (fileNaming3 == null) continue;
                map.put(fileNaming2, ChildrenCache.ADDED_CHILD);
            }
        } else if (this.isStatus(2)) {
            map = this.rescanChildren(fileNaming);
        }
        return map;
    }

    public String toString() {
        return this.getExisting(false).toString();
    }

    boolean isStatus(int n) {
        return this.status == n;
    }

    private void setStatus(int n) {
        if (this.status < n) {
            this.status = n;
        }
    }

    private FileNaming rescanChild(FileNaming fileNaming, String string) {
        FileNaming fileNaming2;
        File file = fileNaming.getFile();
        File file2 = new File(file, string);
        FileInfo fileInfo = new FileInfo(file2);
        FileNaming fileNaming3 = fileNaming2 = fileInfo.isConvertibleToFileObject() ? NamingFactory.fromFile(fileNaming, file2) : null;
        if (fileNaming2 != null) {
            this.addChild(fileNaming, fileNaming2);
        } else {
            FileName fileName = new FileName(fileNaming, file2){

                public boolean isDirectory() {
                    return false;
                }

                public boolean isFile() {
                    return false;
                }
            };
            this.removeChild(fileNaming, fileName);
        }
        return fileNaming2;
    }

    private Map rescanChildren(FileNaming fileNaming) {
        Object object;
        Object object2;
        HashMap<FileNaming, Integer> hashMap = new HashMap<FileNaming, Integer>();
        LinkedHashSet<FileNaming> linkedHashSet = new LinkedHashSet<FileNaming>();
        File file = fileNaming.getFile();
        if (!$assertionsDisabled && !fileNaming.getFile().getAbsolutePath().equals(fileNaming.toString())) {
            throw new AssertionError();
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                object2 = new FileInfo(fileArray[i]);
                if (!((FileInfo)object2).isConvertibleToFileObject()) continue;
                object = NamingFactory.fromFile(fileNaming, fileArray[i]);
                if (!$assertionsDisabled && object.getParent() != fileNaming) {
                    throw new AssertionError();
                }
                linkedHashSet.add((FileNaming)object);
            }
        }
        HashSet hashSet = new HashSet(this.getExisting(false));
        hashSet.removeAll(linkedHashSet);
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (FileNaming)object2.next();
            this.removeChild(fileNaming, (FileNaming)object);
            hashMap.put((FileNaming)object, ChildrenCache.REMOVED_CHILD);
        }
        object2 = new HashSet(linkedHashSet);
        object2.removeAll(this.getExisting(false));
        object = object2.iterator();
        while (object.hasNext()) {
            FileNaming fileNaming2 = (FileNaming)object.next();
            this.addChild(fileNaming, fileNaming2);
            hashMap.put(fileNaming2, ChildrenCache.ADDED_CHILD);
        }
        return hashMap;
    }

    private FileNaming lookupChildInCache(FileNaming fileNaming, String string, boolean bl) {
        Set set;
        File file = new File(fileNaming.getFile(), string);
        Integer n = NamingFactory.createID(file);
        class FakeNaming
        implements FileNaming {
            public FileNaming lastEqual;
            static final /* synthetic */ boolean $assertionsDisabled;
            private final /* synthetic */ String val$childName;
            private final /* synthetic */ FileNaming val$folder;
            private final /* synthetic */ File val$f;
            private final /* synthetic */ Integer val$id;

            FakeNaming(String string, FileNaming fileNaming, File file, Integer n) {
                this.val$childName = string;
                this.val$folder = fileNaming;
                this.val$f = file;
                this.val$id = n;
            }

            public String getName() {
                return this.val$childName;
            }

            public FileNaming getParent() {
                return this.val$folder;
            }

            public boolean isRoot() {
                return false;
            }

            public File getFile() {
                return this.val$f;
            }

            public Integer getId() {
                return this.val$id;
            }

            public boolean rename(String string) {
                throw new IllegalStateException();
            }

            public boolean rename(String string, ProvidedExtensions.IOHandler iOHandler) {
                throw new IllegalStateException();
            }

            public boolean equals(Object object) {
                if (this.hashCode() == object.hashCode()) {
                    if (!$assertionsDisabled && this.lastEqual != null) {
                        throw new AssertionError((Object)"Just one can be there");
                    }
                    if (object instanceof FileNaming) {
                        this.lastEqual = (FileNaming)object;
                    }
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return this.val$id;
            }

            public Integer getId(boolean bl) {
                return this.val$id;
            }

            public boolean isFile() {
                return this.getFile().isFile();
            }

            public boolean isDirectory() {
                return !this.isFile();
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport == null ? (class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport = ChildrenSupport.class$("org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport")) : class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport).desiredAssertionStatus();
            }
        }
        FakeNaming fakeNaming = new FakeNaming(string, fileNaming, file, n);
        Set set2 = set = bl ? this.getExisting(false) : this.getNotExisting(false);
        if (set.contains(fakeNaming)) {
            if (!$assertionsDisabled && fakeNaming.lastEqual == null) {
                throw new AssertionError((Object)"If cache contains the object, we set lastEqual");
            }
            return fakeNaming.lastEqual;
        }
        return null;
    }

    private synchronized Set getExisting() {
        return this.getExisting(true);
    }

    private synchronized Set getExisting(boolean bl) {
        if (bl && this.existingChildren == null) {
            this.existingChildren = new HashSet();
        }
        return this.existingChildren != null ? this.existingChildren : new HashSet();
    }

    private synchronized Set getNotExisting() {
        return this.getNotExisting(true);
    }

    private synchronized Set getNotExisting(boolean bl) {
        if (bl && this.notExistingChildren == null) {
            this.notExistingChildren = new HashSet();
        }
        return this.notExistingChildren != null ? this.notExistingChildren : new HashSet();
    }

    static {
        $assertionsDisabled = !ChildrenSupport.class.desiredAssertionStatus();
    }
}

