/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.UNCName;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
        }
        FileNaming fileNaming = null;
        for (int i = 0; i < linkedList.size(); ++i) {
            fileNaming = NamingFactory.registerInstanceOfFileNaming(fileNaming, (File)linkedList.get(i));
        }
        return fileNaming;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming fileNaming, File file) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file);
    }

    public static synchronized void checkCaseSensitivity(FileNaming fileNaming, File file) {
        if (!fileNaming.getFile().getName().equals(file.getName())) {
            boolean bl;
            boolean bl2 = bl = !new File(file, "a").equals(new File(file, "A"));
            if (!bl) {
                NamingFactory.rename(fileNaming, file.getName());
            }
        }
    }

    private static synchronized FileNaming[] rename(FileNaming fileNaming, String string) {
        return NamingFactory.rename(fileNaming, string, null);
    }

    public static synchronized FileNaming[] rename(FileNaming fileNaming, String string, ProvidedExtensions.IOHandler iOHandler) {
        ArrayList<FileNaming> arrayList = new ArrayList<FileNaming>();
        boolean bl = false;
        NamingFactory.remove(fileNaming, null);
        bl = fileNaming.rename(string, iOHandler);
        arrayList.add(fileNaming);
        NamingFactory.registerInstanceOfFileNaming(fileNaming.getParent(), fileNaming.getFile(), fileNaming);
        NamingFactory.renameChildren(arrayList);
        return bl ? arrayList.toArray(new FileNaming[arrayList.size()]) : null;
    }

    private static void renameChildren(ArrayList arrayList) {
        Object object;
        Integer n;
        Map.Entry entry;
        HashMap<Integer, FileNaming> hashMap = new HashMap<Integer, FileNaming>();
        Iterator iterator = nameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            n = (Integer)entry.getKey();
            object = new ArrayList();
            Object v = entry.getValue();
            if (v instanceof Reference) {
                object.add(v);
            } else if (v instanceof List) {
                object.addAll((List)v);
            }
            for (int i = 0; i < object.size(); ++i) {
                boolean bl;
                FileNaming fileNaming = (FileNaming)((Reference)object.get(i)).get();
                if (fileNaming == null) continue;
                Integer n2 = NamingFactory.createID(fileNaming.getFile());
                boolean bl2 = bl = !n2.equals(n);
                if (!bl) continue;
                hashMap.put(n, fileNaming);
            }
        }
        iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            n = (Integer)entry.getKey();
            object = (FileNaming)entry.getValue();
            arrayList.add(object);
            NamingFactory.remove((FileNaming)object, n);
            object.getId(true);
            NamingFactory.registerInstanceOfFileNaming(object.getParent(), object.getFile(), (FileNaming)object);
        }
    }

    private static void remove(FileNaming fileNaming, Integer n) {
        Object v = nameMap.get(n = n != null ? n : fileNaming.getId());
        if (v instanceof List) {
            Reference reference = NamingFactory.getReference((List)v, fileNaming.getFile());
            if (reference != null) {
                ((List)v).remove(reference);
            }
        } else {
            nameMap.remove(n);
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file) {
        return NamingFactory.registerInstanceOfFileNaming(fileNaming, file, null);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming fileNaming, File file, FileNaming fileNaming2) {
        FileNaming fileNaming3;
        FileNaming fileNaming4;
        Object v = nameMap.get(new Integer(file.hashCode()));
        Reference reference = (Reference)(v instanceof Reference ? v : null);
        reference = reference == null && v instanceof List ? NamingFactory.getReference((List)v, file) : reference;
        FileNaming fileNaming5 = fileNaming4 = reference != null ? (FileNaming)reference.get() : null;
        if (fileNaming4 != null && fileNaming4.getFile().compareTo(file) == 0) {
            fileNaming3 = fileNaming4;
        } else {
            fileNaming3 = fileNaming2 == null ? NamingFactory.createFileNaming(file, fileNaming) : fileNaming2;
            WeakReference<FileNaming> weakReference = new WeakReference<FileNaming>(fileNaming3);
            boolean bl = v instanceof List;
            if (fileNaming4 != null || bl) {
                if (bl) {
                    ((List)v).add(weakReference);
                } else {
                    ArrayList<WeakReference<FileNaming>> arrayList = new ArrayList<WeakReference<FileNaming>>();
                    arrayList.add(weakReference);
                    nameMap.put(fileNaming3.getId(), arrayList);
                }
            } else {
                Reference reference2 = nameMap.put(fileNaming3.getId(), weakReference);
                if (!$assertionsDisabled && reference2 != null && reference2.get() != null) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && fileNaming3 == null) {
            throw new AssertionError();
        }
        return fileNaming3;
    }

    private static Reference getReference(List list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            FileNaming fileNaming;
            Reference reference2 = (Reference)list.get(i);
            FileNaming fileNaming2 = fileNaming = reference2 != null ? (FileNaming)reference2.get() : null;
            if (fileNaming == null || fileNaming.getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    private static FileNaming createFileNaming(File file, FileNaming fileNaming) {
        FileName fileName = null;
        FileInfo fileInfo = new FileInfo(file);
        if (file.isFile()) {
            fileName = new FileName(fileNaming, file);
        } else if (file.isDirectory()) {
            fileName = new FolderName(fileNaming, file);
        } else if (fileInfo.isUNCFolder()) {
            fileName = new UNCName(fileNaming, file);
        }
        if (fileName == null) {
            fileName = new FileName(fileNaming, file){

                public boolean isDirectory() {
                    return false;
                }

                public boolean isFile() {
                    return false;
                }
            };
        }
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError((Object)(file.getAbsolutePath() + " isDirectory: " + file.isDirectory() + " isFile: " + file.isFile() + " exists: " + file.exists()));
        }
        return fileName;
    }

    static {
        $assertionsDisabled = !NamingFactory.class.desiredAssertionStatus();
        nameMap = new WeakHashMap();
    }
}

