/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.providers;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.netbeans.modules.masterfs.ExLocalFileSystem;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class Attributes
extends DefaultAttributes {
    public static String ATTRNAME;
    private static final String USERDIR = "netbeans.user";
    private static final String LOCATION = "var";
    private static DefaultAttributes sharedUserAttributes;
    private final String attributePrefix;
    private AbstractFileSystem.List list;
    private static final boolean BACKWARD_COMPATIBILITY = true;
    private static File rootForAttributes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Attributes(File file, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        super(info, change, list);
        this.list = list;
        this.attributePrefix = this.preparePrefix(file);
    }

    public Attributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        super(info, change, list);
        this.list = list;
        this.attributePrefix = "";
    }

    private String preparePrefix(File file) {
        file = FileUtil.normalizeFile((File)file);
        String string = file.getAbsolutePath().replace('\\', '/');
        return Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? string.toLowerCase() : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getRootForAttributes() {
        Class clazz = ExLocalFileSystem.class;
        synchronized (clazz) {
            if (rootForAttributes == null) {
                String string = System.getProperty(USERDIR);
                if (string != null) {
                    rootForAttributes = new File(string, LOCATION);
                } else {
                    rootForAttributes = new File(System.getProperty("java.io.tmpdir"));
                    File file = new File(rootForAttributes, ATTRNAME);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.deleteOnExit();
                }
                if (!rootForAttributes.exists()) {
                    rootForAttributes.mkdirs();
                }
            }
        }
        return rootForAttributes;
    }

    public String[] children(String string) {
        return this.list.children(string);
    }

    public Object readAttribute(String string, String string2) {
        String string3 = this.translateName(string);
        Object object = this.getPreferedAttributes().readAttribute(string3, string2);
        if (object == null && this.isBackwardCompatible() && (object = super.readAttribute(string, string2)) != null) {
            this.copyAllToUserDir(string, super.attributes(string));
            object = this.getPreferedAttributes().readAttribute(string3, string2);
        }
        return object;
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        this.getPreferedAttributes().writeAttribute(this.translateName(string), string2, object);
    }

    public synchronized Enumeration attributes(String string) {
        Enumeration enumeration = this.getPreferedAttributes().attributes(this.translateName(string));
        if ((enumeration == null || !enumeration.hasMoreElements()) && this.isBackwardCompatible()) {
            enumeration = this.copyAllToUserDir(string, super.attributes(string));
        }
        return enumeration;
    }

    private Enumeration copyAllToUserDir(String string, Enumeration enumeration) {
        if (enumeration != null && enumeration.hasMoreElements() && this.isBackwardCompatible()) {
            String string2 = this.translateName(string);
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Object object = super.readAttribute(string, string3);
                try {
                    this.getPreferedAttributes().writeAttribute(string2, string3, object);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            super.deleteAttributes(string);
            enumeration = this.getPreferedAttributes().attributes(string2);
        }
        return enumeration;
    }

    public synchronized void renameAttributes(String string, String string2) {
        if (this.isBackwardCompatible()) {
            this.copyAllToUserDir(string, super.attributes(string));
        }
        this.getPreferedAttributes().renameAttributes(this.translateName(string), this.translateName(string2));
    }

    public synchronized void deleteAttributes(String string) {
        if (this.isBackwardCompatible()) {
            super.deleteAttributes(string);
        }
        this.getPreferedAttributes().deleteAttributes(this.translateName(string));
    }

    private String translateName(String string) {
        return this.attributePrefix.endsWith("/") ? this.attributePrefix + "/" + string : this.attributePrefix + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultAttributes getPreferedAttributes() {
        Class clazz = Attributes.class;
        synchronized (clazz) {
            if (sharedUserAttributes == null) {
                ExLocalFileSystem exLocalFileSystem = null;
                try {
                    exLocalFileSystem = ExLocalFileSystem.getInstance(Attributes.getRootForAttributes());
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                sharedUserAttributes = exLocalFileSystem.getAttributes();
            }
        }
        if (!$assertionsDisabled && sharedUserAttributes == null) {
            throw new AssertionError();
        }
        return sharedUserAttributes != null ? sharedUserAttributes : this;
    }

    private boolean isBackwardCompatible() {
        return this.getPreferedAttributes() != this;
    }

    static {
        $assertionsDisabled = !Attributes.class.desiredAssertionStatus();
        ATTRNAME = "attributes.xml";
    }
}

