/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.DOMFactoryImpl;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.NbURLStreamHandlerFactory;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.SAXFactoryImpl;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopThreadGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class Main {
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;
    private static boolean nbFactoryInitialized;

    public static void setStatusText(String string) {
        Splash.getInstance().print(string);
        if (moduleSystemInitialized) {
            CoreBridge.conditionallyPrintStatus(string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TopThreadGroup topThreadGroup = new TopThreadGroup("IDE Main", stringArray);
        StartLog.logStart("Forwarding to topThreadGroup");
        topThreadGroup.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        if (!nbFactoryInitialized) {
            NbURLStreamHandlerFactory nbURLStreamHandlerFactory = new NbURLStreamHandlerFactory();
            try {
                URL.setURLStreamHandlerFactory(nbURLStreamHandlerFactory);
            }
            catch (Error error) {
                nbURLStreamHandlerFactory.registerUsingReflection(error);
            }
            nbFactoryInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initUICustomizations() {
        if (!CLIOptions.isGui()) {
            return;
        }
        URL uRL = null;
        boolean bl = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
        try {
            if (bl) {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("themes.xml");
                if (fileObject == null) {
                    try {
                        uRL = new URL("nbresloc:/org/netbeans/core/startup/resources/themes.xml");
                        uRL.openStream().close();
                    }
                    catch (IOException iOException) {
                        uRL = null;
                    }
                } else {
                    try {
                        uRL = fileObject.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.getFontSize(), uRL);
        }
        if (CLIOptions.getFontSize() > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            Util.err.warning(NbBundle.getMessage(Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (moduleSystem != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return moduleSystem;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem(Repository.getDefault().getDefaultFileSystem());
            }
            catch (IOException iOException) {
                throw (IllegalStateException)new IllegalStateException("Module system cannot be created").initCause(iOException);
            }
            StartLog.logProgress("ModuleSystem created");
            // ** MonitorExit[var0] (shouldn't be in output)
            moduleSystem.loadBootModules();
            moduleSystem.readList();
            moduleSystem.restore();
            StartLog.logEnd("Modules initialization");
            moduleSystemInitialized = true;
            return moduleSystem;
        }
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] stringArray) throws SecurityException {
        String string;
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.5")) < 0) {
            System.err.println("The IDE requires JDK 5 or higher to run.");
            TopSecurityManager.exit((int)1);
        }
        if ((string = System.getProperty("jdk.home")) == null) {
            string = System.getProperty("java.home");
            if (Utilities.isMac()) {
                string = string + File.separator + "..";
            }
            System.setProperty("jdk.home", string);
        }
        Main.initializeURLFactory();
        if (System.getProperties().get("org.openide.TopManager") == null) {
            System.setProperty("org.openide.TopManager.GUI", "true");
            System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
        }
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        StartLog.logStart("XML Factories");
        SAXFactoryImpl.install();
        DOMFactoryImpl.install();
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError internalError) {
                String string2 = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails1", (Object)internalError.getMessage());
                System.out.println(string2);
                string2 = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(string2);
                throw internalError;
            }
        }
        StartLog.logEnd("XML Factories");
        InstalledFileLocatorImpl.prepareCache();
        String[] stringArray2 = Introspector.getBeanInfoSearchPath();
        String[] stringArray3 = new String[]{"org.netbeans.beaninfo"};
        String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray3.length, stringArray2.length);
        Introspector.setBeanInfoSearchPath(stringArray4);
        try {
            if (System.getProperty("netbeans.full.hack") == null && System.getProperty("netbeans.close") == null) {
                if (!Main.handleLicenseCheck()) {
                    TopSecurityManager.exit((int)0);
                }
                if (!Main.handleImportOfUserDir()) {
                    TopSecurityManager.exit((int)0);
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        StartLog.logProgress("License check performed and upgrade wizard consulted");
        Splash.getInstance().setRunning(true);
        Splash.getInstance().print(NbBundle.getMessage(Main.class, (String)"MSG_IDEInit"));
        assert (Repository.getDefault() instanceof NbRepository) : "Has to be NbRepository: " + Repository.getDefault();
        Main.getModuleSystem();
        CoreBridge.getDefault().registerPropertyEditors();
        StartLog.logProgress("PropertyEditors registered");
        CoreBridge.getDefault().loadSettings();
        StartLog.logProgress("IDE settings loaded");
        for (RunLevel runLevel : Lookup.getDefault().lookupAll(RunLevel.class)) {
            runLevel.run();
        }
        org.netbeans.Main.finishInitialization();
        StartLog.logProgress("Ran any delayed command-line options");
        Splash.getInstance().setRunning(false);
        Splash.getInstance().dispose();
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
    }

    private static final Class getKlass(String string) {
        try {
            ModuleSystem moduleSystem = Main.moduleSystem;
            ClassLoader classLoader = moduleSystem != null ? moduleSystem.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getLocalizedMessage());
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method method = clazz.getMethod("main", String[].class);
                    method.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    } else {
                        invocationTargetException.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (LinkageError linkageError) {
                    linkageError.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler importHandler = new ImportHandler();
        return importHandler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                File file = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
                if (file != null) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method method = clazz.getMethod("showLicensePanel", new Class[0]);
                    method.invoke(null, new Object[0]);
                    this.executedOk = true;
                    File file = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = false;
                    } else {
                        invocationTargetException.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (LinkageError linkageError) {
                    linkageError.printStackTrace();
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return false;
                    }
                }
                return true;
            }
        }
        LicenseHandler licenseHandler = new LicenseHandler();
        return licenseHandler.canContinue();
    }
}

