/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbEvents;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleSystem {
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private final ModuleList list;
    private final Events ev;
    private Set<Module> bootModules = null;

    public ModuleSystem(FileSystem fileSystem) throws IOException {
        if (Boolean.getBoolean("org.netbeans.core.startup.ModuleSystem.CULPRIT")) {
            Thread.dumpStack();
        }
        this.ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager((ModuleInstaller)this.installer, this.ev);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("classLoader".equals(propertyChangeEvent.getPropertyName())) {
                    MainLookup.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(propertyChangeListener);
        MainLookup.systemClassLoaderChanged(((Object)((Object)this.installer)).getClass().getClassLoader());
        MainLookup.moduleLookupReady(this.mgr.getModuleLookup());
        if (fileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject fileObject = fileSystem.getRoot();
            FileObject fileObject2 = fileObject.getFileObject("Modules");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, fileObject2, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem", new Object[0]);
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            ArrayList arrayList = new ArrayList();
            for (Module module : this.mgr.getEnabledModules()) {
                arrayList.addAll(module.getAllJars());
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootModules() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        try {
            object3 = System.getProperty("java.home");
            if (((String)object3).endsWith(File.separator + "jre")) {
                object3 = ((String)object3).substring(0, ((String)object3).length() - 4);
            }
            if (new File(new File((File)(object2 = new File((String)object3)), "lib"), "tools.jar").isFile()) {
                arrayList.add("jar:" + ((File)object2).toURI().toURL());
            }
            if ((object = System.getProperty("netbeans.home")) != null) {
                serializable = new File((String)object);
                object2 = new File(new File((File)serializable, "lib"), "ext");
                arrayList.add("jar:" + ((File)object2).toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Util.err.log(Level.WARNING, null, malformedURLException);
        }
        Util.err.log(Level.FINE, "ignoredPrefixes={0}", arrayList);
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules", new Object[0]);
        try {
            this.bootModules = new HashSet<Module>(10);
            object3 = ModuleSystem.class.getClassLoader();
            object2 = ((ClassLoader)object3).getResources("META-INF/MANIFEST.MF");
            this.ev.log("perfTick", new Object[]{"got all manifests"});
            object = new HashSet();
            block15: while (object2.hasMoreElements()) {
                InputStream inputStream;
                serializable = (URL)object2.nextElement();
                if (!object.add(serializable)) continue;
                String string = ((URL)serializable).toExternalForm();
                for (String iOException : arrayList) {
                    if (!string.startsWith(iOException)) continue;
                    Util.err.log(Level.FINE, "ignoring JDK/JRE manifest: {0}", string);
                    continue block15;
                }
                Util.err.log(Level.FINE, "Checking boot manifest: {0}", string);
                try {
                    inputStream = ((URL)serializable).openStream();
                }
                catch (IOException iOException) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("URL: " + serializable));
                    throw iOException;
                }
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes.getValue("OpenIDE-Module") == null) continue;
                    this.bootModules.add(this.mgr.createFixed(manifest, (Object)serializable, (ClassLoader)object3));
                }
                finally {
                    inputStream.close();
                }
            }
            if (this.list == null) {
                this.mgr.enable(this.bootModules);
            }
            this.ev.log("perfTick", new Object[]{"added all classpath modules"});
        }
        catch (IOException iOException) {
            Util.err.log(Level.WARNING, null, iOException);
        }
        catch (DuplicateException duplicateException) {
            Util.err.log(Level.WARNING, null, duplicateException);
        }
        finally {
            this.ev.log("finishLoadBootModules", new Object[0]);
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.readList"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.readList"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.restore"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet<Module> hashSet = new HashSet<Module>(this.bootModules);
            this.list.trigger(hashSet);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.restore"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(Runnable runnable) {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            boolean bl = this.mgr.shutDown(runnable);
            return bl;
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deployTestModule(File file) throws IOException {
        if (!file.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", new Object[]{file});
        System.err.println("Deploying test module " + file + "...");
        try {
            Module module = null;
            HashSet<Module> hashSet = new HashSet<Module>();
            for (Module module2 : this.mgr.getModules()) {
                if (module2.getJarFile() == null || !file.equals(module2.getJarFile())) continue;
                if (!module2.isReloadable()) {
                    module2.setReloadable(true);
                }
                this.turnOffModule(module2, hashSet);
                this.mgr.reload(module2);
                module = module2;
                break;
            }
            if (module == null) {
                try {
                    module = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException duplicateException) {
                    Module module3 = duplicateException.getOldModule();
                    System.err.println("Replacing old module in " + module3);
                    this.turnOffModule(module3, hashSet);
                    this.mgr.delete(module3);
                    try {
                        module = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException duplicateException2) {
                        throw (IOException)new IOException(duplicateException2.toString()).initCause(duplicateException2);
                    }
                }
            }
            System.err.println("Enabling " + module + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(module)).contains(module)) {
                throw new IOException("Cannot enable " + module + "; problems: " + module.getProblems());
            }
            this.mgr.enable(module);
            if (!hashSet.isEmpty()) {
                System.err.println("Also re-enabling:");
                for (Module module2 : hashSet) {
                    System.err.println("\t" + module2.getDisplayName());
                    if (!module2.isReloadable()) continue;
                    module2.reload();
                }
                try {
                    this.mgr.enable(hashSet);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException.toString());
                }
            }
            System.err.println("Done.");
        }
        catch (Throwable throwable) {
            this.ev.log("finishDeployTestModule", new Object[]{file});
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.ev.log("finishDeployTestModule", new Object[]{file});
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module module, Set<Module> set) {
        if (!module.isEnabled()) {
            return;
        }
        for (Module module2 : this.mgr.simulateDisable(Collections.singleton(module))) {
            if (module2.isAutoload() || module2.isEager()) continue;
            set.add(module2);
        }
        try {
            System.err.println("Disabling " + module + "...");
            this.mgr.disable(set);
        }
        finally {
            set.remove(module);
        }
    }

    public String getEffectiveClasspath(Module module) {
        return this.installer.getEffectiveClasspath(module);
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }
}

