/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    private Logger logger = Logger.getLogger(NbEvents.class.getName());
    private int moduleCount;
    private int counter;

    NbEvents() {
    }

    protected void logged(String string, Object[] objectArray) {
        if (string == "perfTick") {
            StartLog.logProgress((String)objectArray[0]);
        } else if (string == "perfStart") {
            StartLog.logStart((String)objectArray[0]);
        } else if (string == "perfEnd") {
            StartLog.logEnd((String)objectArray[0]);
        } else if (string == "startCreateBootModule") {
            Splash.getInstance().increment(1);
        } else if (string == "startLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_load_boot_modules"));
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (string == "startLoad") {
            StartLog.logStart("NbInstaller.load");
        } else if (string == "finishLoadBootModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_load_boot_modules"));
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (string == "finishLoad") {
            StartLog.logEnd("NbInstaller.load");
        } else if (string == "startAutoRestore") {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_auto_restore"));
            }
        } else if (string == "finishAutoRestore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_auto_restore"));
        } else if (string == "startEnableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_enable_modules"));
        } else if (string == "finishEnableModules") {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_enable_modules"));
            StartLog.logEnd("ModuleManager.enable");
        } else if (string == "startDisableModules") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_disable_modules"));
        } else if (string == "finishDisableModules") {
            List list = (List)objectArray[0];
            if (!list.isEmpty()) {
                this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_disable_modules"));
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_disable_modules"));
        } else if (string == "startDeployTestModule") {
            NbEvents.setStatusText("Deploying test module in " + (File)objectArray[0] + "...");
        } else if (string == "finishDeployTestModule") {
            NbEvents.setStatusText("Finished deploying test module.");
        } else if (string == "failedInstallNew") {
            Set set = NbCollections.checkedSetByCopy((Set)((Set)objectArray[0]), Module.class, (boolean)true);
            StringBuilder stringBuilder = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, false);
            this.logger.log(Level.INFO, stringBuilder.toString());
            stringBuilder = new StringBuilder(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new"));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, true);
            String string2 = stringBuilder.toString();
            this.notify(string2, true);
            NbEvents.setStatusText("");
        } else if (string == "failedInstallNewUnexpected") {
            Module module = (Module)objectArray[0];
            StringBuffer stringBuffer = new StringBuffer(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)module.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(stringBuffer, Collections.singleton(module), false);
            this.logger.log(Level.INFO, stringBuffer.toString());
            stringBuffer = new StringBuffer(NbBundle.getMessage(NbEvents.class, (String)"MSG_failed_install_new_unexpected", (Object)module.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(stringBuffer, Collections.singleton(module), true);
            this.notify(stringBuffer.toString(), true);
            NbEvents.setStatusText("");
        } else if (string == "startRead") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_start_read"));
            StartLog.logStart("ModuleList.readInitial");
        } else if (string == "modulesFileScanned") {
            this.moduleCount = (Integer)objectArray[0];
            Splash.getInstance().addToMaxSteps(Math.max(this.moduleCount + this.moduleCount / 2 - 100, 0));
        } else if (string == "modulesFileProcessed") {
            Splash.getInstance().increment(1);
            if (StartLog.willLog()) {
                StartLog.logProgress("file " + ((FileObject)objectArray[0]).getNameExt() + " processed");
            }
        } else if (string == "finishRead") {
            if (this.moduleCount < 100) {
                Splash.getInstance().increment(this.moduleCount - 100);
            }
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_finish_read"));
            StartLog.logEnd("ModuleList.readInitial");
        } else if (string == "restore") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_restore"));
            if (++this.counter < this.moduleCount / 2) {
                Splash.getInstance().increment(1);
            }
        } else if (string == "install") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_install", (Object)((Module)objectArray[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_install", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "update") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_update", (Object)((Module)objectArray[0]).getDisplayName()));
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_update", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "uninstall") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_uninstall", (Object)((Module)objectArray[0]).getDisplayName()));
        } else if (string == "loadSection") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_section"));
            if (++this.counter < this.moduleCount / 4) {
                Splash.getInstance().increment(1);
            }
        } else if (string == "loadLayers") {
            NbEvents.setStatusText(NbBundle.getMessage(NbEvents.class, (String)"MSG_load_layers"));
        } else if (string == "wrongClassLoader") {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(Level.WARNING)) {
                Class clazz = (Class)objectArray[1];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("The module " + ((Module)objectArray[0]).getDisplayName() + " loaded the class " + clazz.getName() + "\n");
                stringBuffer.append("from the wrong classloader. The expected classloader was " + objectArray[2] + "\n");
                stringBuffer.append("whereas it was actually loaded from " + clazz.getClassLoader() + "\n");
                stringBuffer.append("Usually this means that some classes were in the startup classpath.\n");
                stringBuffer.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.warning(stringBuffer.toString());
            }
        } else if (string == "extensionMultiplyLoaded") {
            this.logger.log(Level.WARNING, "The extension " + (File)objectArray[0] + " may be multiply loaded by modules: " + (Set)objectArray[1] + "; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path");
        } else if (string == "missingJarFile") {
            File file = (File)objectArray[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_missing_jar_file", (Object)file.getAbsolutePath()));
        } else if (string == "cantDeleteEnabledAutoload") {
            Module module = (Module)objectArray[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_cant_delete_enabled_autoload", (Object)module.getDisplayName()));
        } else if (string == "miscPropMismatch") {
            Module module = (Module)objectArray[0];
            String string3 = (String)objectArray[1];
            Object object = objectArray[2];
            Object object2 = objectArray[3];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_misc_prop_mismatch", (Object[])new Object[]{module.getDisplayName(), string3, object, object2}));
        } else if (string == "patch") {
            File file = (File)objectArray[0];
            this.logger.log(Level.INFO, NbBundle.getMessage(NbEvents.class, (String)"TEXT_patch", (Object)file.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 100 + 1);
        stringBuilder.append(NbBundle.getMessage(NbEvents.class, (String)"TEXT_finish_enable_modules"));
        String string = System.getProperty("line.separator");
        stringBuilder.append(string);
        while (iterator.hasNext()) {
            String string2;
            String string3;
            Module module = (Module)iterator.next();
            stringBuilder.append('\t');
            stringBuilder.append(module.getCodeName());
            stringBuilder.append(" [");
            SpecificationVersion specificationVersion = module.getSpecificationVersion();
            if (specificationVersion != null) {
                stringBuilder.append(specificationVersion);
            }
            if ((string3 = module.getImplementationVersion()) != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
            if ((string2 = module.getBuildVersion()) != null && !string2.equals(string3)) {
                stringBuilder.append(' ');
                stringBuilder.append(string2);
            }
            stringBuilder.append(']');
            stringBuilder.append(string);
        }
        this.logger.log(Level.INFO, stringBuilder.toString());
    }

    private void notify(String string, boolean bl) {
        if (Boolean.getBoolean("netbeans.full.hack")) {
            this.logger.log(Level.INFO, string);
        } else {
            new Notifier(string, bl);
        }
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }

    private static final class Notifier
    implements Runnable {
        private static int questions;
        private boolean warn;
        private String text;
        private static RequestProcessor RP;
        private Object[] options;
        private Object value;

        public Notifier(String string, boolean bl) {
            this.warn = bl;
            this.text = string;
            if (questions++ == 0) {
                this.options = new String[]{NbBundle.getMessage(Notifier.class, (String)"MSG_continue"), NbBundle.getMessage(Notifier.class, (String)"MSG_exit")};
            }
            RequestProcessor.Task task = RP.post((Runnable)this, 0, 1);
            if (this.options != null) {
                task.waitFinished();
            }
        }

        public Object getOption() {
            return this.value;
        }

        public void run() {
            int n = this.warn ? 2 : 1;
            String string = NbBundle.getMessage(Notifier.class, (String)(this.warn ? "MSG_warning" : "MSG_info"));
            Splash splash = Splash.getInstance();
            Component component = splash.getComponent() == null ? null : splash.getComponent();
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(this.text);
            jTextArea.setEditable(false);
            jTextArea.setEnabled(true);
            jTextArea.setOpaque(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 50, jTextArea.getFont().getSize() * 15));
            if (this.options == null) {
                JOptionPane.showMessageDialog(null, jScrollPane, string, n);
            } else {
                int n2 = JOptionPane.showOptionDialog(component, jScrollPane, string, 0, n, null, this.options, this.options[1]);
                if (n2 == 1 || n2 == -1) {
                    TopSecurityManager.exit((int)1);
                }
            }
        }

        static {
            RP = new RequestProcessor("Notify About Module System");
        }
    }
}

