/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NbInstaller
extends ModuleInstaller {
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private static String[] specialResourcePrefixes = null;
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/", "com/sun/tools/javac/", "com/sun/tools/javadoc/", "com/sun/javadoc/", "com/sun/source/", "javax/annotation/", "javax/lang/model/", "javax/tools/", "javax/xml/bind/", "javax/xml/ws/", "javax/xml/stream/", "javax/jws/", "javax/xml/soap/"};
    private static boolean withoutOptimizations;
    private static final String[][] CLASSPATH_JARS;
    private File manifestCacheFile;
    private boolean usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
    private Map<File, Object[]> manifestCache;
    private boolean manifestCacheDirty;

    public NbInstaller(Events events) {
        if (this.usingManifestCache) {
            String string = System.getProperty("netbeans.user");
            if (string != null) {
                this.manifestCacheFile = new File(new File(new File(new File(string), "var"), "cache"), "all-manifests.dat");
                Util.err.fine("Using manifest cache in " + this.manifestCacheFile);
            } else {
                this.usingManifestCache = false;
                Util.err.fine("Not using any manifest cache; no user directory");
            }
        } else {
            Util.err.fine("Manifest cache disabled");
        }
        this.manifestCache = null;
        this.manifestCacheDirty = false;
        this.ev = events;
    }

    void registerList(ModuleList moduleList) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = moduleList;
    }

    void registerManager(ModuleManager moduleManager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = moduleManager;
    }

    public void prepare(Module module) throws InvalidException {
        Object object;
        Map.Entry<String, Attributes> entry2;
        this.ev.log("prepare", new Object[]{module});
        HashSet<ManifestSection> hashSet = null;
        Class<?> clazz = null;
        for (Map.Entry<String, Attributes> entry2 : module.getManifest().getEntries().entrySet()) {
            object = ManifestSection.create(entry2.getKey(), entry2.getValue(), module);
            if (object == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<ManifestSection>(25);
            }
            hashSet.add((ManifestSection)object);
        }
        String string = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (string != null) {
            try {
                entry2 = Util.createPackageName((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InvalidException invalidException = new InvalidException(module, illegalArgumentException.toString());
                invalidException.initCause((Throwable)illegalArgumentException);
                throw invalidException;
            }
            if (string.endsWith(".ser")) {
                throw new InvalidException(module, "Serialized module installs not supported: " + (String)string);
            }
            try {
                clazz = Class.forName((String)((Object)entry2), false, module.getClassLoader());
                if (clazz.getClassLoader() != module.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{module, clazz, module.getClassLoader()});
                }
                for (object = clazz; object != ModuleInstall.class && object != Object.class; object = ((Class)object).getSuperclass()) {
                    try {
                        ((Class)object).getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        moduleInstall.validate();
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (object == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception exception) {
                InvalidException invalidException = new InvalidException(module, exception.toString());
                invalidException.initCause((Throwable)exception);
                throw invalidException;
            }
            catch (LinkageError linkageError) {
                InvalidException invalidException = new InvalidException(module, linkageError.toString());
                invalidException.initCause((Throwable)linkageError);
                throw invalidException;
            }
        }
        if ((entry2 = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer")) != null && (object = module.getClassLoader().getResource((String)((Object)entry2))) == null) {
            throw new InvalidException(module, "Layer not found: " + (String)((Object)entry2));
        }
        object = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (object != null) {
            Util.err.warning("Use of OpenIDE-Module-Description in " + module.getCodeNameBase() + " is deprecated.");
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (hashSet != null) {
            this.sections.put(module, hashSet);
        }
        if (clazz != null) {
            this.installs.put(module, clazz.asSubclass(ModuleInstall.class));
        }
        if (entry2 != null) {
            this.layers.put(module, (String)((Object)entry2));
        }
    }

    public void dispose(Module module) {
        Util.err.fine("dispose: " + module);
        Set<ManifestSection> set = this.sections.remove(module);
        if (set != null) {
            for (ManifestSection manifestSection : set) {
                manifestSection.dispose();
            }
        }
        this.installs.remove(module);
        this.layers.remove(module);
        this.kosherPackages.remove(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List<Module> list) {
        this.ev.log("startLoad", new Object[]{list});
        if (this.mgr != null) {
            MainLookup.systemClassLoaderChanged(this.mgr.getClassLoader());
        }
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
        for (Module module : list) {
            this.checkForDeprecations(module);
            NbInstaller.openideModuleEnabled(module);
        }
        this.loadLayers(list, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, true);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + module.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.conditionallyLoaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module module : list) {
            try {
                this.loadCode(module, true);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
            catch (AssertionError assertionError) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)assertionError));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + module.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{list});
        this.maybeSaveManifestCache();
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List<Module> list) {
        this.ev.log("startUnload", new Object[]{list});
        for (Module module : list) {
            try {
                this.loadCode(module, false);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, false);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
            }
        }
        finally {
            try {
                CoreBridge.conditionallyLoaderPoolTransaction(false);
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
        }
        this.loadLayers(list, false);
        this.ev.log("finishUnload", new Object[]{list});
    }

    private void loadCode(Module module, boolean bl) throws Exception {
        Class<? extends ModuleInstall> clazz = this.installs.get(module);
        if (clazz != null) {
            ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
            if (bl) {
                Object object;
                if (this.moduleList != null) {
                    this.moduleList.installPrepare(module, moduleInstall);
                }
                if ((object = module.getHistory()) instanceof ModuleHistory) {
                    ModuleHistory moduleHistory = (ModuleHistory)object;
                    if (moduleHistory.isPreviouslyInstalled()) {
                        SpecificationVersion specificationVersion = moduleHistory.getOldSpecificationVersion();
                        SpecificationVersion specificationVersion2 = module.getSpecificationVersion();
                        if (module.getCodeNameRelease() != moduleHistory.getOldMajorVersion() || specificationVersion == null ^ specificationVersion2 == null || specificationVersion != null && specificationVersion2 != null && specificationVersion.compareTo((Object)specificationVersion2) != 0) {
                            this.ev.log("update", new Object[]{module});
                            moduleInstall.updated(moduleHistory.getOldMajorVersion(), specificationVersion == null ? null : specificationVersion.toString());
                        } else {
                            this.ev.log("restore", new Object[]{module});
                            moduleInstall.restored();
                        }
                    } else {
                        this.ev.log("install", new Object[]{module});
                        moduleInstall.installed();
                    }
                } else {
                    this.ev.log("restore", new Object[]{module});
                    moduleInstall.restored();
                }
                if (this.moduleList != null) {
                    this.moduleList.installPostpare(module, moduleInstall);
                }
            } else {
                this.ev.log("uninstall", new Object[]{module});
                moduleInstall.uninstalled();
                if (module.getHistory() instanceof ModuleHistory) {
                    ((ModuleHistory)module.getHistory()).resetHistory();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module module, boolean bl) throws Exception {
        Set<ManifestSection> set = this.sections.get(module);
        if (set == null) {
            return;
        }
        boolean bl2 = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection manifestSection : set) {
                if (manifestSection instanceof ManifestSection.ActionSection) {
                    if (!bl2) {
                        Object object = module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (object == null) {
                            object = module.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(object);
                        bl2 = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)manifestSection, bl);
                    continue;
                }
                assert (false) : manifestSection;
            }
        }
        finally {
            if (bl2) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection manifestSection, boolean bl) {
        CoreBridge.getDefault().loadDefaultSection(manifestSection, this.convertor, bl);
    }

    private void loadLayers(List<Module> list, boolean bl) {
        Object object;
        Object object2;
        this.ev.log(bl ? "loadLayers" : "unloadLayers", new Object[]{list});
        list = new ArrayList<Module>(list);
        Collections.reverse(list);
        HashMap hashMap = new HashMap(5);
        for (Module object3 : list) {
            String string;
            object2 = this.layers.get(object3);
            if (object2 == null) continue;
            Util.err.fine("loadLayer: " + (String)object2 + " load=" + bl);
            int n = ((String)object2).lastIndexOf(46);
            if (n == -1) {
                object = object2;
                string = "";
            } else {
                object = ((String)object2).substring(0, n);
                string = ((String)object2).substring(n);
            }
            ClassLoader classLoader = object3.getClassLoader();
            ModuleLayeredFileSystem moduleLayeredFileSystem = object3.isReloadable() ? ModuleLayeredFileSystem.getUserModuleLayer() : ModuleLayeredFileSystem.getInstallationModuleLayer();
            ArrayList<URL> arrayList = (ArrayList<URL>)hashMap.get((Object)moduleLayeredFileSystem);
            if (arrayList == null) {
                arrayList = new ArrayList<URL>(100);
                hashMap.put(moduleLayeredFileSystem, arrayList);
            }
            boolean bl2 = false;
            for (String string2 : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                String string3 = (String)object + string2 + string;
                URL uRL = classLoader.getResource(string3);
                if (uRL == null) continue;
                arrayList.add(uRL);
                bl2 = true;
            }
            if (bl2) continue;
            Util.err.fine("Module layer not found: " + (String)object2);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (ModuleLayeredFileSystem)((Object)entry.getKey());
            object = (List)entry.getValue();
            Util.err.fine("Adding/removing layer URLs: host=" + object2 + " urls=" + object);
            try {
                if (bl) {
                    ((ModuleLayeredFileSystem)((Object)object2)).addURLs((Collection<URL>)object);
                    continue;
                }
                ((ModuleLayeredFileSystem)((Object)object2)).removeURLs((Collection<URL>)object);
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
            }
        }
    }

    private void checkForDeprecations(Module module) {
        if (!Boolean.valueOf((String)module.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) {
            for (Dependency dependency : module.getDependencies()) {
                if (dependency.getType() != 1) continue;
                String string = (String)Util.parseCodeName((String)dependency.getName())[0];
                Module module2 = this.mgr.get(string);
                if (module2 == null) {
                    throw new IllegalStateException("No such module: " + string);
                }
                if (!Boolean.parseBoolean((String)module2.getAttribute("OpenIDE-Module-Deprecated"))) continue;
                String string2 = (String)module2.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
                if (string2 != null) {
                    Util.err.warning("the module " + module.getCodeNameBase() + " uses " + string + " which is deprecated: " + string2);
                    continue;
                }
                Util.err.warning("the module " + module.getCodeNameBase() + " uses " + string + " which is deprecated.");
            }
        }
    }

    public boolean closing(List<Module> list) {
        Util.err.fine("closing: " + list);
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (moduleInstall.closing()) continue;
                Util.err.fine("Module " + module + " refused to close");
                return false;
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        return true;
    }

    public void close(List<Module> list) {
        Util.err.fine("close: " + list);
        this.ev.log("close", new Object[0]);
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (moduleInstall == null) {
                    throw new IllegalStateException("Inconsistent state: " + clazz);
                }
                moduleInstall.close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.log(Level.SEVERE, null, throwable);
            }
        }
    }

    public void refineDependencies(Module module, Set<Dependency> set) {
        Object object;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            object = Repository.getDefault().getDefaultFileSystem().findResource("ModuleAutoDeps");
            if (object != null) {
                FileObject[] fileObjectArray = object.getChildren();
                ArrayList<URL> arrayList = new ArrayList<URL>(Math.max(fileObjectArray.length, 1));
                for (FileObject fileObject : fileObjectArray) {
                    if (!fileObject.hasExt("xml")) continue;
                    try {
                        arrayList.add(fileObject.getURL());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Util.err.log(Level.WARNING, null, fileStateInvalidException);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(arrayList.toArray(new URL[arrayList.size()]));
                }
                catch (IOException iOException) {
                    Util.err.log(Level.WARNING, null, iOException);
                }
                catch (SAXException sAXException) {
                    Util.err.log(Level.WARNING, null, sAXException);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Auto deps: " + this.autoDepsHandler);
            }
        }
        if (((AutomaticDependencies.Report)(object = this.autoDepsHandler.refineDependenciesAndReport(module.getCodeNameBase(), set))).isModified()) {
            Util.err.warning("had to upgrade dependencies for module " + module.getCodeNameBase() + ": added = " + ((AutomaticDependencies.Report)object).getAdded() + " removed = " + ((AutomaticDependencies.Report)object).getRemoved() + "; details: " + ((AutomaticDependencies.Report)object).getMessages());
        }
    }

    public String[] refineProvides(Module module) {
        if (module.getCodeNameBase().equals("org.openide.modules")) {
            boolean bl;
            ArrayList<String> arrayList = new ArrayList<String>(4);
            boolean bl2 = bl = (Utilities.getOperatingSystem() & 0x800) != 0;
            if (Utilities.isUnix()) {
                arrayList.add("org.openide.modules.os.Unix");
                if (!Utilities.isMac()) {
                    arrayList.add("org.openide.modules.os.PlainUnix");
                }
            }
            if (Utilities.isWindows()) {
                arrayList.add("org.openide.modules.os.Windows");
            }
            if (Utilities.isMac()) {
                arrayList.add("org.openide.modules.os.MacOSX");
            }
            if (bl) {
                arrayList.add("org.openide.modules.os.OS2");
            }
            arrayList.add("org.openide.modules.ModuleFormat1");
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        if (module2 == null) {
            for (String string2 : CLASSPATH_PACKAGES) {
                if (!string.startsWith(string2) || this.findKosher(module).contains(string2)) continue;
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("Refusing to load classpath package " + string + " for " + module.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
        }
        return true;
    }

    private Set<String> findKosher(Module module) {
        Set<String> set = this.kosherPackages.get(module);
        if (set == null) {
            set = new HashSet<String>();
            Set set2 = module.getDependencies();
            SpecificationVersion specificationVersion = Util.getModuleDep((Set)set2, (String)"org.openide");
            boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dependency : set2) {
                String string;
                String string2;
                if (dependency.getType() == 1 && dependency.getName().equals("org.netbeans.core.startup/1")) {
                    set.add("org/netbeans/core/startup/");
                    continue;
                }
                if (bl && dependency.getType() == 1) {
                    Module module2;
                    string2 = dependency.getName();
                    int n = string2.indexOf(47);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((module2 = this.mgr.get(string2)) == null) {
                        throw new IllegalStateException("Should have found dep " + dependency + " from " + module);
                    }
                    set.addAll(this.findKosher(module2));
                    continue;
                }
                if (dependency.getType() != 2) continue;
                string2 = dependency.getName();
                int n = string2.indexOf(91);
                if (n == -1) {
                    string = string2.replace('.', '/').concat("/");
                } else if (n == 0) {
                    int n2 = string2.lastIndexOf(46);
                    string = string2.substring(1, n2).replace('.', '/').concat("/");
                } else {
                    string = string2.substring(0, n).replace('.', '/').concat("/");
                }
                for (String string3 : CLASSPATH_PACKAGES) {
                    if (!string.startsWith(string3)) continue;
                    set.add(string3);
                }
            }
            if (set.isEmpty()) {
                set = Collections.emptySet();
            }
            this.kosherPackages.put(module, set);
        }
        return set;
    }

    static void openideModuleEnabled(Module module) {
        String string = module.getCodeNameBase();
        if (!string.startsWith("org.openide.")) {
            return;
        }
        if ("org.openide.util".equals(string)) {
            return;
        }
        if ("org.openide.actions".equals(string)) {
            return;
        }
        if ("org.openide.awt".equals(string)) {
            return;
        }
        if ("org.openide.modules".equals(string)) {
            return;
        }
        if ("org.openide.nodes".equals(string)) {
            return;
        }
        if ("org.openide.windows".equals(string)) {
            return;
        }
        if ("org.openide.explorer".equals(string)) {
            return;
        }
        if ("org.openide.util.enumerations".equals(string)) {
            return;
        }
        if ("org.openide.execution".equals(string)) {
            return;
        }
        if ("org.openide.options".equals(string)) {
            return;
        }
        if ("org.openide.execution".equals(string)) {
            return;
        }
        if ("org.openide.loaders".equals(string)) {
            return;
        }
        if ("org.openide.dialogs".equals(string)) {
            return;
        }
        if ("org.openide.filesystems".equals(string)) {
            return;
        }
        if ("org.openide.io".equals(string)) {
            return;
        }
        if ("org.openide.text".equals(string)) {
            return;
        }
        if ("org.openide.src".equals(string)) {
            return;
        }
        Util.err.warning("Disabling openide load optimizations due to use of " + string);
        withoutOptimizations = true;
    }

    public boolean isSpecialResource(String string) {
        if (string.startsWith("org/openide/")) {
            if ("org/openide/".equals(string)) {
                return true;
            }
            if ("org/openide/actions/".equals(string)) {
                return true;
            }
            if ("org/openide/awt/".equals(string)) {
                return true;
            }
            if ("org/openide/cookies/".equals(string)) {
                return true;
            }
            if ("org/openide/explorer/propertysheet/editors/".equals(string)) {
                return true;
            }
            if ("org/openide/windows/".equals(string)) {
                return true;
            }
            if ("org/openide/text/".equals(string)) {
                return true;
            }
            if ("org/openide/util/actions/".equals(string)) {
                return true;
            }
            if (withoutOptimizations) {
                if ("org/openide/explorer/".equals(string)) {
                    return true;
                }
                if ("org/openide/util/".equals(string)) {
                    return true;
                }
            }
        }
        if (this.isSpecialResourceFromSystemProperty(string)) {
            return true;
        }
        if (string.equals("org/w3c/dom/")) {
            return true;
        }
        if (string.equals("org/w3c/dom/ls/")) {
            return true;
        }
        return super.isSpecialResource(string);
    }

    private boolean isSpecialResourceFromSystemProperty(String string) {
        for (String string2 : NbInstaller.getSpecialResourcePrefixes()) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static String[] getSpecialResourcePrefixes() {
        if (specialResourcePrefixes == null) {
            String string = System.getProperty("org.netbeans.core.startup.specialResource");
            specialResourcePrefixes = string != null ? string.split(",") : new String[0];
        }
        return specialResourcePrefixes;
    }

    String getEffectiveClasspath(Module module) {
        if (!module.isEnabled()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(arrayList);
        Set<String> set = module.isFixed() ? null : this.findKosher(module);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        stringTokenizer = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        HashSet<Module> hashSet = new HashSet<Module>(50);
        HashSet<String> hashSet2 = new HashSet<String>(10);
        for (Dependency dependency : module.getDependencies()) {
            if (dependency.getType() != 1 || dependency.getComparison() != 2) continue;
            hashSet2.add(dependency.getName());
        }
        SpecificationVersion specificationVersion = Util.getModuleDep((Set)module.getDependencies(), (String)"org.openide");
        boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(module, module, hashSet, hashSet2, arrayList, bl ? Integer.MAX_VALUE : 1);
        StringBuilder stringBuilder = new StringBuilder(arrayList.size() * 100 + 1);
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static void createBootClassPath(List<String> list) {
        Object object;
        String string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                list.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (File file2 : fileArray) {
                    String string2 = file2.getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    list.add(file2.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File file, List<String> list, Set<String> set) {
        if (file.isDirectory()) {
            list.add(file.getAbsolutePath());
            return;
        }
        String string = file.getName();
        for (String[] stringArray : CLASSPATH_JARS) {
            if (set == null || !string.startsWith(stringArray[0])) continue;
            StringBuffer stringBuffer = null;
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!set.contains(string2)) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                    stringBuffer.append(file.getAbsolutePath());
                    stringBuffer.append('[');
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string2.replace('/', '.'));
                stringBuffer.append("**");
            }
            if (stringBuffer != null) {
                stringBuffer.append(']');
                list.add(stringBuffer.toString());
            }
            return;
        }
        list.add(file.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module module, Module module2, Set<Module> set, Set<String> set2, List<String> list, int n) {
        Object object;
        String string;
        Module.PackageExport[] packageExportArray2;
        if (!set.add(module)) {
            return;
        }
        for (Module.PackageExport[] packageExportArray2 : module.getDependencies()) {
            if (packageExportArray2.getType() != 1) continue;
            string = (String)Util.parseCodeName((String)packageExportArray2.getName())[0];
            object = this.mgr.get(string);
            if (object == null) {
                throw new IllegalStateException("No such module: " + string);
            }
            if (n <= 0) continue;
            this.addModuleClasspathEntries((Module)object, module2, set, set2, list, n - 1);
        }
        boolean bl = module == module2 || set2.contains(module.getCodeName());
        packageExportArray2 = bl ? null : module.getPublicPackages();
        string = "";
        if (packageExportArray2 != null) {
            if (packageExportArray2.length == 0) {
                return;
            }
            object = new StringBuffer(100);
            ((StringBuffer)object).append('[');
            for (int i = 0; i < packageExportArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(',');
                }
                ((StringBuffer)object).append(packageExportArray2[i].pkg.replace('/', '.'));
                ((StringBuffer)object).append(packageExportArray2[i].recursive ? "**" : "*");
            }
            ((StringBuffer)object).append(']');
            string = ((StringBuffer)object).toString();
        }
        for (File file : module.getAllJars()) {
            list.add(file.getAbsolutePath() + string);
        }
    }

    public Manifest loadManifest(File file) throws IOException {
        Object[] objectArray;
        if (!this.usingManifestCache) {
            return super.loadManifest(file);
        }
        if (this.manifestCache == null) {
            this.manifestCache = this.loadManifestCache(this.manifestCacheFile);
        }
        if ((objectArray = this.manifestCache.get(file)) != null) {
            if (((Date)objectArray[0]).getTime() == file.lastModified()) {
                Util.err.fine("Found manifest for " + file + " in cache");
                return (Manifest)objectArray[1];
            }
            Util.err.fine("Wrong timestamp for " + file + " in manifest cache");
        } else {
            Util.err.fine("No entry for " + file + " in manifest cache");
        }
        Manifest manifest = super.loadManifest(file);
        this.manifestCache.put(file, new Object[]{new Date(file.lastModified()), manifest});
        this.manifestCacheDirty = true;
        return manifest;
    }

    private void maybeSaveManifestCache() {
        if (this.usingManifestCache && this.manifestCacheDirty) {
            try {
                this.saveManifestCache(this.manifestCache, this.manifestCacheFile);
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, null, iOException);
            }
            this.usingManifestCache = false;
            this.manifestCacheDirty = false;
            this.manifestCache = null;
            this.manifestCacheFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveManifestCache(Map<File, Object[]> map, File file) throws IOException {
        Util.err.fine("Saving manifest cache");
        file.getParentFile().mkdirs();
        OutputStream outputStream = new FileOutputStream(file);
        try {
            try {
                outputStream = new BufferedOutputStream(outputStream);
                for (Map.Entry<File, Object[]> entry : map.entrySet()) {
                    File file2 = entry.getKey();
                    Object[] objectArray = entry.getValue();
                    long l = ((Date)objectArray[0]).getTime();
                    Manifest manifest = (Manifest)objectArray[1];
                    outputStream.write(file2.getAbsolutePath().getBytes("UTF-8"));
                    outputStream.write(0);
                    for (int i = 7; i >= 0; --i) {
                        outputStream.write((int)(l >> i * 8 & 0xFFL));
                    }
                    manifest.write(outputStream);
                    outputStream.write(0);
                }
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, Object[]> loadManifestCache(File file) {
        HashMap<File, Object[]> hashMap;
        if (!file.canRead()) {
            Util.err.fine("No manifest cache found at " + file);
            return new HashMap<File, Object[]>(200);
        }
        this.ev.log("perfStart", new Object[]{"NbInstaller - loadManifestCache"});
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            HashMap<File, Object[]> hashMap2 = new HashMap<File, Object[]>(200);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
            FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            NbInstaller.readManifestCacheEntries(byArray, hashMap2);
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
                throw throwable;
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, "While reading: " + file, iOException);
                return new HashMap<File, Object[]>(200);
            }
        }
        ((InputStream)fileInputStream).close();
        this.ev.log("perfEnd", new Object[]{"NbInstaller - loadManifestCache"});
        return hashMap;
    }

    private static int findNullByte(byte[] byArray, int n) {
        int n2 = byArray.length;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(byte[] byArray, Map<File, Object[]> map) throws IOException {
        int n = 0;
        while (n != byArray.length) {
            Manifest manifest;
            int n2 = NbInstaller.findNullByte(byArray, n);
            if (n2 == -1) {
                throw new IOException("Could not find next manifest JAR name from " + n);
            }
            File file = new File(new String(byArray, n, n2 - n, "UTF-8"));
            long l = 0L;
            if (n2 + 8 >= byArray.length) {
                throw new IOException("Ran out of space for timestamp for " + file);
            }
            for (int i = 0; i < 8; ++i) {
                long l2 = byArray[n2 + i + 1];
                if (l2 < 0L) {
                    l2 += 256L;
                }
                int n3 = 7 - i;
                long l3 = l2 << n3 * 8;
                l |= l3;
            }
            n = n2 + 9;
            if ((n2 = NbInstaller.findNullByte(byArray, n)) == -1) {
                throw new IOException("Could not find manifest body for " + file);
            }
            try {
                manifest = new Manifest(new ByteArrayInputStream(byArray, n, n2 - n));
            }
            catch (IOException iOException) {
                Exceptions.attachMessage((Throwable)iOException, (String)("While in entry for " + file));
                throw iOException;
            }
            map.put(file, new Object[]{new Date(l), manifest});
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("Manifest cache entry: jar=" + file + " date=" + new Date(l) + " codename=" + manifest.getMainAttributes().getValue("OpenIDE-Module"));
            }
            n = n2 + 1;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> list) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module module : list) {
            if (module.isFixed() || module.getJarFile() == null) continue;
            File file = module.getJarFile();
            try {
                JarFile jarFile = new JarFile(file, true);
                try {
                    for (JarEntry jarEntry : NbCollections.iterable(jarFile.entries())) {
                        String string = jarEntry.getName();
                        if (!string.endsWith(".class")) continue;
                        String string2 = string.substring(0, string.length() - 6).replace('/', '.');
                        Throwable throwable = null;
                        try {
                            Class.forName(string2, false, module.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throwable = classNotFoundException;
                        }
                        catch (LinkageError linkageError) {
                            throwable = linkageError;
                        }
                        catch (RuntimeException runtimeException) {
                            throwable = runtimeException;
                        }
                        if (throwable == null) continue;
                        Util.err.log(Level.WARNING, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), throwable);
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, null, iOException);
            }
        }
    }

    static {
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection manifestSection) {
            try {
                return manifestSection.getInstance();
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
                NbInstaller.this.loadGenericSection(manifestSection, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection manifestSection) {
            return manifestSection.getSuperclass();
        }

        public String id(ManifestSection manifestSection) {
            return manifestSection.toString();
        }

        public String displayName(ManifestSection manifestSection) {
            return manifestSection.toString();
        }
    }
}

