/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

final class NbURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static Logger LOG = Logger.getLogger(NbURLStreamHandlerFactory.class.getName());
    private Lookup.Result<URLStreamHandlerFactory> r = null;
    private URLStreamHandlerFactory[] handlers = null;
    private URLStreamHandlerFactory delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray;
        if (string.equals("jar") || string.equals("file") || string.equals("http") || string.equals("resource")) {
            return null;
        }
        if (string.equals("nbfs")) {
            return FileUtil.nbfsURLStreamHandler();
        }
        if (string.equals("nbres") || string.equals("nbresloc")) {
            return new NbResourceStreamHandler();
        }
        URLStreamHandlerFactory uRLStreamHandlerFactory = this.delegate;
        if (uRLStreamHandlerFactory != null && (uRLStreamHandlerFactoryArray = uRLStreamHandlerFactory.createURLStreamHandler(string)) != null) {
            return uRLStreamHandlerFactoryArray;
        }
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            if (this.r == null) {
                this.r = Lookup.getDefault().lookupResult(URLStreamHandlerFactory.class);
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            uRLStreamHandlerFactoryArray = this.handlers;
        }
        if (uRLStreamHandlerFactoryArray == null) {
            return null;
        }
        for (int i = 0; i < uRLStreamHandlerFactoryArray.length; ++i) {
            URLStreamHandler uRLStreamHandler = uRLStreamHandlerFactoryArray[i].createURLStreamHandler(string);
            if (uRLStreamHandler == null) continue;
            return uRLStreamHandler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.r.allInstances();
        NbURLStreamHandlerFactory nbURLStreamHandlerFactory = this;
        synchronized (nbURLStreamHandlerFactory) {
            this.handlers = collection.toArray(new URLStreamHandlerFactory[0]);
        }
    }

    void registerUsingReflection(Error error) {
        LOG.log(Level.CONFIG, "Problems registering URLStreamHandlerFactory, trying reflection", error);
        try {
            URLStreamHandlerFactory uRLStreamHandlerFactory = null;
            for (Field field : URL.class.getDeclaredFields()) {
                LOG.log(Level.FINEST, "Found field {0}", field);
                if (field.getType() != URLStreamHandlerFactory.class) continue;
                LOG.log(Level.FINEST, "Clearing field {0}");
                field.setAccessible(true);
                uRLStreamHandlerFactory = (URLStreamHandlerFactory)field.get(null);
                LOG.log(Level.CONFIG, "Previous value was {0}", uRLStreamHandlerFactory);
                field.set(null, null);
                LOG.config("Field is supposed to be empty");
                break;
            }
            URL.setURLStreamHandlerFactory(this);
            this.delegate = uRLStreamHandlerFactory;
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, "No way to register URLStreamHandlerFactory; NetBeans is unlikely to work", throwable);
        }
    }

    private static final class NbResourceStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL_SYSTEM_RESOURCE = "nbres";
        public static final String PROTOCOL_LOCALIZED_SYSTEM_RESOURCE = "nbresloc";

        public URLConnection openConnection(URL uRL) throws IOException {
            if (uRL.getProtocol().equals(PROTOCOL_SYSTEM_RESOURCE)) {
                return new Connection(uRL, false);
            }
            if (uRL.getProtocol().equals(PROTOCOL_LOCALIZED_SYSTEM_RESOURCE)) {
                return new Connection(uRL, true);
            }
            throw new IOException("Bad protocol: " + uRL.getProtocol());
        }

        private static class Connection
        extends URLConnection {
            private final boolean localized;
            private URLConnection real;
            private IOException exception = null;

            public Connection(URL uRL, boolean bl) {
                super(uRL);
                this.localized = bl;
            }

            public synchronized void connect() throws IOException {
                if (this.exception != null) {
                    IOException iOException = this.exception;
                    this.exception = null;
                    throw iOException;
                }
                if (!this.connected) {
                    URL uRL;
                    String string = this.url.getPath();
                    if (string.length() > 0 && string.charAt(0) == '/') {
                        string = string.substring(1);
                    }
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    URL uRL2 = classLoader.getResource(string);
                    if (this.localized) {
                        String string2;
                        String string3;
                        String string4;
                        int n = string.lastIndexOf(46);
                        if (n < string.lastIndexOf(47)) {
                            n = -1;
                        }
                        if (n != -1) {
                            string4 = string.substring(0, n);
                            string3 = string.substring(n);
                        } else {
                            string4 = string;
                            string3 = "";
                        }
                        uRL = null;
                        Iterator iterator = NbBundle.getLocalizingSuffixes();
                        while (iterator.hasNext() && (uRL = "".equals(string2 = (String)iterator.next()) ? uRL2 : classLoader.getResource(string4 + string2 + string3)) == null) {
                        }
                    } else {
                        uRL = uRL2;
                    }
                    if (uRL == null) {
                        throw new IOException(NbBundle.getMessage(NbURLStreamHandlerFactory.class, (String)"EXC_nbres_cannot_connect", (Object)this.url));
                    }
                    this.real = uRL.openConnection();
                    this.real.connect();
                    this.connected = true;
                }
            }

            private void tryToConnect() {
                if (this.connected || this.exception != null) {
                    return;
                }
                try {
                    this.connect();
                }
                catch (IOException iOException) {
                    this.exception = iOException;
                }
            }

            public String getHeaderField(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(n);
                }
                return null;
            }

            public String getHeaderFieldKey(int n) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderFieldKey(n);
                }
                return null;
            }

            public String getHeaderField(String string) {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getHeaderField(string);
                }
                return null;
            }

            public InputStream getInputStream() throws IOException {
                this.connect();
                return this.real.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                this.connect();
                return this.real.getOutputStream();
            }

            public String getContentType() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentType();
                }
                return "application/octet-stream";
            }

            public int getContentLength() {
                this.tryToConnect();
                if (this.connected) {
                    return this.real.getContentLength();
                }
                return 0;
            }
        }
    }
}

