/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.CLIOptions;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXParseException;

public final class TopLogging {
    private static boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private static final PrintStream OLD_ERR = System.err;
    private static String previousUser;
    private static Handler streamHandler;
    private static Handler defaultHandler;

    public TopLogging() {
        Handler[] handlerArray;
        Map.Entry<Object, Object> entry2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            handlerArray = (Handler[])entry2.getKey();
            if ("sun.os.patch.level".equals(handlerArray)) continue;
            String string = (String)entry2.getValue();
            if (!handlerArray.endsWith(".level")) continue;
            printStream.print((String)handlerArray);
            printStream.print("=");
            printStream.println(string);
        }
        printStream.close();
        try {
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        entry2 = Logger.getLogger("");
        handlerArray = ((Logger)((Object)entry2)).getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            ((Logger)((Object)entry2)).removeHandler(handlerArray[i]);
        }
        ((Logger)((Object)entry2)).addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            ((Logger)((Object)entry2)).addHandler(TopLogging.streamHandler());
        }
        ((Logger)((Object)entry2)).addHandler(new LookupDel());
    }

    static final void initialize() {
        block6: {
            if (previousUser == null || previousUser.equals(System.getProperty("netbeans.user"))) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = TopLogging.class.getName();
            if (string != null && !string.equals(string2)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", string2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            TopLogging.printSystemInfo(printStream);
            printStream.close();
            try {
                Logger logger = Logger.getLogger(TopLogging.class.getName());
                logger.log(Level.INFO, byteArrayOutputStream.toString("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        if (!(System.err instanceof LgStream)) {
            System.setErr(new LgStream(Logger.getLogger("stderr")));
        }
    }

    private static void printSystemInfo(PrintStream printStream) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        printStream.println("-------------------------------------------------------------------------------");
        printStream.println(">Log Session: " + dateFormat.format(date));
        printStream.println(">System Info: ");
        String string = System.getProperty("netbeans.buildnumber");
        String string2 = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)string);
        printStream.println("  Product Version         = " + string2);
        printStream.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor; Home  = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown") + "; " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encoding = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        printStream.println("  Home Dir.; Current Dir. = " + System.getProperty("user.home", "unknown") + "; " + System.getProperty("user.dir", "unknown"));
        printStream.print("  Installation; User Dir. = ");
        String string4 = System.getProperty("netbeans.dirs");
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                printStream.print(FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken())));
                printStream.print(File.pathSeparatorChar);
            }
        }
        printStream.println(CLIOptions.getHomeDir() + "; " + CLIOptions.getUserDir());
        printStream.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        printStream.println("  Application Classpath   = " + System.getProperty("java.class.path", "unknown"));
        printStream.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        printStream.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), stringBuffer);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), stringBuffer);
        return stringBuffer.toString();
    }

    private static void findBootJars(String string, StringBuffer stringBuffer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream printStream) {
        StreamHandler streamHandler = new StreamHandler(printStream, NbFormatter.FORMATTER);
        return streamHandler;
    }

    private static synchronized Handler streamHandler() {
        if (streamHandler == null) {
            StreamHandler streamHandler = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            streamHandler.setLevel(Level.ALL);
            TopLogging.streamHandler = new NonClose(streamHandler, 500);
        }
        return streamHandler;
    }

    private static synchronized Handler defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        String string = System.getProperty("netbeans.user");
        if (string != null && !"memory".equals(string) && !CLIOptions.noLogging) {
            try {
                File file = new File(new File(new File(string), "var"), "log");
                file.mkdirs();
                File file2 = new File(file, "messages.log");
                File file3 = new File(file, "messages.log.1");
                File file4 = new File(file, "messages.log.2");
                if (file3.exists()) {
                    file3.renameTo(file4);
                }
                if (file2.exists()) {
                    file2.renameTo(file3);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
                StreamHandler streamHandler = new StreamHandler(fileOutputStream, NbFormatter.FORMATTER);
                streamHandler.setLevel(Level.ALL);
                streamHandler.setFormatter(NbFormatter.FORMATTER);
                defaultHandler = new NonClose(streamHandler, 5000);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean bl) {
        Handler handler;
        Handler handler2 = streamHandler;
        if (handler2 != null) {
            handler2.flush();
        }
        if ((handler = defaultHandler) != null) {
            handler.flush();
        }
        if (bl) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        Handler handler;
        Handler handler2 = streamHandler;
        if (handler2 instanceof NonClose) {
            handler = (NonClose)handler2;
            ((NonClose)handler).doClose();
        }
        if ((handler = defaultHandler) != null) {
            NonClose nonClose = (NonClose)handler;
            nonClose.doClose();
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.startup.TopLogging$AWTHandler");
    }

    public static final class AWTHandler {
        public static void handle(Throwable throwable) {
            if (throwable.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            Logger.global.log(Level.SEVERE, null, throwable);
        }
    }

    private static final class LgStream
    extends PrintStream {
        private Logger log;
        private StringBuffer sb = new StringBuffer();
        private ThreadLocal<Integer> FLUSHING = new ThreadLocal();

        public LgStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.log = logger;
        }

        public void write(byte[] byArray, int n, int n2) {
            if (this.FLUSHING.get() != null) {
                return;
            }
            this.sb.append(new String(byArray, n, n2));
            this.checkFlush();
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(int n) {
            if (this.FLUSHING.get() != null) {
                return;
            }
            this.sb.append((char)n);
            this.checkFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFlush() {
            try {
                this.FLUSHING.set(1);
                this.doFlush();
            }
            finally {
                this.FLUSHING.set(null);
            }
        }

        private void doFlush() {
            int n;
            boolean bl = false;
            while ((n = this.sb.indexOf("\n")) >= 0) {
                bl = false;
                if (n == 0) {
                    bl = true;
                    this.sb.delete(0, 1);
                    continue;
                }
                this.log.log(Level.INFO, this.sb.substring(0, n + 1));
                this.sb.delete(0, n + 1);
            }
            if (bl) {
                this.log.log(Level.INFO, "\n");
            }
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.handlers.addLookupListener((LookupListener)this);
        }

        public void publish(LogRecord logRecord) {
            for (Handler handler : this.instances) {
                handler.publish(logRecord);
            }
        }

        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.instances = this.handlers.allInstances();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NbFormatter
    extends Formatter {
        private static String lineSeparator = System.getProperty("line.separator");
        static Formatter FORMATTER = new NbFormatter();

        private NbFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, logRecord, new HashSet<Throwable>());
            return stringBuilder.toString();
        }

        private void print(StringBuilder stringBuilder, LogRecord logRecord, Set<Throwable> set) {
            String string = this.formatMessage(logRecord);
            if (string != null && string.indexOf(10) != -1 && logRecord.getThrown() == null) {
                stringBuilder.append(string);
                return;
            }
            if ("stderr".equals(logRecord.getLoggerName()) && logRecord.getLevel() == Level.INFO) {
                stringBuilder.append(string);
                return;
            }
            stringBuilder.append(logRecord.getLevel().getLocalizedName());
            NbFormatter.addLoggerName(stringBuilder, logRecord);
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            stringBuilder.append(lineSeparator);
            if (logRecord.getThrown() != null && logRecord.getLevel().intValue() != 1973) {
                LogRecord[] logRecordArray;
                try {
                    logRecordArray = new StringWriter();
                    LogRecord[] logRecordArray2 = new PrintWriter((Writer)logRecordArray);
                    StackTraceElement[] stackTraceElementArray = logRecord.getThrown().getStackTrace();
                    StackTraceElement[] stackTraceElementArray2 = new Throwable().getStackTrace();
                    int n = -1;
                    for (int i = 1; i <= Math.min(stackTraceElementArray.length, stackTraceElementArray2.length); ++i) {
                        if (stackTraceElementArray[stackTraceElementArray.length - i].equals(stackTraceElementArray2[stackTraceElementArray2.length - i])) continue;
                        n = stackTraceElementArray.length - i + 1;
                        break;
                    }
                    String[] stringArray = NbFormatter.decompose(logRecord.getThrown());
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == n) {
                            logRecordArray2.print("[catch]");
                            if (stringArray[i].charAt(0) == '\t') {
                                logRecordArray2.print(' ');
                                stringArray[i] = stringArray[i].substring(1);
                            }
                        }
                        logRecordArray2.println(stringArray[i]);
                    }
                    logRecordArray2.close();
                    stringBuilder.append(logRecordArray.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                logRecordArray = NbFormatter.extractDelegates(stringBuilder, logRecord.getThrown(), set);
                if (logRecordArray != null) {
                    for (LogRecord logRecord2 : logRecordArray) {
                        this.print(stringBuilder, logRecord2, set);
                    }
                }
                this.specialProcessing(stringBuilder, logRecord.getThrown(), set);
            }
        }

        private static void addLoggerName(StringBuilder stringBuilder, LogRecord logRecord) {
            String string = logRecord.getLoggerName();
            if (!"".equals(string)) {
                stringBuilder.append(" [");
                stringBuilder.append(string);
                stringBuilder.append(']');
            }
        }

        private static LogRecord[] extractDelegates(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            if (!set.add(throwable)) {
                stringBuilder.append("warning: cyclic dependency between annotated throwables");
                return null;
            }
            if (throwable instanceof Callable) {
                Object var3_3 = null;
                try {
                    var3_3 = ((Callable)((Object)throwable)).call();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (var3_3 instanceof LogRecord[]) {
                    return var3_3;
                }
            }
            if (throwable == null) {
                return null;
            }
            return NbFormatter.extractDelegates(stringBuilder, throwable.getCause(), set);
        }

        private void specialProcessing(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
            Object object;
            String string;
            Exception exception;
            if (throwable instanceof MissingResourceException) {
                exception = (MissingResourceException)throwable;
                string = ((MissingResourceException)exception).getClassName();
                if (string != null) {
                    object = new LogRecord(Level.CONFIG, null);
                    ((LogRecord)object).setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    ((LogRecord)object).setMessage("EXC_MissingResourceException_class_name");
                    ((LogRecord)object).setParameters(new Object[]{string});
                    this.print(stringBuilder, (LogRecord)object, set);
                }
                if ((object = ((MissingResourceException)exception).getKey()) != null) {
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage("EXC_MissingResourceException_key");
                    logRecord.setParameters(new Object[]{object});
                    this.print(stringBuilder, logRecord, set);
                }
            }
            if (throwable instanceof SAXParseException) {
                exception = (SAXParseException)throwable;
                string = ((SAXParseException)exception).getPublicId();
                object = ((SAXParseException)exception).getSystemId();
                if (string != null || object != null) {
                    Object[] objectArray;
                    String string2;
                    int n = ((SAXParseException)exception).getColumnNumber();
                    int n2 = ((SAXParseException)exception).getLineNumber();
                    if (n != -1 || n2 != -1) {
                        string2 = "EXC_sax_parse_col_line";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object), new Integer(n), new Integer(n2)};
                    } else {
                        string2 = "EXC_sax_parse";
                        objectArray = new Object[]{String.valueOf(string), String.valueOf(object)};
                    }
                    LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                    logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    logRecord.setMessage(string2);
                    logRecord.setParameters(objectArray);
                    this.print(stringBuilder, logRecord, set);
                }
            }
        }

        private static String[] decompose(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.toString().split("(\r\n?|\n)($|(?=\\s*at ))");
        }
    }

    private static final class NonClose
    extends Handler
    implements Runnable {
        private static RequestProcessor RP = new RequestProcessor("Logging Flush");
        private final Handler delegate;
        private RequestProcessor.Task flush;
        private int delay;

        public NonClose(Handler handler, int n) {
            this.delegate = handler;
            this.flush = RP.create((Runnable)this, true);
            this.flush.setPriority(1);
            this.delay = n;
        }

        public void publish(LogRecord logRecord) {
            this.delegate.publish(logRecord);
            this.flush.schedule(this.delay);
        }

        public void flush() {
            this.flush.cancel();
            this.flush.waitFinished();
            this.delegate.flush();
        }

        public void close() throws SecurityException {
            this.flush();
            this.delegate.flush();
        }

        public void doClose() throws SecurityException {
            this.flush();
            this.delegate.close();
        }

        public Formatter getFormatter() {
            return this.delegate.getFormatter();
        }

        static Handler getInternal(Handler handler) {
            if (handler instanceof NonClose) {
                return ((NonClose)handler).delegate;
            }
            return handler;
        }

        public void run() {
            this.delegate.flush();
        }
    }
}

