/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLayeredFileSystem
extends MultiFileSystem {
    private static final long serialVersionUID = 782910986724201983L;
    private static final String LAYER_STAMP = "layer-stamp.txt";
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;

    ModuleLayeredFileSystem(FileSystem fileSystem, FileSystem[] fileSystemArray, File file) throws IOException {
        this(fileSystem, fileSystemArray, ModuleLayeredFileSystem.manager(file));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager) throws IOException {
        this(fileSystem, fileSystemArray, layerCacheManager, ModuleLayeredFileSystem.loadCache(layerCacheManager));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager, FileSystem fileSystem2) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(fileSystem, fileSystemArray, fileSystem2));
        this.manager = layerCacheManager;
        this.writableLayer = fileSystem;
        this.otherLayers = fileSystemArray;
        this.cacheLayer = fileSystem2;
        this.setPropagateMasks(true);
        this.urls = null;
    }

    private static LayerCacheManager manager(File file) throws IOException {
        if (file != null) {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Could not make dir: " + file);
            }
            String string = "org.netbeans.core.startup.layers.BinaryCacheManager";
            String string2 = System.getProperty("netbeans.cache.layers", string);
            if (string2.equals("-")) {
                err.fine("Cache manager disabled");
                return LayerCacheManager.emptyManager();
            }
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(File.class);
                LayerCacheManager layerCacheManager = (LayerCacheManager)constructor.newInstance(file);
                err.fine("Using cache manager of type " + string2 + " in " + file);
                return layerCacheManager;
            }
            catch (Exception exception) {
                throw (IOException)new IOException(exception.toString()).initCause(exception);
            }
        }
        err.fine("No cache manager");
        return LayerCacheManager.emptyManager();
    }

    private static FileSystem loadCache(LayerCacheManager layerCacheManager) throws IOException {
        if (layerCacheManager.cacheExists()) {
            FileSystem fileSystem;
            ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_load_cache"));
            String string = "Loading layers from " + layerCacheManager.getCacheDirectory();
            StartLog.logStart(string);
            try {
                fileSystem = layerCacheManager.createLoadedFileSystem();
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, null, iOException);
                layerCacheManager.cleanupCache();
                ModuleLayeredFileSystem.cleanStamp(layerCacheManager.getCacheDirectory());
                fileSystem = layerCacheManager.createEmptyFileSystem();
            }
            ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_load_cache"));
            StartLog.logEnd(string);
            return fileSystem;
        }
        return layerCacheManager.createEmptyFileSystem();
    }

    private static FileSystem[] appendLayers(FileSystem fileSystem, FileSystem[] fileSystemArray, FileSystem fileSystem2) {
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(fileSystemArray.length + 2);
        arrayList.add(fileSystem);
        arrayList.addAll(Arrays.asList(fileSystemArray));
        arrayList.add(fileSystem2);
        return arrayList.toArray(new FileSystem[arrayList.size()]);
    }

    private static void cleanStamp(File file) throws IOException {
        File file2 = new File(file, LAYER_STAMP);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Could not delete: " + file2);
        }
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        SystemFileSystem systemFileSystem = (SystemFileSystem)fileSystem;
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem = (SystemFileSystem)Repository.getDefault().getDefaultFileSystem();
        return systemFileSystem.getUserLayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLs(final List<URL> list) throws Exception {
        Stamp stamp;
        File file;
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("setURLs: " + list);
        }
        if (this.urls != null && ((Object)list).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        final File file2 = this.manager.getCacheDirectory();
        if (file2 != null) {
            file = new File(file2, LAYER_STAMP);
            stamp = new Stamp(this.manager.getClass().getName(), list);
        } else {
            file = null;
            stamp = null;
        }
        if (file2 != null && file.isFile()) {
            err.fine("Stamp of new URLs: " + stamp.getHash());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                long l;
                String string = bufferedReader.readLine();
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(numberFormatException.toString());
                }
                err.fine("Stamp in the cache: " + l);
                if (l == stamp.getHash()) {
                    err.fine("Cache hit!");
                    this.urls = list;
                    StartLog.logEnd("setURLs");
                    return;
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        this.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ModuleLayeredFileSystem moduleLayeredFileSystem = ModuleLayeredFileSystem.this;
                synchronized (moduleLayeredFileSystem) {
                    if (file2 != null) {
                        ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_rewrite_cache"));
                        err.fine("Rewriting cache in " + file2);
                    }
                    try {
                        if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                            ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, list);
                        } else {
                            ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(list);
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                    }
                    catch (IOException iOException) {
                        err.log(Level.WARNING, null, iOException);
                        err.fine("Abandoning cache manager");
                        ModuleLayeredFileSystem.this.manager.cleanupCache();
                        ModuleLayeredFileSystem.cleanStamp(file2);
                        ModuleLayeredFileSystem.this.manager = LayerCacheManager.emptyManager();
                        try {
                            if (ModuleLayeredFileSystem.this.manager.supportsLoad()) {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.createEmptyFileSystem();
                                ModuleLayeredFileSystem.this.manager.store(ModuleLayeredFileSystem.this.cacheLayer, list);
                            } else {
                                ModuleLayeredFileSystem.this.cacheLayer = ModuleLayeredFileSystem.this.manager.store(list);
                            }
                            ModuleLayeredFileSystem.this.setDelegates(ModuleLayeredFileSystem.appendLayers(ModuleLayeredFileSystem.this.writableLayer, ModuleLayeredFileSystem.this.otherLayers, ModuleLayeredFileSystem.this.cacheLayer));
                        }
                        catch (IOException iOException2) {
                            err.log(Level.WARNING, null, iOException2);
                        }
                        return;
                    }
                    if (file != null) {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                        try {
                            outputStreamWriter.write(Long.toString(stamp.getHash()));
                            outputStreamWriter.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about layer cache, for debugging purposes.\n");
                            outputStreamWriter.write(stamp.toString());
                        }
                        finally {
                            ((Writer)outputStreamWriter).close();
                        }
                    }
                    if (file2 != null) {
                        ModuleLayeredFileSystem.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_rewrite_cache"));
                        err.fine("Finished rewriting cache in " + file2);
                    }
                }
            }
        });
        this.urls = list;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(collection);
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        arrayList.removeAll(collection);
        this.setURLs(arrayList);
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stamp
    implements Comparator<URL> {
        private final String managerName;
        private final List<URL> urls;
        private final long[] times;
        private final long hash;

        public Stamp(String string, List<URL> list) throws IOException {
            this.managerName = string;
            this.urls = new ArrayList<URL>(list);
            Collections.sort(this.urls, this);
            this.times = new long[this.urls.size()];
            long l = 0x11L ^ (long)this.managerName.hashCode();
            Iterator<URL> iterator = this.urls.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                URL uRL;
                URL uRL2 = iterator.next();
                String string2 = uRL2.toExternalForm();
                l += 3199876987199633L;
                l ^= (long)string2.hashCode();
                if (string2.startsWith("jar:")) {
                    int n2 = string2.lastIndexOf("!/");
                    if (n2 != -1) {
                        uRL = new URL(string2.substring(4, n2));
                    } else {
                        err.warning("Weird JAR URL: " + uRL2);
                        uRL = uRL2;
                    }
                } else {
                    uRL = uRL2;
                }
                File file = new File(URI.create(uRL.toExternalForm()));
                if (file != null) {
                    int n3 = n++;
                    long l2 = file.lastModified();
                    this.times[n3] = l2;
                    l ^= l2;
                    continue;
                }
                this.times[n++] = 0L;
            }
            this.hash = l;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.managerName);
            stringBuilder.append('\n');
            Iterator<URL> iterator = this.urls.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long l;
                if ((l = this.times[n++]) == 0L) {
                    stringBuilder.append("<file not found>");
                } else {
                    stringBuilder.append(new Date(l));
                }
                stringBuilder.append('\t').append(iterator.next()).append('\n');
            }
            return stringBuilder.toString();
        }

        @Override
        public int compare(URL uRL, URL uRL2) {
            return uRL.toString().compareTo(uRL2.toString());
        }
    }
}

