/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalPathRegistry {
    private static final Logger LOG = Logger.getLogger(GlobalPathRegistry.class.getName());
    private static GlobalPathRegistry DEFAULT = new GlobalPathRegistry();
    private int resetCount;
    private final Map<String, List<ClassPath>> paths = new HashMap<String, List<ClassPath>>();
    private final List<GlobalPathRegistryListener> listeners = new ArrayList<GlobalPathRegistryListener>();
    private Set<FileObject> sourceRoots = null;
    private Set<SourceForBinaryQuery.Result> results = new HashSet<SourceForBinaryQuery.Result>();
    private final ChangeListener resultListener = new SFBQListener();
    private PropertyChangeListener classpathListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    };

    public static GlobalPathRegistry getDefault() {
        return DEFAULT;
    }

    private GlobalPathRegistry() {
    }

    void clear() {
        this.paths.clear();
        this.listeners.clear();
    }

    public synchronized Set<ClassPath> getPaths(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        List<ClassPath> list = this.paths.get(string);
        if (list != null && !list.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet<ClassPath>(list));
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String string, ClassPath[] classPathArray) {
        if (string == null || classPathArray == null) {
            throw new NullPointerException();
        }
        LOG.log(Level.FINE, "registering paths {0} of type {1}", new Object[]{Arrays.asList(classPathArray), string});
        GlobalPathRegistryEvent globalPathRegistryEvent = null;
        GlobalPathRegistryListener[] globalPathRegistryListenerArray = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            List<ClassPath> list = this.paths.get(string);
            if (list == null) {
                list = new ArrayList<ClassPath>();
                this.paths.put(string, list);
            }
            HashSet<ClassPath> hashSet = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (ClassPath classPath : classPathArray) {
                if (classPath == null) {
                    throw new NullPointerException("Null path encountered in " + Arrays.asList(classPathArray) + " of type " + string);
                }
                if (hashSet != null && !hashSet.contains(classPath) && !list.contains(classPath)) {
                    hashSet.add(classPath);
                }
                if (!list.contains(classPath)) {
                    classPath.addPropertyChangeListener(this.classpathListener);
                }
                list.add(classPath);
            }
            if (hashSet != null && !hashSet.isEmpty()) {
                globalPathRegistryListenerArray = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                globalPathRegistryEvent = new GlobalPathRegistryEvent(this, string, Collections.unmodifiableSet(hashSet));
            }
            this.resetSourceRootsCache();
        }
        if (globalPathRegistryListenerArray != null) {
            assert (globalPathRegistryEvent != null);
            for (GlobalPathRegistryListener globalPathRegistryListener : globalPathRegistryListenerArray) {
                globalPathRegistryListener.pathsAdded(globalPathRegistryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String string, ClassPath[] classPathArray) throws IllegalArgumentException {
        LOG.log(Level.FINE, "unregistering paths {0} of type {1}", new Object[]{Arrays.asList(classPathArray), string});
        if (string == null || classPathArray == null) {
            throw new NullPointerException();
        }
        GlobalPathRegistryEvent globalPathRegistryEvent = null;
        GlobalPathRegistryListener[] globalPathRegistryListenerArray = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            List<ClassPath> list = this.paths.get(string);
            if (list == null) {
                list = new ArrayList<ClassPath>();
            }
            ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>(list);
            HashSet<ClassPath> object = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (ClassPath classPath : classPathArray) {
                if (classPath == null) {
                    throw new NullPointerException();
                }
                if (!arrayList.remove(classPath)) {
                    throw new IllegalArgumentException("Attempt to remove nonexistent path " + classPath);
                }
                if (object != null && !object.contains(classPath) && !arrayList.contains(classPath)) {
                    object.add(classPath);
                }
                if (arrayList.contains(classPath)) continue;
                classPath.removePropertyChangeListener(this.classpathListener);
            }
            this.paths.put(string, arrayList);
            if (object != null && !object.isEmpty()) {
                globalPathRegistryListenerArray = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                globalPathRegistryEvent = new GlobalPathRegistryEvent(this, string, Collections.unmodifiableSet(object));
            }
            this.resetSourceRootsCache();
        }
        if (globalPathRegistryListenerArray != null) {
            assert (globalPathRegistryEvent != null);
            for (GlobalPathRegistry globalPathRegistry2 : globalPathRegistryListenerArray) {
                globalPathRegistry2.pathsRemoved(globalPathRegistryEvent);
            }
        }
    }

    public synchronized void addGlobalPathRegistryListener(GlobalPathRegistryListener globalPathRegistryListener) {
        if (globalPathRegistryListener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(globalPathRegistryListener);
    }

    public synchronized void removeGlobalPathRegistryListener(GlobalPathRegistryListener globalPathRegistryListener) {
        if (globalPathRegistryListener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(globalPathRegistryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> getSourceRoots() {
        LinkedHashSet<ClassPath> linkedHashSet;
        Set<ClassPath> set;
        int n;
        Set<FileObject> set2 = this;
        synchronized (set2) {
            if (this.sourceRoots != null) {
                return this.sourceRoots;
            }
            n = this.resetCount;
            set = this.getPaths("classpath/source");
            linkedHashSet = new LinkedHashSet<ClassPath>(this.getPaths("classpath/compile"));
            linkedHashSet.addAll(this.getPaths("classpath/boot"));
        }
        set2 = new LinkedHashSet();
        for (ClassPath object2 : set) {
            set2.addAll(Arrays.asList(object2.getRoots()));
        }
        LinkedList linkedList = new LinkedList();
        SFBQListener sFBQListener = new SFBQListener();
        for (ClassPath classPath : linkedHashSet) {
            for (ClassPath.Entry entry : classPath.entries()) {
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots(entry.getURL());
                result.addChangeListener(sFBQListener);
                linkedList.add(result);
                FileObject[] fileObjectArray = result.getRoots();
                set2.addAll(Arrays.asList(fileObjectArray));
            }
        }
        set2 = Collections.unmodifiableSet(set2);
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            if (this.resetCount == n) {
                this.sourceRoots = set2;
                this.removeTmpSFBQListeners(linkedList, sFBQListener, true);
                this.results.addAll(linkedList);
            } else {
                this.removeTmpSFBQListeners(linkedList, sFBQListener, false);
            }
            return set2;
        }
    }

    private void removeTmpSFBQListeners(List<? extends SourceForBinaryQuery.Result> list, ChangeListener changeListener, boolean bl) {
        for (SourceForBinaryQuery.Result result : list) {
            if (bl) {
                result.addChangeListener(this.resultListener);
            }
            result.removeChangeListener(changeListener);
        }
    }

    public FileObject findResource(String string) {
        for (ClassPath classPath : this.getPaths("classpath/source")) {
            FileObject fileObject = classPath.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    private synchronized void resetSourceRootsCache() {
        this.sourceRoots = null;
        for (SourceForBinaryQuery.Result result : this.results) {
            result.removeChangeListener(this.resultListener);
        }
        ++this.resetCount;
    }

    private class SFBQListener
    implements ChangeListener {
        private SFBQListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    }
}

