/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class SourceForBinaryQuery {
    private static final Logger LOG = Logger.getLogger(SourceForBinaryQuery.class.getName());
    private static final Lookup.Result<? extends SourceForBinaryQueryImplementation> implementations = Lookup.getDefault().lookupResult(SourceForBinaryQueryImplementation.class);
    private static final Result EMPTY_RESULT = new EmptyResult();

    private SourceForBinaryQuery() {
    }

    public static Result findSourceRoots(URL uRL) {
        if (FileUtil.isArchiveFile((URL)uRL)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + uRL);
        }
        if (!uRL.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("Folder URL must end with '/'. Was: " + uRL);
        }
        for (SourceForBinaryQueryImplementation sourceForBinaryQueryImplementation : implementations.allInstances()) {
            Result result = sourceForBinaryQueryImplementation.findSourceRoots(uRL);
            if (result == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findSourceRoots({0}) -> {1} from {2}", new Object[]{uRL, Arrays.asList(result.getRoots()), sourceForBinaryQueryImplementation});
            }
            return result;
        }
        LOG.log(Level.FINE, "findSourceRoots({0}) -> nil", uRL);
        return EMPTY_RESULT;
    }

    private static final class EmptyResult
    implements Result {
        private static final FileObject[] NO_ROOTS = new FileObject[0];

        EmptyResult() {
        }

        public FileObject[] getRoots() {
            return NO_ROOTS;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    public static interface Result {
        public FileObject[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

