/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.insane.impl.SmallObjectMap2;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ObjectMap;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public final class InsaneEngine {
    private Filter filter;
    private Visitor visitor;
    private ObjectMap objects;
    private boolean analyzeStaticData;
    private Set knownClasses = new HashSet();
    private Queue queue = new Queue();
    static final /* synthetic */ boolean $assertionsDisabled;

    public InsaneEngine(Filter filter, Visitor visitor, boolean bl) {
        this(new SmallObjectMap2(), filter, visitor, bl);
    }

    public InsaneEngine(ObjectMap objectMap, Filter filter, Visitor visitor, boolean bl) {
        this.objects = objectMap;
        this.filter = filter == null ? ScannerUtils.noFilter() : filter;
        this.visitor = visitor;
        this.analyzeStaticData = bl;
    }

    public void traverse(Collection collection) throws Exception {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.recognize(iterator.next());
        }
        while (!this.queue.isEmpty()) {
            this.process(this.queue.get());
        }
    }

    private void recognize(Object object) {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError((Object)"Recognize objects, not null");
        }
        if (object instanceof Class) {
            this.recognizeClass((Class)object);
        } else {
            this.recognizeObject(object);
        }
    }

    private void recognizeClass(Class clazz) {
        if (this.knownClasses.contains(clazz)) {
            return;
        }
        if (clazz.getName().startsWith("org.netbeans.insane.scanner")) {
            return;
        }
        if (!this.analyzeStaticData) {
            this.knownClasses.add(clazz);
            this.visitor.visitClass(clazz);
            return;
        }
        try {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                this.recognizeClass(clazz2);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                this.recognizeClass(classArray[i]);
            }
            this.knownClasses.add(clazz);
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                this.recognizeClass(fieldArray[i].getType());
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                this.recognizeClass(methodArray[i].getReturnType());
                Class<?>[] classArray2 = methodArray[i].getParameterTypes();
                for (int j = 0; j < classArray2.length; ++j) {
                    this.recognizeClass(classArray2[j]);
                }
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray3 = constructorArray[i].getParameterTypes();
                for (int j = 0; j < classArray3.length; ++j) {
                    this.recognizeClass(classArray3[j]);
                }
            }
        }
        catch (Error error) {
            System.err.println("Failed analysing class " + clazz.getName() + " because of " + error);
        }
        this.queue.add(clazz);
        this.visitor.visitClass(clazz);
    }

    private void recognizeObject(Object object) {
        if (this.objects.isKnown(object)) {
            return;
        }
        if (object.getClass().getName().startsWith("org.netbeans.insane.scanner")) {
            return;
        }
        if (!$assertionsDisabled && object.getClass().getName().startsWith("sun.reflect.")) {
            throw new AssertionError();
        }
        this.recognizeClass(object.getClass());
        this.objects.getID(object);
        this.queue.add(object);
        this.visitor.visitObject(this.objects, object);
    }

    private void process(Object object) throws Exception {
        if (object instanceof Class) {
            this.processClass((Class)object);
        } else {
            this.processObject(object);
        }
    }

    private void processClass(Class clazz) throws Exception {
        if (!this.analyzeStaticData) {
            return;
        }
        if (clazz.getName().startsWith("java.lang.reflect") || clazz.getName().equals("java.lang.Class")) {
            return;
        }
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            this.recognize(classLoader);
        }
        Field[] fieldArray = null;
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Failed analysing class " + clazz.getName() + " because of " + noClassDefFoundError);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Failed analysing class " + clazz.getName() + " because of " + throwable);
            return;
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object;
            Field field = fieldArray[i];
            if ((field.getModifiers() & 8) == 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            try {
                object = field.get(null);
            }
            catch (Throwable throwable) {
                System.err.println("Failed to read field " + field + " because of " + throwable);
                continue;
            }
            if (object == null || object.getClass().getName().startsWith("sun.reflect") || !this.filter.accept(object, null, field)) continue;
            this.recognize(object);
            if (!this.objects.isKnown(object)) continue;
            this.visitor.visitStaticReference(this.objects, object, field);
        }
    }

    private void processObject(Object object) throws Exception {
        if (!$assertionsDisabled && !this.objects.isKnown(object)) {
            throw new AssertionError((Object)"Objects in queue must be known");
        }
        Class<?> clazz = object.getClass();
        if (clazz.getName().startsWith("java.lang.reflect")) {
            return;
        }
        if (clazz.isArray() && !clazz.getComponentType().isPrimitive()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null || !this.filter.accept(object2, objectArray, null)) continue;
                this.recognize(object2);
                if (!this.objects.isKnown(object2)) continue;
                this.visitor.visitArrayReference(this.objects, object, object2, i);
            }
        } else {
            while (clazz != null) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    if ((field.getModifiers() & 8) != 0 || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    Object object3 = field.get(object);
                    if (object3 == null || !this.filter.accept(object3, object, field)) continue;
                    this.recognize(object3);
                    if (!this.objects.isKnown(object3)) continue;
                    this.visitor.visitObjectReference(this.objects, object, object3, field);
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    static {
        $assertionsDisabled = !InsaneEngine.class.desiredAssertionStatus();
    }

    private static class Queue
    extends ArrayList {
        private int offset = 0;

        public void put(Object object) {
            this.add(object);
        }

        public boolean isEmpty() {
            return this.offset >= this.size();
        }

        public Object get() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            Object e = this.get(this.offset++);
            if (this.offset > 1000) {
                this.removeRange(0, this.offset);
                this.offset = 0;
            }
            return e;
        }
    }
}

