/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.insane.model.HeapModel;
import org.netbeans.insane.model.Item;

class BinaryHeapModel
implements HeapModel {
    private Map createdObjects = new HashMap();
    private Map createdClasses = new HashMap();
    ByteBuffer buffer;
    int refsOffset;
    int objsOffset;

    public static HeapModel open(File file) throws Exception {
        BinaryHeapModel binaryHeapModel = new BinaryHeapModel(file);
        return binaryHeapModel;
    }

    BinaryHeapModel(File file) throws Exception {
        long l = file.length();
        this.buffer = new FileInputStream(file).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, l);
        System.err.println("magic=" + this.buffer.getInt(0));
        this.refsOffset = this.buffer.getInt(4);
        this.objsOffset = this.buffer.getInt(8);
        System.err.println("refs=" + this.refsOffset);
        System.err.println("objs=" + this.objsOffset);
    }

    public Iterator getAllItems() {
        ArrayList<HItem> arrayList = new ArrayList<HItem>();
        int n = this.objsOffset;
        while (n < this.buffer.limit()) {
            HItem hItem = (HItem)this.getItem(n);
            arrayList.add(hItem);
            n = hItem.getNextOffset();
        }
        return arrayList.iterator();
    }

    public Collection getObjectsOfType(String string) {
        Cls cls = this.getClsByName(string);
        return cls == null ? Collections.EMPTY_LIST : cls.getInstances();
    }

    public Collection getRoots() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.refsOffset;
        while (n < this.objsOffset) {
            RefType refType = new RefType(n);
            if (refType.isStatic()) {
                arrayList.add(refType.getReferenceName());
            }
            n = refType.getNextOffset();
        }
        return arrayList;
    }

    public Item getObjectAt(String string) {
        RefType refType = this.getRefTypeByName(string);
        return refType.getInstance();
    }

    public Item getItem(int n) {
        Integer n2 = new Integer(n);
        Item item = (Item)this.createdObjects.get(n2);
        if (item == null) {
            item = new HItem(n);
            this.createdObjects.put(n2, item);
        }
        return item;
    }

    private Cls getClsByName(String string) {
        int n = 12;
        while (n < this.refsOffset) {
            Cls cls = this.getCls(n);
            if (string.equals(cls.getClassName())) {
                return cls;
            }
            n = cls.getNextOffset();
        }
        return null;
    }

    private Cls getCls(int n) {
        Integer n2 = new Integer(n);
        Cls cls = (Cls)this.createdClasses.get(n2);
        if (cls == null) {
            cls = new Cls(n);
            this.createdClasses.put(n2, cls);
        }
        return cls;
    }

    private RefType getRefTypeByName(String string) {
        int n = this.refsOffset;
        while (n < this.objsOffset) {
            RefType refType = new RefType(n);
            if (string.equals(refType.getReferenceName())) {
                return refType;
            }
            n = refType.getNextOffset();
        }
        return null;
    }

    private class Cls {
        int offset;

        private Cls(int n) {
            this.offset = n;
        }

        public String getClassName() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int n = byteBuffer.getInt();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return new String(byArray);
        }

        public Collection getInstances() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            byteBuffer.position(byteBuffer.getInt() + byteBuffer.position());
            int n = byteBuffer.getInt();
            ArrayList<Item> arrayList = new ArrayList<Item>(n);
            while (--n >= 0) {
                arrayList.add(BinaryHeapModel.this.getItem(byteBuffer.getInt()));
            }
            return arrayList;
        }

        private int getNextOffset() {
            ByteBuffer byteBuffer = ((ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset)).slice();
            int n = byteBuffer.getInt();
            return this.offset + 4 + n + 4 + 4 * byteBuffer.getInt(4 + n);
        }
    }

    public class HItem
    implements Item {
        int offset;

        private HItem(int n) {
            this.offset = n;
        }

        private ByteBuffer prepareBuffer() {
            return ((ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset)).slice();
        }

        public String getType() {
            return BinaryHeapModel.this.getCls(this.prepareBuffer().getInt()).getClassName();
        }

        public int getSize() {
            return this.prepareBuffer().getInt(4);
        }

        public String getValue() {
            return "unknown";
        }

        public Enumeration incomming() {
            ByteBuffer byteBuffer = this.prepareBuffer();
            byteBuffer.position(8);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            byteBuffer.position(16 + 8 * n);
            Vector<Object> vector = new Vector<Object>(n2);
            while (--n2 >= 0) {
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                if (n4 != 0) {
                    vector.add(BinaryHeapModel.this.getItem(n4));
                    continue;
                }
                vector.add(new RefType(n3).getReferenceName());
            }
            return vector.elements();
        }

        public Enumeration outgoing() {
            ByteBuffer byteBuffer = this.prepareBuffer();
            int n = byteBuffer.getInt(8);
            byteBuffer.position(16);
            Vector<Item> vector = new Vector<Item>(n);
            while (--n >= 0) {
                int n2 = byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                vector.add(BinaryHeapModel.this.getItem(n3));
            }
            return vector.elements();
        }

        public String toString() {
            return this.getType() + "@" + Integer.toHexString(this.getId());
        }

        public int getId() {
            return this.offset;
        }

        private int getNextOffset() {
            ByteBuffer byteBuffer = this.prepareBuffer();
            return this.offset + 16 + 8 * byteBuffer.getInt(8) + 8 * byteBuffer.getInt(12);
        }
    }

    private class RefType {
        int offset;

        private RefType(int n) {
            this.offset = n;
        }

        public String getReferenceName() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int n = byteBuffer.getInt();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return new String(byArray);
        }

        public boolean isStatic() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            byteBuffer.position(byteBuffer.getInt() + byteBuffer.position());
            int n = byteBuffer.getInt();
            return n != -1;
        }

        public Item getInstance() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            byteBuffer.position(byteBuffer.getInt() + byteBuffer.position());
            int n = byteBuffer.getInt();
            if (n > 0) {
                return BinaryHeapModel.this.getItem(n);
            }
            return null;
        }

        private int getNextOffset() {
            ByteBuffer byteBuffer = (ByteBuffer)BinaryHeapModel.this.buffer.duplicate().position(this.offset);
            int n = byteBuffer.getInt();
            return this.offset + 4 + n + 4;
        }
    }
}

