/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.client;

import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public final class SuggestionPriority
implements Comparable {
    private final int priority;
    private static final String[] PRIORITIES_KEYS = new String[]{"PriorityHigh", "PriorityMediumHigh", "PriorityMedium", "PriorityMediumLow", "PriorityLow"};
    private static String[] PRIORITIES = new String[PRIORITIES_KEYS.length];
    public static final SuggestionPriority HIGH;
    public static final SuggestionPriority MEDIUM_HIGH;
    public static final SuggestionPriority MEDIUM;
    public static final SuggestionPriority MEDIUM_LOW;
    public static final SuggestionPriority LOW;

    private SuggestionPriority(int n) {
        this.priority = n;
    }

    public int intValue() {
        return this.priority;
    }

    public String toString() {
        switch (this.priority) {
            case 1: {
                return "high priority";
            }
            case 2: {
                return "medium-high priority";
            }
            case 3: {
                return "normal priority";
            }
            case 4: {
                return "medium-low priority";
            }
            case 5: {
                return "low priority";
            }
        }
        return "error";
    }

    public int compareTo(Object object) {
        return ((SuggestionPriority)object).priority - this.priority;
    }

    public static String[] getPriorityNames() {
        return PRIORITIES;
    }

    public static SuggestionPriority getPriority(int n) {
        switch (n) {
            case 1: {
                return HIGH;
            }
            case 2: {
                return MEDIUM_HIGH;
            }
            case 3: {
                return MEDIUM;
            }
            case 4: {
                return MEDIUM_LOW;
            }
            case 5: {
                return LOW;
            }
        }
        return MEDIUM;
    }

    static {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)SuggestionPriority.class);
        for (int i = 0; i < PRIORITIES_KEYS.length; ++i) {
            SuggestionPriority.PRIORITIES[i] = resourceBundle.getString(PRIORITIES_KEYS[i]);
        }
        HIGH = new SuggestionPriority(1);
        MEDIUM_HIGH = new SuggestionPriority(2);
        MEDIUM = new SuggestionPriority(3);
        MEDIUM_LOW = new SuggestionPriority(4);
        LOW = new SuggestionPriority(5);
    }
}

