/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.providers;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openide.ErrorManager;

final class XMLEncodingHelper {
    private static final int EXPECTED_PROLOG_LENGTH = 1000;

    XMLEncodingHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            ErrorManager.getDefault().log("XMLEncodingHelper got unmarkable stream: " + inputStream.getClass());
            return null;
        }
        try {
            String string;
            inputStream.mark(1000);
            byte[] byArray = new byte[1000];
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    int n = inputStream.read();
                    if (n == -1) break;
                    byArray[i] = (byte)n;
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            if ((string = XMLEncodingHelper.autoDetectEncoding(byArray)) == null) {
                String string2 = null;
                return string2;
            }
            if ((string = XMLEncodingHelper.detectDeclaredEncoding(byArray, string)) == null) {
                String string3 = null;
                return string3;
            }
            String string4 = string;
            return string4;
        }
        finally {
            inputStream.reset();
        }
    }

    static String autoDetectEncoding(byte[] byArray) throws IOException {
        if (byArray.length >= 4) {
            switch (byArray[0]) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return "UnicodeBigUnmarked";
                }
                case 60: {
                    switch (byArray[1]) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return "UnicodeLittleUnmarked";
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            return "UTF8";
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || byArray[2] != -89 || byArray[3] != -108) break;
                    return "Cp037";
                }
                case -2: {
                    if (byArray[1] != -1 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeBig";
                }
                case -1: {
                    if (byArray[1] != -2 || byArray[2] == 0 && byArray[3] == 0) break;
                    return "UnicodeLittle";
                }
                case -17: {
                    if (byArray[1] != -69 || byArray[2] != -65) break;
                    return "UTF8";
                }
            }
        }
        return null;
    }

    static String detectDeclaredEncoding(byte[] byArray, String string) throws IOException {
        int n;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\"';
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string);
        try {
            int n3 = ((Reader)inputStreamReader).read();
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = ((Reader)inputStreamReader).read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 = (n2 = (string2 = stringBuffer.toString()).indexOf("?>")) == -1 ? string2.length() : n2;
        int n4 = string2.indexOf("encoding");
        if (n4 == -1 || n4 > n2) {
            return null;
        }
        char[] cArray = string2.toCharArray();
        for (n = n4; n < n2 && cArray[n] != '='; ++n) {
        }
        while (n < n2) {
            if (cArray[n] == '\'' || cArray[n] == '\"') {
                c = cArray[n];
                break;
            }
            ++n;
        }
        int n5 = ++n;
        while (n < n2) {
            if (cArray[n] == c) {
                return new String(cArray, n5, n - n5);
            }
            ++n;
        }
        return null;
    }
}

