/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.updater.UpdateTracking;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

class Autoupdater {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.Autoupdater");
    private static Preferences proxySettingsNode;

    Autoupdater() {
    }

    static void restart() {
        LifecycleManager.getDefault().exit();
    }

    static void installUpdateChecker(final Runnable runnable) {
        if (Boolean.getBoolean("netbeans.full.hack") || Boolean.getBoolean("netbeans.close")) {
            return;
        }
        Settings.getShared().getIdeIdentity();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                Autoupdater.doInstallUpdateChecker(runnable);
            }
        });
    }

    private static void doInstallUpdateChecker(Runnable runnable) {
        RequestProcessor.getDefault().post(runnable, 5000);
    }

    private static synchronized Preferences getProxyPreferences() {
        if (proxySettingsNode == null) {
            proxySettingsNode = NbPreferences.root().node("/org/netbeans/core");
            assert (proxySettingsNode != null);
        }
        return proxySettingsNode;
    }

    static int getProxyType() {
        return Autoupdater.getProxyPreferences().getInt("proxyType", 1);
    }

    static String getUserProxyHost() {
        return Autoupdater.getProxyPreferences().get("proxyHttpHost", "");
    }

    static String getUserProxyPort() {
        return Autoupdater.getProxyPreferences().get("proxyHttpPort", "");
    }

    static void setProxyConfiguration(int n, String string, String string2) {
        Autoupdater.getProxyPreferences().putInt("proxyType", n);
        Autoupdater.getProxyPreferences().put("proxyHttpHost", string);
        Autoupdater.getProxyPreferences().put("proxyHttpPort", string2);
    }

    static class Support {
        private static final String FILE_SEPARATOR = System.getProperty("file.separator");
        private static final String UPDATE_DIR = "update";
        private static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
        private static final String PATCH_DIR = "lib" + FILE_SEPARATOR + "patches";
        private static final String KS_FILE = "core" + FILE_SEPARATOR + "ide.ks";
        public static final String LOG_FILE_NAME = "update.log";
        public static final String LATER_FILE_NAME = "install_later.xml";
        private static final String UPDATE_TEMP = "autoupdateTemp";
        private static FileObject tempDir = null;

        private Support() {
        }

        public static ModuleInfo[] getModuleDescriptions() {
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances();
            return collection.toArray(new ModuleInfo[collection.size()]);
        }

        public static File getDownloadDirectory(File file) {
            File file2;
            if (file == null) {
                file = new File(System.getProperty("netbeans.user"));
            }
            if (!(file2 = new File(file, DOWNLOAD_DIR)).isDirectory()) {
                file2.mkdirs();
            }
            return file2;
        }

        public static List getPatchDirectories() {
            ArrayList<File> arrayList = new ArrayList<File>();
            List list = UpdateTracking.clusters(true);
            assert (list != null) : "Clusters cannot be empty.";
            for (File file : list) {
                if (!file.isDirectory()) continue;
                arrayList.add(new File(file.getPath() + FILE_SEPARATOR + PATCH_DIR));
            }
            return arrayList;
        }

        static File getKSFile() {
            File file = InstalledFileLocator.getDefault().locate(KS_FILE, null, true);
            return file;
        }

        static File getInstall_Later(File file) {
            File file2 = new File(file.getPath() + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME);
            return file2;
        }

        static File getTempCopyFile(FileObject fileObject) {
            FileSystem fileSystem;
            File file = null;
            if (tempDir == null) {
                fileSystem = Repository.getDefault().getDefaultFileSystem();
                tempDir = fileSystem.getRoot().getFileObject(UPDATE_TEMP);
                try {
                    if (tempDir == null) {
                        tempDir = fileSystem.getRoot().createFolder(UPDATE_TEMP);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (tempDir != null) {
                try {
                    fileSystem = tempDir.getFileObject(fileObject.getName(), "nbm");
                    if (fileSystem == null) {
                        fileSystem = FileUtil.copyFile((FileObject)fileObject, (FileObject)tempDir, (String)fileObject.getName());
                    }
                    file = FileUtil.toFile((FileObject)fileSystem);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return file;
        }

        static void deleteTempDir() {
            if (tempDir == null) {
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                tempDir = fileSystem.getRoot().getFileObject(UPDATE_TEMP);
            }
            if (tempDir != null) {
                try {
                    tempDir.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

