/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PreparedModules {
    private static final String ELEMENT_MODULES = "module_updates";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private List modules = new ArrayList();
    private boolean pError = false;
    private static PreparedModules preparedModules;

    PreparedModules() {
    }

    static PreparedModules getPrepared() {
        if (preparedModules == null) {
            PreparedModules.readPrepared();
        }
        return preparedModules;
    }

    static void readPrepared() {
        preparedModules = new PreparedModules();
        preparedModules.read();
    }

    List getModules() {
        return this.modules;
    }

    void addModule(ModuleUpdate moduleUpdate) {
        Module module = new Module();
        module.setCodenamebase(moduleUpdate.getCodeNameBase());
        module.setName(moduleUpdate.getName());
        module.setSize(moduleUpdate.getDownloadSize());
        SpecificationVersion specificationVersion = moduleUpdate.getRemoteModule().getSpecificationVersion();
        module.setSpec_version(specificationVersion == null ? null : specificationVersion.toString());
        module.setNbm_name(moduleUpdate.getDistributionFilename());
        if (moduleUpdate.isToInstallDir()) {
            module.setCluster(moduleUpdate.findInstallDirectory());
        } else {
            module.setCluster(new File(System.getProperty("netbeans.user")));
        }
        this.modules.add(module);
    }

    void removeModule(String string) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module module = (Module)this.modules.get(i);
            if (!module.getCodenamebase().equals(string)) continue;
            this.modules.remove(i);
            return;
        }
    }

    String getPreparedVersion(String string) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module module = (Module)this.modules.get(i);
            if (!module.getCodenamebase().equals(string)) continue;
            return module.getSpec_version();
        }
        return null;
    }

    boolean hasNBM(String string) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module module = (Module)this.modules.get(i);
            if (!module.getNbm_name().equals(string)) continue;
            return true;
        }
        return false;
    }

    void delete() {
        List list = UpdateTracking.clusters(true);
        assert (list != null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.getInstall_Later((File)iterator.next()).delete();
        }
    }

    private File getInstall_Later(File file) {
        return Autoupdater.Support.getInstall_Later(file);
    }

    void write() {
        List list = UpdateTracking.clusters(true);
        assert (list != null) : "Clusters cannot be empty.";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.writeToCluster((File)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCluster(File file) {
        Object object;
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULES, null, null, null);
        Element element = document.getDocumentElement();
        Element element2 = null;
        Iterator iterator = this.modules.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            object = (Module)iterator.next();
            if (!file.equals(((Module)object).getCluster())) continue;
            element2 = document.createElement(ELEMENT_MODULE);
            element2.setAttribute(ATTR_CODENAMEBASE, ((Module)object).getCodenamebase());
            element2.setAttribute(ATTR_NAME, ((Module)object).getName());
            element2.setAttribute(ATTR_SPEC_VERSION, ((Module)object).getSpec_version());
            element2.setAttribute(ATTR_SIZE, Long.toString(((Module)object).getSize()));
            element2.setAttribute(ATTR_NBM_NAME, ((Module)object).getNbm_name());
            element.appendChild(element2);
            bl = false;
        }
        if (bl) {
            return;
        }
        document.getDocumentElement().normalize();
        object = Autoupdater.Support.getInstall_Later(file);
        ((File)object).getParentFile().mkdirs();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)object);
            XMLUtil.write((Document)document, (OutputStream)fileOutputStream, (String)"UTF-8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private void read() {
        this.modules.clear();
        Document document = null;
        try {
            List list = UpdateTracking.clusters(true);
            assert (list != null) : "Clusters cannot be empty.";
            for (File file : list) {
                File file2 = Autoupdater.Support.getInstall_Later(file);
                if (!file2.exists()) continue;
                FileInputStream fileInputStream = new FileInputStream(file2);
                InputSource inputSource = new InputSource(fileInputStream);
                document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                assert (document != null);
                Element element = document.getDocumentElement();
                if (element == null || !element.getTagName().equals(ELEMENT_MODULES)) continue;
                this.scanElement_module_updates(element, file);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Bad install_later");
            sAXException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Missing install_later");
            iOException.printStackTrace();
            return;
        }
    }

    private void scanElement_module_updates(Element element, File file) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ELEMENT_MODULE)) continue;
            this.scanElement_module(element2, file);
        }
    }

    private void scanElement_module(Element element, File file) {
        Module module = new Module();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getName().equals(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SPEC_VERSION)) {
                module.setSpec_version(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NAME)) {
                module.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SIZE)) {
                try {
                    module.setSize(Long.parseLong(attr.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    module.setSize(0L);
                }
            }
            if (attr.getName().equals(ATTR_NBM_NAME)) {
                module.setNbm_name(attr.getValue());
            }
            module.setCluster(file);
        }
        this.modules.add(module);
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            PreparedModules.this.pError = true;
        }
    }

    class Module {
        private String name;
        private String codenamebase;
        private String spec_version;
        private long size;
        private String nbm_name;
        private File cluster;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getCodenamebase() {
            return this.codenamebase;
        }

        public void setCodenamebase(String string) {
            this.codenamebase = string;
        }

        public String getSpec_version() {
            return this.spec_version;
        }

        public void setSpec_version(String string) {
            this.spec_version = string;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }

        public String getNbm_name() {
            return this.nbm_name;
        }

        public void setNbm_name(String string) {
            this.nbm_name = string;
        }

        public void setCluster(File file) {
            this.cluster = file;
        }

        public File getCluster() {
            return this.cluster;
        }
    }
}

