/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ResultsPanel;
import org.openide.util.NbBundle;

class ResultListCellRenderer
extends JPanel
implements ListCellRenderer {
    static final long serialVersionUID = -3181200208271061471L;
    private static final String SPACE = " ";
    private static final String BAD_DOWNLOAD = " " + ResultListCellRenderer.getBundle("CTL_BAD_DOWNLOAD") + " ";
    private static final String CORRUPTED = " " + ResultListCellRenderer.getBundle("CTL_CORRUPTED") + " ";
    private static final String NOT_SIGNED = " " + ResultListCellRenderer.getBundle("CTL_NOT_SIGNED") + " ";
    private static final String SIGNED = " " + ResultListCellRenderer.getBundle("CTL_SIGNED") + " ";
    private static final String TRUSTED = " " + ResultListCellRenderer.getBundle("CTL_TRUSTED") + " ";
    private static ResultListCellRenderer renderer = null;
    private JCheckBox globalCheckBox;
    private JCheckBox includeCheckBox;
    private JLabel nameLabel;
    private JLabel securityLabel;

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (renderer == null) {
            renderer = new ResultListCellRenderer();
        }
        ResultListCellRenderer.renderer.includeCheckBox.setSelected(((ModuleUpdate)object).isInstallApproved());
        ResultListCellRenderer.renderer.globalCheckBox.setSelected(((ModuleUpdate)object).isToInstallDir());
        String string = "";
        switch (((ModuleUpdate)object).getSecurity()) {
            case 0: {
                string = BAD_DOWNLOAD;
                break;
            }
            case 1: {
                string = CORRUPTED;
                break;
            }
            case 2: {
                string = NOT_SIGNED;
                break;
            }
            case 3: {
                StringBuffer stringBuffer = new StringBuffer(SIGNED);
                stringBuffer.append(SPACE + ResultListCellRenderer.getBundle("CTL_By"));
                Collection collection = ((ModuleUpdate)object).getCerts();
                for (Certificate certificate : collection) {
                    if (!(certificate instanceof X509Certificate)) continue;
                    stringBuffer.append(SPACE).append(((X509Certificate)certificate).getSubjectDN().getName());
                }
                string = stringBuffer.toString();
                break;
            }
            case 4: {
                string = TRUSTED;
            }
        }
        ResultListCellRenderer.renderer.nameLabel.setText(((ModuleUpdate)object).getName() + "  " + ResultListCellRenderer.getBundle("CTL_Version") + ((ModuleUpdate)object).getRemoteModule().getSpecificationVersion());
        ResultListCellRenderer.renderer.securityLabel.setText(string);
        ResultListCellRenderer.renderer.includeCheckBox.getAccessibleContext().setAccessibleDescription(ResultListCellRenderer.renderer.nameLabel.getText());
        ResultListCellRenderer.renderer.includeCheckBox.setMnemonic(ResultListCellRenderer.getBundle("ACS_Include_Mnem").charAt(0));
        ResultListCellRenderer.renderer.globalCheckBox.getAccessibleContext().setAccessibleDescription(ResultListCellRenderer.getBundle("ACS_Global1") + ResultListCellRenderer.renderer.nameLabel.getText() + ResultListCellRenderer.getBundle("ACS_Global2"));
        ResultListCellRenderer.renderer.globalCheckBox.setMnemonic(ResultListCellRenderer.getBundle("ACS_Global_Mnem").charAt(0));
        if (bl) {
            renderer.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.nameLabel.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.securityLabel.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.includeCheckBox.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.includeCheckBox.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.globalCheckBox.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.globalCheckBox.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
        } else {
            renderer.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.nameLabel.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.securityLabel.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.includeCheckBox.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.includeCheckBox.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.globalCheckBox.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.globalCheckBox.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
        }
        renderer.invalidate();
        return renderer;
    }

    public ResultListCellRenderer() {
        this.initComponents();
        this.nameLabel.setFont(ResultsPanel.doDeriveFont(this.nameLabel.getFont(), 1));
    }

    private void initComponents() {
        this.includeCheckBox = new JCheckBox();
        this.nameLabel = new JLabel();
        this.securityLabel = new JLabel();
        this.globalCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.includeCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.securityLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.globalCheckBox, gridBagConstraints);
    }

    boolean isIncludeCheckBoxSelected(MouseEvent mouseEvent) {
        return this.includeCheckBox.getX() + this.includeCheckBox.getWidth() >= mouseEvent.getX() && this.includeCheckBox.getX() <= mouseEvent.getX();
    }

    boolean isGlobalCheckBoxSelected(MouseEvent mouseEvent) {
        return this.globalCheckBox.getX() + this.globalCheckBox.getWidth() >= mouseEvent.getX() && this.globalCheckBox.getX() <= mouseEvent.getX();
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(ResultListCellRenderer.class, (String)string);
    }
}

