/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Settings {
    private static final Settings INSTANCE = new Settings();
    private static final String PROP_ASK_BEFORE = "askBefore";
    private static final String PROP_NEGATIVE_RESULTS = "negativeResults";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheck";
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_ACCEPTED_NOTIFICATIONS = "acceptedNotifications";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;
    public static final String NODE_DEFAULT_ACTION = "nodeDefaultAction";
    private static final Random RANDOM = new Random();
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");
    private String tempIdeIdentity = null;
    private Map notifications;
    private PropertyChangeSupport ps;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Settings.class);
    }

    public static Settings getShared() {
        if (Settings.INSTANCE.ps == null) {
            Settings.INSTANCE.ps = new PropertyChangeSupport(INSTANCE);
        }
        return INSTANCE;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.ps.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.ps.removePropertyChangeListener(propertyChangeListener);
    }

    public int getPeriod() {
        return Settings.getPreferences().getInt(PROP_PERIOD, 2);
    }

    public void setPeriod(int n) {
        Settings.getPreferences().putInt(PROP_PERIOD, n);
    }

    protected AutoupdateType defaultAutoupdateType() {
        return AutoupdateType.getDefault();
    }

    public void setIdeIdentity(String string) {
        Settings.getPreferences().put(PROP_IDE_IDENTITY, string);
    }

    public String getIdeIdentity() {
        if (this.tempIdeIdentity instanceof String) {
            return this.tempIdeIdentity;
        }
        String string = Settings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String string2 = null;
        string2 = string == null ? Settings.modifyIdeIdentityIfNeeded(Integer.toString(Settings.generateNewId())) : Settings.modifyIdeIdentityIfNeeded(string);
        this.tempIdeIdentity = string2;
        if (!string2.equals(string)) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + string2);
            Settings.getPreferences().put(PROP_IDE_IDENTITY, string2);
        }
        return this.tempIdeIdentity;
    }

    public void setAcceptedNotifications(Map map) {
        this.notifications = map;
        Settings.storeAcceptedNotifications(map);
    }

    public Map getAcceptedNotifications() {
        if (this.notifications == null) {
            this.notifications = Settings.initAcceptedNotifications();
        }
        return this.notifications;
    }

    private static Map initAcceptedNotifications() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        String string = Settings.getPreferences().get(PROP_ACCEPTED_NOTIFICATIONS, null);
        if (string != null) {
            String[] stringArray = string.split("|");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String[] stringArray2 = string2.split(",");
                assert (stringArray2.length == 2);
                hashMap.put(Integer.valueOf(stringArray2[0]), Integer.valueOf(stringArray2[1]));
            }
        }
        return hashMap;
    }

    private static void storeAcceptedNotifications(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            stringBuffer.append(entry.getKey()).append(",").append(entry.getValue());
            if (!object.hasNext()) continue;
            stringBuffer.append("|");
        }
        object = stringBuffer.toString();
        if (((String)object).length() > 0) {
            Settings.getPreferences().put(PROP_ACCEPTED_NOTIFICATIONS, (String)object);
        }
    }

    public boolean isAskBefore() {
        return Settings.getPreferences().getBoolean(PROP_ASK_BEFORE, false);
    }

    public void setAskBefore(boolean bl) {
        Settings.getPreferences().putBoolean(PROP_ASK_BEFORE, bl);
    }

    public boolean isNegativeResults() {
        return Settings.getPreferences().getBoolean(PROP_NEGATIVE_RESULTS, false);
    }

    public void setNegativeResults(boolean bl) {
        Settings.getPreferences().putBoolean(PROP_NEGATIVE_RESULTS, bl);
    }

    public Date getLastCheck() {
        long l = Settings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return l > 0L ? new Date(l) : null;
    }

    public void setLastCheck(Date date) {
        if (date != null) {
            Settings.getPreferences().putLong(PROP_LAST_CHECK, date.getTime());
        } else {
            Settings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    public void fireNodeDefaultAction() {
        this.ps.firePropertyChange(NODE_DEFAULT_ACTION, null, null);
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(Settings.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String string) {
        String string2;
        String string3;
        String string4;
        block10: {
            String[] stringArray = string.split("\\d");
            string4 = null;
            string3 = null;
            if (stringArray.length == 0) {
                string4 = string;
                string3 = "";
            } else {
                assert (stringArray.length == 1) : "ideIdentityArr cannot be greater then 1!";
                string3 = stringArray[0];
                string4 = string.substring(string3.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + string3);
            err.log(Level.FINER, "Old IDE Identity ID: " + string4);
            string2 = "";
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                if (fileObject == null) break block10;
                InputStream inputStream = fileObject.getInputStream();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    string2 = bufferedReader.readLine().trim();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!string2.equals(string3)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + string2);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        return string2 + string4;
    }

    private static int generateNewId() {
        int n = RANDOM.nextInt();
        if (n < 0) {
            n = -(n + 1);
        }
        return n;
    }

    public static class LastCheckPropertyEditor
    extends PropertyEditorSupport {
        private static final SimpleDateFormat sdf = new SimpleDateFormat();

        public String getAsText() {
            Date date = (Date)this.getValue();
            return date == null ? "" : sdf.format(date);
        }

        public void setAsText(String string) {
            try {
                Date date = sdf.parse(string);
                this.setValue(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static class PeriodPropertyEditor
    extends PropertyEditorSupport {
        private static final String[] tags = new String[]{Settings.access$000("CTL_PeriodEditor_Startup"), Settings.access$000("CTL_PeriodEditor_Day"), Settings.access$000("CTL_PeriodEditor_Week"), Settings.access$000("CTL_PeriodEditor_2Weeks"), Settings.access$000("CTL_PeriodEditor_Month"), Settings.access$000("CTL_PeriodEditor_Never")};
        private static final int[] values = new int[]{0, 1, 2, 3, 4, 5};

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            long l = ((Integer)this.getValue()).intValue();
            for (int i = 0; i < values.length; ++i) {
                if ((long)values[i] != l) continue;
                return tags[i];
            }
            return Settings.getBundle("CTL_PeriodEditor_Unsupported");
        }

        public void setAsText(String string) {
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != string) continue;
                this.setValue(new Integer(values[i]));
                return;
            }
            this.setValue(new Integer(0));
        }
    }
}

