/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.FinishDialog;
import org.netbeans.modules.autoupdate.FirstPanel;
import org.netbeans.modules.autoupdate.LoginPanel;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Notification;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.ResultsPanel;
import org.netbeans.modules.autoupdate.SafeModule;
import org.netbeans.modules.autoupdate.SelectModulesPanel;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.UpdatePanel;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.netbeans.updater.UpdaterFrame;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Wizard
implements WizardDescriptor.Iterator {
    private Updates updates;
    private static HashMap allUpdates = new HashMap();
    private static int errorType = 0;
    private static String errorMessage;
    private static RequestProcessor processor;
    private static final Logger LOG;
    private WizardPanel[][] panels = new WizardPanel[][]{{new StartPanel(), new PropPanel(), null, new ConfigPanel(), new DownloadPanel(), new LastPanel()}, {null, null, new SelectPanel(), null, null, null}};
    private int current = 0;
    private int modulesOK = 0;
    private boolean canceled = false;
    private int wizardType = 0;
    private WizardDescriptor wizardDescriptor;
    private List auTypesWithCust = new ArrayList();
    private HashMap installNow = new HashMap();
    private PropertyChangeListener updater_listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("FINISHED")) {
                Wizard.this.updaterFinished();
            }
        }
    };

    Wizard() {
        this(null);
    }

    Wizard(HashMap hashMap) {
        this(hashMap, 0);
    }

    private void updaterFinished() {
        if (SafeModule.write(this.installNow)) {
            final String string = Wizard.getBundle("MSG_Install_Finished");
            StatusDisplayer.getDefault().setStatusText(string);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (string.equals(StatusDisplayer.getDefault().getStatusText())) {
                        StatusDisplayer.getDefault().setStatusText("");
                    }
                }
            }, 5000);
        } else {
            this.finishDialog(true);
        }
    }

    private void finishDialog(boolean bl) {
        if (FinishDialog.showDialog()) {
            Collection collection = Wizard.getAllModules();
            for (ModuleUpdate moduleUpdate : collection) {
                if (!moduleUpdate.isInstallApproved() || !moduleUpdate.isDownloadOK() || !bl && moduleUpdate.isSafeToInstall()) continue;
                if (!moduleUpdate.isSafeToInstall() && moduleUpdate.isToInstallDir() && !Downloader.tryMove(moduleUpdate)) {
                    try {
                        moduleUpdate.setToInstallDir(false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOG.log(Level.WARNING, null, illegalArgumentException);
                    }
                }
                PreparedModules.getPrepared().addModule(moduleUpdate);
            }
            if (FinishDialog.isRestart()) {
                PreparedModules.getPrepared().delete();
                Autoupdater.restart();
            } else {
                PreparedModules.getPrepared().write();
            }
        } else {
            Downloader.deleteDownload();
        }
    }

    Wizard(HashMap hashMap, int n) {
        this.wizardType = n;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("value") && ((object = propertyChangeEvent.getNewValue()) == WizardDescriptor.FINISH_OPTION || object == NotifyDescriptor.CANCEL_OPTION || object == NotifyDescriptor.CLOSED_OPTION)) {
                    if (object != WizardDescriptor.FINISH_OPTION) {
                        Wizard.this.canceled = true;
                        Downloader.deleteDownload();
                    }
                    Wizard.this.getCurrent().end(true);
                    Autoupdater.Support.deleteTempDir();
                    allUpdates.clear();
                }
            }
        };
        Updates.reset();
        if (hashMap != null) {
            int n2 = 3;
            allUpdates = hashMap;
            this.current = n2;
            if (n == 0) {
                this.panels[0][n2].start(true);
            }
        }
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
        this.wizardDescriptor.setModal(false);
        this.wizardDescriptor.setTitle(Wizard.getBundle("CTL_Wizard"));
        this.wizardDescriptor.setTitleFormat(new MessageFormat(" {0}"));
        this.wizardDescriptor.setAdditionalOptions(new Object[0]);
        this.wizardDescriptor.addPropertyChangeListener(propertyChangeListener);
        this.wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        this.wizardDescriptor.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, WizardDescriptor.FINISH_OPTION, NotifyDescriptor.CANCEL_OPTION});
    }

    static void go(HashMap hashMap) {
        Wizard.go(hashMap, 0);
    }

    static Wizard go(HashMap hashMap, int n) {
        Wizard wizard = new Wizard(hashMap, n);
        wizard.startDialog();
        return wizard;
    }

    void refreshUpdatePanel() {
        if (this.current == 3) {
            this.panels[0][this.current].start(true);
        }
    }

    public static void go() {
        new Wizard().startDialog();
    }

    private void startDialog() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.canceled = false;
        dialog.setVisible(true);
        dialog.toFront();
    }

    public String name() {
        return this.getCurrent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrent();
    }

    private WizardPanel getCurrent() {
        return this.panels[this.wizardType][this.current] == null ? this.panels[0][this.current] : this.panels[this.wizardType][this.current];
    }

    public boolean hasNext() {
        if (this.current == 1 && this.getCurrent().nextPanelOffset() == -1) {
            return false;
        }
        return this.current < this.panels[this.wizardType].length - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        this.getCurrent().end(true);
        this.current = this.current < 0 && this.wizardType == 0 ? (this.current += 2) : (this.current == 0 && this.wizardType == 1 ? 2 : (this.current == 0 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? 3 : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() == 0 ? (this.current += 2) : (this.current == 1 && this.wizardType == 0 && this.auTypesWithCust.size() > 0 ? 1 : (this.current == 3 && this.getCurrent().nextPanelOffset() == 2 ? 5 : ++this.current)))));
        this.getCurrent().start(true);
    }

    public void previousPanel() {
        this.getCurrent().end(false);
        switch (this.current) {
            case 2: {
                if (this.wizardType == 1) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 3: {
                if (this.wizardType == 0) {
                    this.current = 0;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                this.current = 3;
                break;
            }
            default: {
                --this.current;
            }
        }
        this.getCurrent().start(false);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
    }

    static HashMap getAllUpdates() {
        return allUpdates;
    }

    static void setAllUpdates(HashMap hashMap) {
        allUpdates = hashMap;
    }

    static Collection getAllModules() {
        HashSet hashSet = new HashSet();
        Iterator iterator = Wizard.getAllUpdates().values().iterator();
        while (iterator.hasNext()) {
            Collection collection = ((Updates)iterator.next()).getModules();
            if (collection == null) continue;
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    static RequestProcessor getRequestProcessor() {
        if (processor == null) {
            processor = new RequestProcessor();
        }
        return processor;
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(Wizard.class, (String)string);
    }

    static void resetErrorStore() {
        errorMessage = null;
        errorType = 0;
    }

    private static void storeError(int n, String string) {
        if (n == 0) {
            throw new IllegalArgumentException("Type Updates.NO_ERROR is not error.");
        }
        errorType = n;
        errorMessage = string;
    }

    static boolean isErrorStored() {
        return errorType != 0;
    }

    static int getStoredErrorType() {
        return errorType;
    }

    static String getStoredErrorMessage() {
        return errorMessage;
    }

    static int checkConnect(Updates updates, AutoupdateType autoupdateType) {
        if (ConnectingDialog.isCanceled()) {
            return 1;
        }
        if (ConnectingDialog.isSkipped()) {
            return 2;
        }
        if (updates.isError()) {
            Wizard.storeError(updates.getError(), updates.getErrorMessage());
            return 2;
        }
        if (updates.getModules() != null && updates.getModules().size() > 0) {
            Notification.performNotification(updates, autoupdateType);
        }
        return 0;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.autoupdate.Wizard");
    }

    class ConfigPanel
    extends WizardPanel {
        private UpdatePanel updatePanel;

        ConfigPanel() {
            this.updatePanel = null;
        }

        String getName() {
            return Wizard.getBundle("CTL_ConfigPanel");
        }

        public Component getComponent() {
            if (this.updatePanel == null) {
                this.updatePanel = new UpdatePanel(this){

                    public Dimension getPreferredSize() {
                        return ConfigPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.updatePanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public boolean isValid() {
            return this.valid;
        }

        void start(boolean bl) {
            this.valid = false;
            if (bl) {
                PreparedModules.readPrepared();
                if (Wizard.this.wizardType == 0) {
                    for (AutoupdateType autoupdateType : allUpdates.keySet()) {
                        Updates updates = (Updates)allUpdates.get((Object)autoupdateType);
                        autoupdateType.setLastTimeStamp(updates.getTimeStamp());
                    }
                }
            }
            ((UpdatePanel)this.getComponent()).setUpdates(Wizard.this.wizardType);
        }

        void end(boolean bl) {
            if (bl) {
                ((UpdatePanel)this.getComponent()).markSelectedModules();
                if (!Wizard.this.canceled && !((UpdatePanel)this.getComponent()).checkLicencies()) {
                    Wizard.this.current--;
                }
            }
            ((UpdatePanel)this.getComponent()).removeListeners();
        }

        int nextPanelOffset() {
            if (((UpdatePanel)this.getComponent()).modulesToDownload() == 0) {
                return 2;
            }
            return 1;
        }

        void setUpdates(HashMap hashMap) {
            allUpdates.clear();
            allUpdates = hashMap;
        }
    }

    class DownloadPanel
    extends WizardPanel {
        private Downloader downloader;
        private SignVerifier signVerifier;
        private DownloadProgressPanel progressPanel;
        private boolean isDownloadFinished;

        DownloadPanel() {
            this.progressPanel = null;
        }

        String getName() {
            return Wizard.getBundle(Wizard.this.wizardType == 0 ? "CTL_DownloadPanel" : "CTL_CopyPanel");
        }

        public Component getComponent() {
            if (this.progressPanel == null) {
                this.progressPanel = new DownloadProgressPanel(this){

                    public Dimension getPreferredSize() {
                        return DownloadPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.progressPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean bl) {
            this.valid = false;
            this.isDownloadFinished = false;
            this.progressPanel = null;
            this.downloader = new Downloader((DownloadProgressPanel)this.getComponent(), this, Wizard.this.wizardType == 0);
            this.downloader.doDownload();
        }

        void end(boolean bl) {
            if (!this.valid) {
                if (!this.isDownloadFinished) {
                    this.downloader.cancelDownload();
                } else if (this.signVerifier != null) {
                    this.signVerifier.cancelVerify(Wizard.this.canceled);
                }
            }
        }
    }

    class LastPanel
    extends WizardPanel {
        ResultsPanel resultsPanel;

        LastPanel() {
        }

        String getName() {
            return Wizard.getBundle(Wizard.this.wizardType == 0 ? "CTL_ResultsPanel" : "CTL_ResultsPanel_1");
        }

        public Component getComponent() {
            if (this.resultsPanel == null) {
                this.resultsPanel = new ResultsPanel(this){

                    public Dimension getPreferredSize() {
                        return LastPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.resultsPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean bl) {
            Wizard.this.modulesOK = ((ResultsPanel)this.getComponent()).generateResults();
        }

        void end(boolean bl) {
            if (Wizard.this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION && Wizard.this.modulesOK > 0) {
                File[] fileArray;
                Collection collection = Wizard.getAllModules();
                Iterator iterator = collection.iterator();
                Wizard.this.installNow = new HashMap();
                int n = 0;
                while (iterator.hasNext()) {
                    fileArray = (File[])iterator.next();
                    if (!fileArray.isDownloadOK() || !Downloader.getNBM((ModuleUpdate)fileArray).exists()) continue;
                    if (!fileArray.isInstallApproved()) {
                        Downloader.getNBM((ModuleUpdate)fileArray).delete();
                        Downloader.getNBM((ModuleUpdate)fileArray).deleteOnExit();
                        continue;
                    }
                    if (fileArray.isSafeToInstall()) {
                        if (fileArray.isToInstallDir() && !Downloader.tryMove((ModuleUpdate)fileArray)) {
                            try {
                                fileArray.setToInstallDir(false);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                LOG.log(Level.WARNING, null, illegalArgumentException);
                            }
                        }
                        Wizard.this.installNow.put(fileArray, Downloader.getMovedNBM((ModuleUpdate)fileArray));
                        continue;
                    }
                    ++n;
                }
                Autoupdater.Support.deleteTempDir();
                Wizard.this.modulesOK = 0;
                if (Wizard.this.installNow.size() > 0 && n == 0) {
                    fileArray = new File[]{};
                    fileArray = Wizard.this.installNow.values().toArray(fileArray);
                    UpdaterFrame.runFromIDE(fileArray, Wizard.this.updater_listener, NbBundle.getBranding());
                } else if (n > 0) {
                    Wizard.this.finishDialog(false);
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Wizard.getBundle("MSG_WizardNoNbms"), 2));
                }
            }
        }
    }

    class PropPanel
    extends WizardPanel {
        LoginPanel lPanel;
        AutoupdateType currentAT;
        JPanel custPanel;
        HelpCtx userHelp;

        PropPanel() {
            this.userHelp = null;
        }

        String getName() {
            return Wizard.getBundle("CTL_StartPanel");
        }

        public void setValid(boolean bl) {
        }

        public Component getComponent() {
            if (this.lPanel == null) {
                this.lPanel = new LoginPanel(this){

                    public Dimension getPreferredSize() {
                        return PropPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.lPanel;
        }

        public HelpCtx getHelp() {
            if (this.userHelp != null) {
                return this.userHelp;
            }
            return null;
        }

        void start(boolean bl) {
            if (this.custPanel != null) {
                return;
            }
            this.currentAT = (AutoupdateType)((Object)Wizard.this.auTypesWithCust.get(0));
            this.userHelp = null;
            try {
                this.custPanel = (JPanel)Introspector.getBeanInfo(((Object)((Object)this.currentAT)).getClass()).getBeanDescriptor().getCustomizerClass().newInstance();
                ((LoginPanel)this.getComponent()).setCustomizer(this.custPanel, this.currentAT);
                this.userHelp = (HelpCtx)this.custPanel.getClientProperty("Autoupdate_HelpID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void end(boolean bl) {
            if (Wizard.this.wizardType == 0) {
                Downloader.deleteDownload();
                if (!Wizard.this.canceled && bl) {
                    Wizard.this.updates = this.currentAT.connectForUpdates();
                    Wizard.this.updates.checkUpdates((Validator)this, this.currentAT);
                    int n = Wizard.checkConnect(Wizard.this.updates, this.currentAT);
                    if (n == 0) {
                        allUpdates.put(this.currentAT, Wizard.this.updates);
                    } else if (n == 1) {
                        if (Wizard.this.updates.isError()) {
                            Wizard.this.current = -1;
                            return;
                        }
                        Wizard.this.current = -2;
                    }
                }
                Wizard.this.auTypesWithCust.remove(0);
                this.custPanel = null;
            }
        }
    }

    class SelectPanel
    extends WizardPanel {
        private SelectModulesPanel selectModulesPanel;

        SelectPanel() {
            this.selectModulesPanel = null;
        }

        String getName() {
            return Wizard.getBundle("CTL_SelectModulesPanel");
        }

        public Component getComponent() {
            if (this.selectModulesPanel == null) {
                this.selectModulesPanel = new SelectModulesPanel(this){

                    public Dimension getPreferredSize() {
                        return SelectPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.selectModulesPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void start(boolean bl) {
            this.valid = false;
            if (bl) {
                ((SelectModulesPanel)this.getComponent()).reset();
            } else {
                this.setValid(true);
            }
        }

        void end(boolean bl) {
            if (bl && !Wizard.this.canceled) {
                Wizard.this.updates = new XMLUpdates(((SelectModulesPanel)this.getComponent()).getFiles());
                ((XMLUpdates)Wizard.this.updates).checkDownloadedModules();
                allUpdates.put(this, Wizard.this.updates);
            }
        }
    }

    class StartPanel
    extends WizardPanel {
        FirstPanel firstPanel;

        StartPanel() {
        }

        String getName() {
            return Wizard.getBundle("CTL_StartPanel");
        }

        public void setValid(boolean bl) {
            Wizard.this.wizardType = ((FirstPanel)this.getComponent()).getWizardType();
        }

        public Component getComponent() {
            if (this.firstPanel == null) {
                this.firstPanel = new FirstPanel(this){

                    public Dimension getPreferredSize() {
                        return StartPanel.this.WIZARD_SIZE;
                    }
                };
            }
            return this.firstPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        void end(boolean bl) {
            allUpdates.clear();
            Wizard.this.auTypesWithCust.clear();
            Wizard.resetErrorStore();
            Downloader.deleteDownload();
            if (Wizard.this.wizardType == 0 && !Wizard.this.canceled) {
                int n = 0;
                Enumeration enumeration = AutoupdateType.autoupdateTypes();
                while (enumeration.hasMoreElements()) {
                    AutoupdateType autoupdateType = (AutoupdateType)((Object)enumeration.nextElement());
                    boolean bl2 = false;
                    if (!autoupdateType.isEnabled()) continue;
                    try {
                        if (Introspector.getBeanInfo(((Object)((Object)autoupdateType)).getClass()).getBeanDescriptor().getCustomizerClass() != null) {
                            Wizard.this.auTypesWithCust.add(autoupdateType);
                            ++n;
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl2) continue;
                    Wizard.this.updates = autoupdateType.connectForUpdates();
                    Wizard.this.updates.checkUpdates((Validator)this, autoupdateType);
                    int n2 = Wizard.checkConnect(Wizard.this.updates, autoupdateType);
                    if (n2 == 0) {
                        ++n;
                        allUpdates.put(autoupdateType, Wizard.this.updates);
                        continue;
                    }
                    if (n2 != 1) continue;
                    Wizard.this.current = -2;
                    return;
                }
                if (n == 0) {
                    if (Wizard.isErrorStored()) {
                        ConnectingErrorDialog.showDialog(errorType, errorMessage);
                    } else {
                        ConnectingErrorDialog.showDialog(3, null);
                    }
                    Wizard.this.current = -2;
                    return;
                }
            }
        }
    }

    static interface Validator {
        public void setValid(boolean var1);
    }

    abstract class WizardPanel
    implements WizardDescriptor.Panel,
    Validator {
        protected Dimension WIZARD_SIZE = new Dimension(550, 400);
        protected boolean valid = true;
        private EventListenerList listenerList = new EventListenerList();

        WizardPanel() {
        }

        void start(boolean bl) {
        }

        void end(boolean bl) {
        }

        int nextPanelOffset() {
            return 1;
        }

        abstract String getName();

        public void setValid(boolean bl) {
            this.valid = bl;
            this.fireChangeListenerStateChanged(this);
        }

        public boolean isValid() {
            return this.valid;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public abstract Component getComponent();

        public void readSettings(Object object) {
        }

        public void storeSettings(Object object) {
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }

        protected void fireChangeListenerStateChanged(Object object) {
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(object);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }
    }
}

