/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLAutoupdateType
extends AutoupdateType {
    static final String PROP_URL_SPEC = "urlSpec";
    static final String PROP_URL = "URL";
    private String urlSpec;
    private URL url;
    private String defaultURL;
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    public static final String UPDATE_VERSION = "1.18";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    private static final String TIME_STAMP_ATTRIBUTE_NAME = "timestamp";
    private static final String TIME_STAMP_FORMAT = "ss/mm/hh/dd/MM/yyyy";
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");
    static final long serialVersionUID = 362844553432169452L;
    private String displayName = null;
    private FileObject typeFileObject = null;
    private String url_key;
    private String localizingBundleName;
    private boolean valid = true;

    public XMLAutoupdateType() {
        this.urlSpec = this.getDefaultURL();
    }

    public XMLAutoupdateType(URL uRL) {
        this.urlSpec = uRL.toExternalForm();
    }

    public XMLAutoupdateType(URL uRL, String string, String string2, Boolean bl) {
        this(uRL, string, null, string2, bl);
    }

    public XMLAutoupdateType(URL uRL, String string, FileObject fileObject, String string2, Boolean bl) {
        this(uRL, string, fileObject, string2, bl, null);
    }

    public XMLAutoupdateType(URL uRL, String string, FileObject fileObject, String string2, Boolean bl, String string3) {
        this.typeFileObject = fileObject;
        this.urlSpec = uRL.toExternalForm();
        this.displayName = string;
        this.url_key = string2;
        this.localizingBundleName = string3;
        if (bl != null) {
            this.setEnabled(bl);
        }
    }

    public static XMLAutoupdateType createXMLAutoupdateType(FileObject fileObject) throws IOException {
        URL uRL;
        Object object;
        String string = (String)fileObject.getAttribute("url_key");
        String string2 = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
        ResourceBundle resourceBundle = XMLAutoupdateType.getBundleFromName(string2);
        if (string != null) {
            try {
                object = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                object = "http://";
            }
            uRL = new URL((String)object);
        } else {
            object = fileObject.getAttribute("url");
            uRL = object instanceof String ? new URL((String)object) : (URL)object;
        }
        object = (Boolean)fileObject.getAttribute("enabled");
        return new XMLAutoupdateType(uRL, null, fileObject, string, (Boolean)object, string2);
    }

    public String displayName() {
        if (this.displayName == null) {
            if (this.typeFileObject != null) {
                try {
                    FileSystem fileSystem = this.typeFileObject.getFileSystem();
                    FileSystem.Status status = fileSystem.getStatus();
                    String string = status.annotateName("", Collections.singleton(this.typeFileObject));
                    if (!string.equals("")) {
                        this.displayName = string;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.displayName == null) {
                this.displayName = NbBundle.getBundle(Settings.class).getString("CTL_XMLAutoupdateType_Name");
            }
        }
        return this.displayName;
    }

    public String getUrlSpec() {
        return this.urlSpec;
    }

    public void setUrlSpec(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            class UserIllegalException
            extends IllegalArgumentException
            implements Callable {
                public UserIllegalException(String string) {
                    super(string);
                }

                public Object call() throws Exception {
                    LogRecord logRecord = new LogRecord(OwnLevel.USER, this.getMessage());
                    return new LogRecord[]{logRecord};
                }
            }
            UserIllegalException userIllegalException = new UserIllegalException(malformedURLException.getMessage());
            String string2 = MessageFormat.format(NbBundle.getMessage(XMLAutoupdateType.class, (String)"FMT_EXC_BAD_URL"), string);
            Exceptions.attachLocalizedMessage((Throwable)userIllegalException, (String)string2);
            throw userIllegalException;
        }
        String string3 = this.urlSpec;
        this.urlSpec = string;
        this.firePropertyChange(PROP_URL_SPEC, string3, this.urlSpec);
    }

    public URL getURL() {
        URL uRL;
        block2: {
            uRL = null;
            try {
                uRL = new URL(this.getUrlSpec());
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return uRL;
    }

    public void setURL(URL uRL) {
        if (uRL != null) {
            this.setUrlSpec(uRL.toExternalForm());
        } else {
            this.setUrlSpec(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLAutoupdateType.class);
    }

    public Updates connectForUpdates() {
        URL uRL;
        block2: {
            uRL = null;
            try {
                uRL = new URL(this.getUrlSpec());
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return new XMLUpdates(this.modifyURL(uRL));
    }

    protected URL modifyURL(URL uRL) {
        URL uRL2 = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String string = "";
            try {
                string = Settings.getShared().getIdeIdentity();
            }
            catch (NullPointerException nullPointerException) {
                Logger.getAnonymousLogger().warning("Property PROP_IDE_IDENTITY hasn't been initialized yet.");
            }
            String string2 = NbBundle.getBundle(XMLAutoupdateType.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(string) ? string2 + "0" : string2 + string);
        }
        try {
            uRL2 = new URL(this.encode(this.replace(uRL.toString())));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return uRL2;
    }

    protected String replace(String string) {
        XMLAutoupdateType.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf("{", n2)) != -1 && n2 < string.length() - 1) {
            if (string.charAt(n2 + 1) == '{' || string.charAt(n2 + 1) != '$') {
                ++n2;
                continue;
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf("}", n2);
            if (n3 != -1) {
                String string2 = string.substring(n2 + 2, n3);
                stringBuffer.append(this.getReplacement(string2));
            }
            n = n3 == -1 ? n2 + 2 : n3 + 1;
            ++n2;
        }
        if (n < string.length() - 1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    boolean isValid() {
        return this.valid;
    }

    protected String getReplacement(String string) {
        return System.getProperty(string, "");
    }

    protected String encode(String string) {
        String string2 = string;
        int n = string.indexOf(63);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    int n2 = string3.indexOf(61);
                    if (n2 < 0) {
                        stringBuffer.append(URLEncoder.encode(string3, "UTF-8"));
                    } else {
                        stringBuffer.append(URLEncoder.encode(string3.substring(0, n2), "UTF-8"));
                        stringBuffer.append('=');
                        String string4 = string3.substring(n2 + 1);
                        int n3 = string4.indexOf("%");
                        if (n3 < 0) {
                            stringBuffer.append(URLEncoder.encode(string4, "UTF-8"));
                        } else {
                            stringBuffer.append(URLEncoder.encode(string4.substring(0, n3), "UTF-8"));
                            stringBuffer.append('%');
                            stringBuffer.append(URLEncoder.encode(string4.substring(n3 + 1), "UTF-8"));
                        }
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    err.log(Level.INFO, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append('&');
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean hasNewContent() {
        InputStream inputStream = null;
        Date date = null;
        try {
            int n;
            URL uRL = this.modifyURL(new URL(this.getUrlSpec()));
            err.log(Level.FINER, "Found Update Center " + this.getName() + "[" + uRL + "]");
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer(1024);
            while ((n = inputStream.read()) != -1 && stringBuffer.length() < 1024) {
                stringBuffer.append((char)n);
            }
            err.log(Level.FINER, "Successfully checked " + uRL);
            String string = stringBuffer.toString();
            String string2 = null;
            int n2 = string.indexOf(TIME_STAMP_ATTRIBUTE_NAME);
            if (n2 != -1 && (n2 = (string = string.substring(n2 + TIME_STAMP_ATTRIBUTE_NAME.length() + 1 + 1)).indexOf(62)) != -1) {
                string2 = string.substring(0, n2 - 1);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT);
            date = simpleDateFormat.parse(string2);
            err.log(Level.FINER, "Successfully read time " + date);
            err.log(Level.FINER, "Last Time Stamp on " + this.getName() + " is " + this.getLastTimeStamp());
        }
        catch (MalformedURLException malformedURLException) {
            err.log(Level.FINE, null, malformedURLException);
        }
        catch (IOException iOException) {
            err.log(Level.FINE, null, iOException);
        }
        catch (ParseException parseException) {
            err.log(Level.FINE, null, parseException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    err.log(Level.FINE, null, iOException);
                }
            }
        }
        if (this.getLastTimeStamp() == null) {
            return Boolean.TRUE;
        }
        return date == null ? null : (date.after(this.getLastTimeStamp()) ? Boolean.TRUE : Boolean.FALSE);
    }

    private static ResourceBundle getOldLocalizingBundle() {
        return NbBundle.getBundle(XMLAutoupdateType.class);
    }

    private static ResourceBundle getBundleFromName(String string) throws MissingResourceException {
        ResourceBundle resourceBundle = null;
        resourceBundle = string == null ? XMLAutoupdateType.getOldLocalizingBundle() : NbBundle.getBundle((String)string);
        return resourceBundle;
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    protected String getDefaultURL() {
        if (this.defaultURL == null) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = XMLAutoupdateType.getBundleFromName(this.localizingBundleName);
                this.defaultURL = this.url_key != null ? resourceBundle.getString(this.url_key) : resourceBundle.getString("URL_Default_N");
            }
            catch (MissingResourceException missingResourceException) {
                this.valid = false;
                return null;
            }
        }
        return this.defaultURL;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.urlSpec.equals(this.getDefaultURL())) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(this.urlSpec);
        }
        objectOutputStream.writeObject(this.displayName);
        objectOutputStream.writeObject(this.url_key);
        objectOutputStream.writeObject(this.localizingBundleName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            String string;
            String string2;
            String string3;
            this.valid = true;
            Object object = objectInputStream.readObject();
            if (object != null) {
                if (object instanceof URL) {
                    this.urlSpec = ((URL)object).toExternalForm();
                } else {
                    assert (object instanceof String);
                    this.urlSpec = (String)object;
                }
            }
            if ((string3 = (String)objectInputStream.readObject()) != null) {
                this.displayName = string3;
            }
            if ((string2 = (String)objectInputStream.readObject()) != null) {
                this.url_key = string2;
            }
            if ((string = (String)objectInputStream.readObject()) != null) {
                this.localizingBundleName = string;
            }
        }
        catch (OptionalDataException optionalDataException) {
            if (optionalDataException.eof) {
                this.setEnabled(true);
            }
            throw optionalDataException;
        }
        if (this.urlSpec == null) {
            this.urlSpec = this.getDefaultURL();
        }
        if (!this.isValid()) {
            this.setEnabled(false);
            this.displayName = NbBundle.getMessage(XMLAutoupdateType.class, (String)"XMLAutoupdateType_InvalidSetting", (Object)this.displayName);
        }
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);

        private OwnLevel(String string, int n) {
            super(string, n);
        }
    }
}

