/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class ModuleNodeActions {

    public static class EnableAllAction
    extends NodeAction {
        protected void performAction(Node[] nodeArray) {
            assert (nodeArray != null) : "Cannot performAction when activatedNodes is null";
            ModuleBean.AllModulesBean.getDefault().pause();
            for (ModuleBean moduleBean : ModuleBean.AllModulesBean.getDefault().getModules()) {
                if (moduleBean.isEnabled() || !ModuleNodeUtils.isEnableAllowed(moduleBean.getModule())) continue;
                moduleBean.setEnabled(true);
            }
            ModuleBean.AllModulesBean.getDefault().resume();
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length > 0;
        }

        public String getName() {
            return NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableAllAction");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    public static class EnableDisableAction
    extends NodeAction {
        private String name;

        protected void performAction(Node[] nodeArray) {
            assert (nodeArray != null) : "Cannot performAction when activatedNodes is null";
            Boolean bl = ModuleNodeUtils.isEnableCandidate(nodeArray);
            assert (bl != null) : "Cannot performAction if mixed statuses on activatedNodes " + Arrays.asList(nodeArray);
            ModuleBean.AllModulesBean.getDefault().pause();
            Set<ModuleBean> set = ModuleNodeUtils.getAllSelectedModuleBeans(nodeArray);
            for (ModuleBean moduleBean : set) {
                moduleBean.setEnabled(bl);
            }
            ModuleBean.AllModulesBean.getDefault().resume();
        }

        protected boolean enable(Node[] nodeArray) {
            if (nodeArray == null) {
                return false;
            }
            Set<ModuleNode.Item> set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
            boolean bl = !set.isEmpty();
            String string = "";
            for (ModuleNode.Item item : set) {
                Module module = item.getItem().getModule();
                string = module.getDisplayName();
                if (ModuleNodeUtils.isEnableAllowed(module)) continue;
                bl = false;
                break;
            }
            Boolean bl2 = ModuleNodeUtils.isEnableCandidate(nodeArray);
            this.name = nodeArray.length == 1 && !(nodeArray[0] instanceof ModuleNode.Item) ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_format", (Object)(bl2 == null || bl2 != false ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_enable") : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_disable")), (Object)nodeArray[0].getDisplayName()) : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_format", (Object)(bl2 == null || bl2 != false ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_enable") : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_disable")), (Object)(set.size() > 1 ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_EnableDisableAction_many") : string));
            return bl && ModuleNodeUtils.isEnableCandidate(nodeArray) != null;
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    public static class SortAction
    extends NodeAction
    implements Presenter.Popup {
        JMenu subMenu;
        JRadioButtonMenuItem sortByCategory;
        JRadioButtonMenuItem sortByName;
        JRadioButtonMenuItem sortByCluster;

        protected void performAction(Node[] nodeArray) {
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortAction");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public JMenuItem getPopupPresenter() {
            return this.getSubmenuPopupPresenter();
        }

        public JMenuItem getSubmenuPopupPresenter() {
            if (this.subMenu == null) {
                this.subMenu = new JMenu();
                Mnemonics.setLocalizedText((AbstractButton)this.subMenu, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortAction"));
                this.sortByCategory = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByCategory, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByCategory"));
                this.sortByCategory.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByCategory);
                this.sortByName = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByName, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByName"));
                this.sortByName.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByName);
                this.sortByCluster = new JRadioButtonMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)this.sortByCluster, (String)NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_SortByCluster"));
                this.sortByCluster.addActionListener(new MenuListener());
                this.subMenu.add(this.sortByCluster);
            }
            this.sortByCategory.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_CATEGORY);
            this.sortByName.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_DISPLAY_NAME);
            this.sortByCluster.setSelected(ModuleNode.getModuleSortMode() == ModuleNode.SortMode.BY_CLUSTER);
            return this.subMenu;
        }

        private class MenuListener
        implements ActionListener {
            private MenuListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                if (SortAction.this.sortByCategory.equals(jMenuItem)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_CATEGORY);
                } else if (SortAction.this.sortByName.equals(jMenuItem)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_DISPLAY_NAME);
                } else if (SortAction.this.sortByCluster.equals(jMenuItem)) {
                    ModuleNode.setModuleSortMode(ModuleNode.SortMode.BY_CLUSTER);
                } else assert (false) : "Invalid source " + jMenuItem + " in actionPerformed()";
            }
        }
    }

    public static class UninstallAction
    extends NodeAction {
        private String name;

        protected void performAction(Node[] nodeArray) {
            ModuleNodeUtils.doUninstall(nodeArray);
        }

        protected boolean enable(Node[] nodeArray) {
            this.name = ModuleNodeUtils.getUninstallActionName(nodeArray, this.name);
            return ModuleNodeUtils.canUninstall(nodeArray);
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }
}

