/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel;
import org.netbeans.modules.autoupdate.catalog.ModuleUninstallPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleNodeUtils {
    private ModuleNodeUtils() {
    }

    private static Set<ModuleNode.Item> getCategoryModules(Node node) {
        assert (!node.isLeaf()) : "Parent " + node + " cannot be leaf.";
        HashSet<ModuleNode.Item> hashSet = new HashSet<ModuleNode.Item>();
        for (Node node2 : node.getChildren().getNodes(true)) {
            if (!(node2 instanceof ModuleNode.Item)) continue;
            hashSet.add((ModuleNode.Item)node2);
        }
        return hashSet;
    }

    static Set<ModuleNode.Item> getAllSelectedModuleItems(Node[] nodeArray) {
        HashSet<ModuleNode.Item> hashSet = new HashSet<ModuleNode.Item>();
        for (Node node : nodeArray) {
            if (node instanceof ModuleNode.Item) {
                hashSet.add((ModuleNode.Item)node);
                continue;
            }
            if (node.isLeaf()) continue;
            hashSet.addAll(ModuleNodeUtils.getCategoryModules(node));
        }
        return hashSet;
    }

    static Set<ModuleBean> getAllSelectedModuleBeans(Node[] nodeArray) {
        HashSet<ModuleBean> hashSet = new HashSet<ModuleBean>();
        for (Node node : nodeArray) {
            if (node instanceof ModuleNode.Item) {
                hashSet.add(((ModuleNode.Item)node).getItem());
                continue;
            }
            if (node.isLeaf()) continue;
            hashSet.addAll(ModuleNodeUtils.getAllSelectedModuleBeans(node.getChildren().getNodes(true)));
        }
        return hashSet;
    }

    static Boolean isEnableCandidate(Node[] nodeArray) {
        Boolean bl = null;
        for (ModuleBean moduleBean : ModuleNodeUtils.getAllSelectedModuleBeans(nodeArray)) {
            if (bl == null) {
                bl = !moduleBean.isEnabled();
                continue;
            }
            if (bl.booleanValue() != moduleBean.isEnabled()) continue;
            return null;
        }
        return bl;
    }

    static boolean isEnableAllowed(Module module) {
        if (!module.isValid()) {
            return false;
        }
        return module.getProblems().isEmpty() && !module.isAutoload() && !module.isEager() && module.getJarFile() != null;
    }

    static String getUninstallActionName(Node[] nodeArray, String string) {
        Set<ModuleNode.Item> set;
        if (nodeArray == null || nodeArray.length == 0) {
            return string;
        }
        String string2 = nodeArray.length == 1 && !(nodeArray[0] instanceof ModuleNode.Item) ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)nodeArray[0].getDisplayName()) : NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)((set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray)).size() > 1 ? NbBundle.getMessage(ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction_many") : set.iterator().next().getDisplayName()));
        return string2;
    }

    static boolean isUninstallAllowed(Module module) {
        return !module.isAutoload() && !module.isEager() && !module.isFixed();
    }

    static boolean canUninstall(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        Set<ModuleNode.Item> set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
        if (set.isEmpty()) {
            return false;
        }
        for (ModuleNode.Item item : set) {
            if (item.canDestroy()) continue;
            return false;
        }
        return true;
    }

    static void doUninstall(final Node[] nodeArray) {
        if (ModuleNodeUtils.confirmUninstall(nodeArray)) {
            ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ModuleNodeUtils.uninstallNodes(nodeArray);
                }
            });
        }
    }

    static boolean confirmUninstall(Node[] nodeArray) {
        ModuleNode.Item item2;
        assert (nodeArray != null) : "Any ModuleNode must be selected";
        Set<ModuleNode.Item> set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
        assert (!set.isEmpty()) : "Any module must be selected";
        String string = null;
        if (nodeArray.length == 1 && !(nodeArray[0] instanceof ModuleNode.Item)) {
            string = nodeArray[0].getDisplayName();
        }
        HashSet<Module> hashSet = new HashSet<Module>(set.size());
        for (ModuleNode.Item item2 : set) {
            hashSet.add(item2.getItem().getModule());
        }
        ModuleUninstallPanel moduleUninstallPanel = new ModuleUninstallPanel(hashSet, string);
        ((Component)moduleUninstallPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ModuleSelectionPanel.class, (String)"ACD_ModuleUninstallPanel_form"));
        item2 = new NotifyDescriptor.Confirmation((Object)moduleUninstallPanel, NbBundle.getMessage(ModuleSelectionPanel.class, (String)"CTL_ModuleUninstallPanel_UninstallConfirmation"), 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)item2));
    }

    private static void uninstallNodes(Node[] nodeArray) {
        assert (nodeArray != null) : "uninstallNodes cannot be called on null nodes.";
        for (Node node : nodeArray) {
            if (node.isLeaf()) {
                ((ModuleNode.Item)node).uninstall();
                continue;
            }
            ModuleNodeUtils.uninstallNodes(node.getChildren().getNodes(true));
        }
    }
}

