/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.CharConversionException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.netbeans.modules.autoupdate.catalog.ModuleUpdaterProgress;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

public class ModuleSelectionPanel
extends JPanel
implements PropertyChangeListener {
    private TreeTableView treeTableView;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel");
    private static final int DEF_TREE_WIDTH = 420;
    private static final int DEF_0_COL_WIDTH = 60;
    private static final int DEF_1_COL_WIDTH = 150;
    private static final int DEF_HEIGHT = 350;
    private static ModuleDeleter deleter;
    private Cursor cursor = null;
    private static ModuleSelectionPanel panel;
    private boolean isWaiting = false;
    private Dialog d = null;
    private ChangeListener statusTextListener = null;
    private JEditorPane description;
    private JLabel descriptionLabel;
    private JScrollPane descriptionPane;
    private JLabel modulesLabel;
    private JPanel modulesPane;
    private JButton uninstallButton;
    private ExplorerManager manager;

    public static ModuleSelectionPanel getGUI(boolean bl) {
        assert (bl || panel != null);
        if (panel == null && bl) {
            panel = new ModuleSelectionPanel();
        }
        return panel;
    }

    private ModuleSelectionPanel() {
        this.initComponents();
        this.treeTableView = new TreeTableView();
        this.treeTableView.setRootVisible(false);
        ExplorerPanel explorerPanel = new ExplorerPanel();
        explorerPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ModuleSelectionPanel.class).getString("ACN_ModuleSelectionPanel_ExplorerPanel"));
        explorerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ModuleSelectionPanel.class).getString("ACD_ModuleSelectionPanel_ExplorerPanel"));
        explorerPanel.setLayout(new BorderLayout());
        explorerPanel.add((Component)this.treeTableView, "Center");
        this.modulesPane.add((Component)((Object)explorerPanel), "Center");
        this.manager = explorerPanel.getExplorerManager();
        Font font = UIManager.getFont("controlFont");
        Integer n = (Integer)UIManager.get("nbDefaultFontSize");
        if (n == null) {
            n = new Integer(11);
        }
        if (font == null) {
            font = this.getFont();
        }
        Node.Property[] propertyArray = new Node.Property[]{new PropertySupport.ReadWrite("enabled", Boolean.TYPE, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled")){

            public Object getValue() {
                return null;
            }

            public void setValue(Object object) {
            }
        }, new PropertySupport.ReadOnly("specificationVersion", String.class, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_specversion")){

            public Object getValue() {
                return null;
            }
        }};
        this.treeTableView.setProperties(propertyArray);
        if (font.getSize() > n) {
            this.sizeTTVCarefully();
        } else {
            this.treeTableView.setPreferredSize(new Dimension(630, 350));
            this.treeTableView.setTreePreferredWidth(420);
            this.treeTableView.setTableColumnPreferredWidth(0, 60);
            this.treeTableView.setTableColumnPreferredWidth(1, 150);
        }
        this.treeTableView.setPopupAllowed(true);
        this.treeTableView.setDefaultActionAllowed(false);
        this.treeTableView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.treeTableView.setVerticalScrollBarPolicy(20);
        this.initAccessibility();
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)new WarmupJob());
        this.setWaitingState(true, false);
    }

    public void setWaitingState(boolean bl, final boolean bl2) {
        if (this.isWaiting == bl) {
            return;
        }
        this.isWaiting = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModuleSelectionPanel.this.doSetWaitingState(ModuleSelectionPanel.this.isWaiting, bl2);
            }
        });
    }

    private void doSetWaitingState(boolean bl, boolean bl2) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.isVisible()) {
            return;
        }
        err.log(Level.FINE, "Set waiting state on ModuleSelectionPanel to (wait:" + bl + ", showProgress: " + bl2 + ")");
        this.uninstallButton.setEnabled(!bl);
        if (bl) {
            if (this.cursor == null) {
                this.cursor = this.getCursor();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (bl2 && this.d == null) {
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)"modules-update");
                ModuleUpdaterProgress moduleUpdaterProgress = new ModuleUpdaterProgress(progressHandle);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)moduleUpdaterProgress, NbBundle.getMessage(ModuleUpdaterProgress.class, (String)"CTL_ModuleUpdaterProgress_Title"), true, new Object[0], null, 0, null, null, true);
                this.statusTextListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        progressHandle.progress(StatusDisplayer.getDefault().getStatusText());
                    }
                };
                StatusDisplayer.getDefault().addChangeListener(this.statusTextListener);
                this.d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                progressHandle.start();
                this.d.setVisible(true);
            }
        } else {
            if (this.cursor != null) {
                this.setCursor(this.cursor);
                this.cursor = null;
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.d != null && this.d.isVisible()) {
                this.d.setVisible(false);
                this.d.dispose();
                this.d = null;
                this.requestFocus();
            }
            if (this.statusTextListener != null) {
                StatusDisplayer.getDefault().removeChangeListener(this.statusTextListener);
            }
        }
    }

    public boolean isWaitingState() {
        return this.isWaiting;
    }

    private void prepareComponents() {
        block4: {
            Node[] nodeArray;
            Object object;
            this.uninstallButton.setEnabled(false);
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            if (styleSheet.getStyleSheets() == null) {
                object = new StyleSheet();
                nodeArray = this.treeTableView.getFont();
                int n = this.treeTableView.getFont().getSize();
                ((StyleSheet)object).addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(nodeArray.getName()).append("; }").toString());
                ((StyleSheet)object).addStyleSheet(styleSheet);
                hTMLEditorKit.setStyleSheet((StyleSheet)object);
            }
            this.description.setEditorKit(hTMLEditorKit);
            object = new ModuleNode();
            this.manager.setRootContext((Node)object);
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            nodeArray = object.getChildren().getNodes(true);
            if (nodeArray.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)propertyVetoException);
                }
            }
        }
    }

    private void sizeTTVCarefully() {
        Font font = (Font)UIManager.getDefaults().get("TableHeader.font");
        Font font2 = (Font)UIManager.getDefaults().get("Table.font");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = Math.max(60, fontMetrics.stringWidth(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled")) + 20);
        int n2 = Math.max(150, fontMetrics.stringWidth(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion")) + 20);
        int n3 = UIManager.getDefaults().getInt("nbDefaultFontSize");
        int n4 = 420 + 10 * (font2.getSize() - n3);
        this.treeTableView.setPreferredSize(new Dimension(n4 + n + n2, 350 + 10 * (font2.getSize() - n3)));
        this.treeTableView.setTreePreferredWidth(n4);
        this.treeTableView.setTableColumnPreferredWidth(0, n);
        this.treeTableView.setTableColumnPreferredWidth(1, n2);
    }

    private void initComponents() {
        this.modulesLabel = new JLabel();
        this.uninstallButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.description = new JEditorPane();
        this.modulesPane = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setName(NbBundle.getMessage(ModuleSelectionPanel.class, (String)"LBL_ModuleSelectionPanel_Name"));
        this.modulesLabel.setLabelFor(this.modulesPane);
        Mnemonics.setLocalizedText((JLabel)this.modulesLabel, (String)NbBundle.getBundle(ModuleSelectionPanel.class).getString("ModuleSelectionPanel_ModuleLabel_text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(7, 11, 0, 0);
        this.add((Component)this.modulesLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.uninstallButton, (String)NbBundle.getMessage(ModuleSelectionPanel.class, (String)"BTN_ModuleSelectionPanel_Uninstall"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleSelectionPanel.this.uninstallButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 8, 0, 12);
        this.add((Component)this.uninstallButton, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionPane);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(ModuleSelectionPanel.class, (String)"LBL_ModuleSelectionPanel_descriptionLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(8, 11, 0, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionPane.setMinimumSize(new Dimension(400, 70));
        this.descriptionPane.setPreferredSize(new Dimension(400, 70));
        this.description.setEditable(false);
        this.descriptionPane.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(2, 11, 0, 0);
        this.add((Component)this.descriptionPane, gridBagConstraints);
        this.modulesPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.85;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(2, 11, 0, 0);
        this.add((Component)this.modulesPane, gridBagConstraints);
    }

    private void uninstallButtonActionPerformed(ActionEvent actionEvent) {
        ModuleNodeUtils.doUninstall(this.manager.getSelectedNodes());
    }

    private void prevButtonActionPerformed(ActionEvent actionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block5: {
            ModuleBean moduleBean;
            block6: {
                if (propertyChangeEvent.getSource() != this.manager) break block5;
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) break block6;
                if (!"nodeChange".equals(propertyChangeEvent.getPropertyName())) break block5;
            }
            final Node[] nodeArray = this.manager.getSelectedNodes();
            String string = "";
            if (nodeArray.length == 1 && (moduleBean = (ModuleBean)nodeArray[0].getLookup().lookup(ModuleBean.class)) != null) {
                try {
                    string = "<b>" + XMLUtil.toElementContent((String)moduleBean.getModule().getDisplayName()) + "</b>";
                    String string2 = moduleBean.getLongDescription();
                    if (string2 != null) {
                        string = string + "<br>" + XMLUtil.toElementContent((String)string2);
                    }
                }
                catch (CharConversionException charConversionException) {
                    err.log(Level.WARNING, null, charConversionException);
                }
            }
            this.description.setText(string);
            this.description.setCaretPosition(0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleSelectionPanel.this.treeTableView.requestFocus();
                    ModuleSelectionPanel.this.uninstallButton.setEnabled(!ModuleSelectionPanel.this.isWaitingState() && ModuleNodeUtils.canUninstall(nodeArray));
                }
            });
        }
    }

    public void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ModuleSelectionPanel"));
    }

    static {
        panel = null;
    }

    private static class ExplorerPanel
    extends TopComponent
    implements ExplorerManager.Provider {
        private ExplorerManager mgr = new ExplorerManager();

        public ExplorerPanel() {
            ActionMap actionMap = this.getActionMap();
            actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.mgr, (boolean)false));
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.mgr, (ActionMap)actionMap));
        }

        public ExplorerManager getExplorerManager() {
            return this.mgr;
        }

        protected void componentActivated() {
            ExplorerUtils.activateActions((ExplorerManager)this.mgr, (boolean)true);
        }

        protected void componentDeactivated() {
            ExplorerUtils.activateActions((ExplorerManager)this.mgr, (boolean)false);
        }
    }

    private class WarmupJob
    implements AsyncGUIJob {
        private WarmupJob() {
        }

        public void construct() {
            ModuleSelectionPanel.this.prepareComponents();
        }

        public void finished() {
            ModuleSelectionPanel.this.setWaitingState(false, false);
            ModuleSelectionPanel.this.treeTableView.requestFocus();
        }
    }
}

