/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.CharConversionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.Module;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class ModulesAndDescription
extends JPanel {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.catalog.ModulesAndDescription");
    private JEditorPane description;
    private JLabel descriptionLabel;
    private JScrollPane descriptionPane;
    private JList moduleList;
    private JLabel moduleListLabel;
    private JScrollPane modulesArea;

    public ModulesAndDescription(Module[] moduleArray, String string) {
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.moduleListLabel, (String)string);
        this.moduleList.setListData(moduleArray);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        if (styleSheet.getStyleSheets() == null) {
            StyleSheet styleSheet2 = new StyleSheet();
            Font font = this.moduleList.getFont();
            int n = this.moduleList.getFont().getSize();
            styleSheet2.addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet2.addStyleSheet(styleSheet);
            hTMLEditorKit.setStyleSheet(styleSheet2);
        }
        this.description.setEditorKit(hTMLEditorKit);
        if (moduleArray.length > 0) {
            this.moduleList.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.modulesArea = new JScrollPane();
        this.moduleList = new JList();
        this.moduleListLabel = new JLabel();
        this.descriptionPane = new JScrollPane();
        this.description = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.moduleList.setSelectionMode(0);
        this.moduleList.setCellRenderer(new ModuleCellRenderer());
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ModulesAndDescription.this.moduleListValueChanged(listSelectionEvent);
            }
        });
        this.modulesArea.setViewportView(this.moduleList);
        this.moduleList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ModulesAndDescription.class, (String)"ACN_ModulesAndDescription_moduleList"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ModulesAndDescription.class, (String)"ACD_ModulesAndDescription_moduleList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        this.add((Component)this.modulesArea, gridBagConstraints);
        this.moduleListLabel.setLabelFor(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.moduleListLabel, gridBagConstraints);
        this.descriptionPane.setMinimumSize(new Dimension(400, 80));
        this.descriptionPane.setPreferredSize(new Dimension(400, 80));
        this.description.setEditable(false);
        this.descriptionPane.setViewportView(this.description);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ModulesAndDescription.class, (String)"ACN_ModulesAndiDescription_description"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ModulesAndDescription.class, (String)"ACD_ModulesAndiDescription_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.descriptionPane, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(ModulesAndDescription.class, (String)"LBL_ModulesAndDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 2, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
    }

    private void moduleListValueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        Module module = (Module)jList.getSelectedValue();
        if (module != null) {
            String string;
            try {
                string = "<b>" + XMLUtil.toElementContent((String)module.getDisplayName()) + "</b>";
                String string2 = (String)module.getLocalizedAttribute("OpenIDE-Module-Long-Description");
                if (string2 != null) {
                    string = string + "<br>" + XMLUtil.toElementContent((String)string2);
                }
            }
            catch (CharConversionException charConversionException) {
                LOG.log(Level.WARNING, null, charConversionException);
                return;
            }
            this.description.setText(string);
            this.description.setCaretPosition(0);
        } else {
            this.description.setText(null);
        }
    }

    private static final class ModuleCellRenderer
    extends DefaultListCellRenderer {
        ModuleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, ((Module)object).getDisplayName(), n, bl, bl2);
        }
    }
}

