/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.modules.editor.hints.ParseErrorAnnotation;
import org.netbeans.modules.editor.hints.StaticFixList;
import org.netbeans.modules.editor.hints.borrowed.ListCompletionView;
import org.netbeans.modules.editor.hints.borrowed.ScrollCompletionPane;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class HintsUI
implements MouseListener,
KeyListener,
ChangeListener,
AWTEventListener {
    private static HintsUI INSTANCE;
    private static final String POPUP_NAME = "hintsPopup";
    static Logger UI_GESTURES_LOGGER;
    private JTextComponent comp;
    private LazyFixList hints = new StaticFixList();
    private Popup listPopup;
    private JLabel hintIcon;
    private ScrollCompletionPane hintListComponent;
    private JLabel errorTooltip;
    private PopupFactory pf = null;
    private ChangeInfo changes;
    private static String[] c;
    private static String[] tags;

    public static synchronized HintsUI getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new HintsUI();
        }
        return INSTANCE;
    }

    private HintsUI() {
        Registry.addChangeListener((ChangeListener)this);
        this.stateChanged(null);
    }

    public JTextComponent getComponent() {
        return this.comp;
    }

    public void setHints(LazyFixList lazyFixList, JTextComponent jTextComponent, boolean bl) {
        boolean bl2;
        if (this.hints.equals(lazyFixList) && this.comp == jTextComponent) {
            return;
        }
        if (jTextComponent != this.comp || !this.hints.equals(lazyFixList) && jTextComponent != null) {
            this.removePopups();
        }
        boolean bl3 = bl2 = lazyFixList != null && jTextComponent != null;
        if (!bl2 && this.comp != null) {
            this.removePopups();
        }
        this.hints = lazyFixList == null ? new StaticFixList() : lazyFixList;
        this.setComponent(jTextComponent);
        if (bl2) {
            this.showHints();
            if (bl) {
                this.showPopup();
            }
        }
    }

    public void setComponent(JTextComponent jTextComponent) {
        boolean bl;
        boolean bl2 = bl = this.comp != jTextComponent;
        if (bl) {
            this.unregister();
            this.comp = jTextComponent;
            this.register();
        }
    }

    private void register() {
        if (this.comp == null) {
            return;
        }
        this.comp.addKeyListener(this);
    }

    private void unregister() {
        if (this.comp == null) {
            return;
        }
        this.comp.removeKeyListener(this);
    }

    public void removePopups() {
        if (this.comp == null) {
            return;
        }
        this.removeIconHint();
        this.removePopup();
    }

    private void removeIconHint() {
        Container container;
        if (this.hintIcon != null && (container = this.hintIcon.getParent()) != null) {
            Rectangle rectangle = this.hintIcon.getBounds();
            container.remove(this.hintIcon);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void removePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.listPopup != null) {
            this.listPopup.hide();
            if (this.hintListComponent != null) {
                this.hintListComponent.getView().removeMouseListener(this);
            }
            if (this.errorTooltip != null) {
                this.errorTooltip.removeMouseListener(this);
            }
            this.hintListComponent = null;
            this.errorTooltip = null;
            this.listPopup = null;
            if (this.hintIcon != null) {
                this.hintIcon.setToolTipText(NbBundle.getMessage(HintsUI.class, (String)"HINT_Bulb"));
            }
        }
    }

    boolean isKnownComponent(Component component) {
        return component != null && (component == this.comp || component == this.hintIcon || component == this.hintListComponent || component instanceof Container && ((Container)component).isAncestorOf(this.hintListComponent));
    }

    private void showHints() {
        if (this.comp == null || !this.comp.isDisplayable() || !this.comp.isShowing()) {
            return;
        }
        this.configureBounds(this.getHintIcon());
    }

    private void configureBounds(JComponent jComponent) {
        JRootPane jRootPane = this.comp.getRootPane();
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Rectangle rectangle = null;
        try {
            int n = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            rectangle = this.comp.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            this.setHints(null, null, false);
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return;
        }
        Point point = new Point(rectangle.x - this.comp.getX(), rectangle.y);
        Dimension dimension = jComponent.getPreferredSize();
        SwingUtilities.convertPointToScreen(point, this.comp);
        SwingUtilities.convertPointFromScreen(point, jLayeredPane);
        jComponent.setBounds(point.x, point.y, dimension.width, dimension.height);
        jLayeredPane.add((Component)jComponent, JLayeredPane.POPUP_LAYER);
        jComponent.setVisible(true);
        jComponent.repaint();
    }

    private JLabel getHintIcon() {
        if (this.hintIcon == null) {
            this.hintIcon = new JLabel();
            this.hintIcon.addMouseListener(this);
            this.hintIcon.setToolTipText(NbBundle.getMessage(HintsUI.class, (String)"HINT_Bulb"));
        }
        String string = "org/netbeans/modules/editor/hints/resources/error.png";
        this.hintIcon.setIcon(new ImageIcon(org.openide.util.Utilities.loadImage((String)string)));
        return this.hintIcon;
    }

    public void showPopup() {
        if (this.comp == null || this.hints.isComputed() && this.hints.getFixes().isEmpty()) {
            return;
        }
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        assert (this.hintListComponent == null);
        this.hintListComponent = new ScrollCompletionPane(this.comp, this.hints, null, null);
        this.hintListComponent.getView().addMouseListener(this);
        this.hintListComponent.setName(POPUP_NAME);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        try {
            int n = javax.swing.text.Utilities.getRowStart(this.comp, this.comp.getCaret().getDot());
            Rectangle rectangle = this.comp.modelToView(n);
            Point point = new Point(rectangle.x + 5, rectangle.y + 20);
            SwingUtilities.convertPointToScreen(point, this.comp);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, point.x, point.y);
            this.listPopup.show();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            this.setHints(null, null, false);
        }
    }

    public void showPopup(LazyFixList lazyFixList, String string, JTextComponent jTextComponent, Point point) {
        this.setHints(null, null, false);
        this.setComponent(jTextComponent);
        if (this.comp == null || lazyFixList == null) {
            return;
        }
        this.hints = lazyFixList;
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, this.comp);
        if (this.hintIcon != null) {
            this.hintIcon.setToolTipText(null);
        }
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        if (!lazyFixList.isComputed() || lazyFixList.getFixes().isEmpty()) {
            assert (this.listPopup == null);
            this.errorTooltip = new JLabel("<html>" + this.translate(string));
            this.errorTooltip.setBorder(new LineBorder(Color.BLACK));
            this.errorTooltip.addMouseListener(this);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.errorTooltip, point2.x, point2.y);
        } else {
            assert (this.hintListComponent == null);
            this.hintListComponent = new ScrollCompletionPane(this.comp, lazyFixList, null, null);
            this.hintListComponent.getView().addMouseListener(this);
            this.hintListComponent.setName(POPUP_NAME);
            assert (this.listPopup == null);
            this.listPopup = this.getPopupFactory().getPopup(this.comp, this.hintListComponent, point2.x, point2.y);
        }
        this.listPopup.show();
    }

    private PopupFactory getPopupFactory() {
        if (this.pf == null) {
            this.pf = PopupFactory.getSharedInstance();
        }
        return this.pf;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.hintListComponent || mouseEvent.getSource() instanceof ListCompletionView) {
            Fix fix = null;
            Object e = this.hintListComponent.getView().getSelectedValue();
            if (e instanceof Fix) {
                fix = (Fix)e;
            }
            if (fix != null) {
                JTextComponent jTextComponent = this.comp;
                this.invokeHint(fix);
                this.setHints(null, null, false);
                this.setComponent(jTextComponent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JLabel && !this.isPopupActive()) {
            this.showPopup();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean isActive() {
        boolean bl = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl2 = this.hintListComponent != null && this.hintListComponent.isShowing();
        return bl || bl2;
    }

    public boolean isPopupActive() {
        return this.hintListComponent != null && this.hintListComponent.isShowing();
    }

    private ParseErrorAnnotation findAnnotation(Document document, AnnotationDesc annotationDesc, int n) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        AnnotationHolder annotationHolder = AnnotationHolder.getInstance(dataObject.getPrimaryFile());
        for (Annotation annotation : annotationHolder.getAnnotations()) {
            ParseErrorAnnotation parseErrorAnnotation;
            if (!(annotation instanceof ParseErrorAnnotation) || n != (parseErrorAnnotation = (ParseErrorAnnotation)annotation).getLineNumber() || !org.openide.util.Utilities.compareObjects((Object)annotationDesc.getShortDescription(), (Object)annotation.getShortDescription())) continue;
            return parseErrorAnnotation;
        }
        return null;
    }

    boolean invokeDefaultAction() {
        if (this.comp == null) {
            Logger.getLogger(HintsUI.class.getName()).log(Level.WARNING, "HintsUI.invokeDefaultAction called, but comp == null");
            return false;
        }
        Document document = this.comp.getDocument();
        if (document instanceof BaseDocument) {
            Annotations annotations = ((BaseDocument)document).getAnnotations();
            try {
                Rectangle rectangle = this.comp.modelToView(this.comp.getCaretPosition());
                int n = Utilities.getLineOffset((BaseDocument)((BaseDocument)document), (int)this.comp.getCaretPosition());
                AnnotationDesc annotationDesc = annotations.getActiveAnnotation(n);
                Point point = this.comp.modelToView(Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n)).getLocation();
                point.y += rectangle.height;
                ParseErrorAnnotation parseErrorAnnotation = this.findAnnotation(document, annotationDesc, n);
                if (parseErrorAnnotation == null) {
                    return false;
                }
                this.showPopup(parseErrorAnnotation.getFixes(), parseErrorAnnotation.getDescription(), this.comp, point);
                return true;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        InputMap inputMap;
        Object object;
        boolean bl;
        boolean bl2;
        if (this.comp == null) {
            return;
        }
        boolean bl3 = this.hintIcon != null && this.hintIcon.isShowing();
        boolean bl4 = bl2 = this.errorTooltip != null && this.errorTooltip.isShowing();
        if (bl2) {
            this.removePopup();
            return;
        }
        boolean bl5 = bl = this.hintListComponent != null && this.hintListComponent.isShowing();
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getModifiersEx() == 192 || keyEvent.getModifiersEx() == 512) {
                if (!bl) {
                    this.invokeDefaultAction();
                    keyEvent.consume();
                }
            } else if (keyEvent.getModifiersEx() == 0 && bl) {
                Fix fix = null;
                Object e = this.hintListComponent.getView().getSelectedValue();
                if (e instanceof Fix) {
                    fix = (Fix)e;
                }
                if (fix != null) {
                    this.invokeHint(fix);
                }
                keyEvent.consume();
            }
        } else if (keyEvent.getKeyCode() == 27) {
            if (bl) {
                this.removePopup();
            }
        } else if (bl && (object = (inputMap = this.hintListComponent.getInputMap()).get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null) {
            Action action = this.hintListComponent.getActionMap().get(object);
            action.actionPerformed(null);
            keyEvent.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeHint(final Fix fix) {
        Serializable serializable;
        if (UI_GESTURES_LOGGER.isLoggable(Level.FINE)) {
            serializable = new LogRecord(Level.FINE, "GEST_HINT_INVOKED");
            ((LogRecord)serializable).setResourceBundle(NbBundle.getBundle(HintsUI.class));
            ((LogRecord)serializable).setParameters(new Object[]{fix.getText()});
            UI_GESTURES_LOGGER.log((LogRecord)serializable);
        }
        this.removePopups();
        serializable = this.comp;
        Cursor cursor = ((Component)serializable).getCursor();
        ((Component)serializable).setCursor(Cursor.getPredefinedCursor(3));
        RequestProcessor.Task task = null;
        try {
            task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    HintsUI.this.changes = fix.implement();
                }
            });
            if (task == null) return;
        }
        catch (Throwable throwable) {
            if (task == null) throw throwable;
            task.addTaskListener(new TaskListener((JTextComponent)serializable, cursor){
                final /* synthetic */ JTextComponent val$component;
                final /* synthetic */ Cursor val$cur;
                {
                    this.val$component = jTextComponent;
                    this.val$cur = cursor;
                }

                public void taskFinished(Task task) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HintsUI.open(HintsUI.this.changes, val$component);
                            val$component.setCursor(val$cur);
                        }
                    });
                }
            });
            throw throwable;
        }
        task.addTaskListener(new /* invalid duplicate definition of identical inner class */);
    }

    private static void open(ChangeInfo changeInfo, JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = jTextComponent;
        if (changeInfo != null && changeInfo.size() > 0) {
            Position position;
            Position position2;
            ChangeInfo.Change change = changeInfo.get(0);
            FileObject fileObject = change.getFileObject();
            if (fileObject != null) {
                try {
                    OpenCookie openCookie;
                    position2 = DataObject.find((FileObject)fileObject);
                    position = (EditCookie)position2.getCookie(EditCookie.class);
                    if (position != null) {
                        position.edit();
                    } else {
                        openCookie = (OpenCookie)position2.getCookie(OpenCookie.class);
                        openCookie.open();
                    }
                    openCookie = (EditorCookie)position2.getCookie(EditorCookie.class);
                    JEditorPane[] jEditorPaneArray = openCookie.getOpenedPanes();
                    if (jEditorPaneArray == null || jEditorPaneArray.length <= 0) {
                        return;
                    }
                    jTextComponent2 = jEditorPaneArray[0];
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    return;
                }
            }
            position2 = change.getStart();
            position = change.getEnd();
            if (position2 != null) {
                jTextComponent2.setSelectionStart(position2.getOffset());
            }
            if (position != null) {
                jTextComponent2.setSelectionEnd(position.getOffset());
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (this.getComponent() != jTextComponent) {
            this.setHints(null, null, false);
            this.setComponent(jTextComponent);
        }
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Component component;
        Container container;
        MouseEvent mouseEvent;
        if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 500 && mouseEvent.getClickCount() > 0 && (container = SwingUtilities.getAncestorNamed(POPUP_NAME, component = (Component)aWTEvent.getSource())) == null) {
            this.removePopup();
        }
    }

    private String translate(String string) {
        for (int i = 0; i < c.length; ++i) {
            string = string.replaceAll(c[i], tags[i]);
        }
        return string;
    }

    static {
        UI_GESTURES_LOGGER = Logger.getLogger("org.netbeans.ui.editor.hints");
        c = new String[]{"&", "<", ">", "\n", "\""};
        tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};
    }
}

