/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakSet;

public class PersistentCache {
    private static PersistentCache INSTANCE = new PersistentCache();
    private static Map<FileObject, Set<FileObject>> fo2ContainedErrorFiles = new WeakHashMap<FileObject, Set<FileObject>>();
    private static Set<FileObject> knownObjects = new WeakSet();
    private FileObject cache = null;

    public static PersistentCache getDefault() {
        return INSTANCE;
    }

    private PersistentCache() {
    }

    public void addErrorFile(FileObject fileObject, FileObject fileObject2) {
        Set<FileObject> set = fo2ContainedErrorFiles.get(fileObject);
        if (set == null) {
            set = new HashSet<FileObject>();
            fo2ContainedErrorFiles.put(fileObject, set);
        }
        if (set.add(fileObject2)) {
            // empty if block
        }
        knownObjects.add(fileObject2);
    }

    public void removeErrorFile(FileObject fileObject, FileObject fileObject2) {
        Set<FileObject> set = fo2ContainedErrorFiles.get(fileObject);
        if (set == null) {
            set = new HashSet<FileObject>();
            fo2ContainedErrorFiles.put(fileObject, set);
        }
        if (set.remove(fileObject2)) {
            // empty if block
        }
        knownObjects.add(fileObject2);
    }

    public boolean hasErrors(FileObject fileObject) {
        Set<FileObject> set = fo2ContainedErrorFiles.get(fileObject);
        return set != null && !set.isEmpty();
    }

    public boolean isKnown(FileObject fileObject) {
        return knownObjects.contains(fileObject);
    }

    private synchronized FileObject cacheFile() {
        if (this.cache == null) {
            try {
                String string = System.getProperty("netbeans.user");
                File file = new File(string);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                this.cache = FileUtil.createFolder((FileObject)fileObject, (String)"var/cache/errors");
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return this.cache;
    }

    private FileObject getCacheFileFor(FileObject fileObject) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath().replace(':', '-').replace(File.separatorChar, '-');
        FileObject fileObject2 = FileUtil.createFolder((FileObject)this.cacheFile(), (String)string);
        FileObject fileObject3 = fileObject2.getFileObject("errors");
        if (fileObject3 == null) {
            fileObject3 = fileObject2.createData("errors");
        }
        return fileObject3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCache() {
        for (FileObject fileObject : fo2ContainedErrorFiles.keySet()) {
            try {
                FileObject fileObject2 = this.getCacheFileFor(fileObject);
                if (fileObject2 == null) continue;
                FileLock fileLock = fileObject2.lock();
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    Set<FileObject> set = fo2ContainedErrorFiles.get(fileObject);
                    for (FileObject fileObject3 : set) {
                        outputStream.write(FileUtil.toFile((FileObject)fileObject3).getAbsolutePath().getBytes());
                        outputStream.write(10);
                    }
                }
                finally {
                    outputStream.close();
                    fileLock.releaseLock();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    void loadCache() {
        this.loadCacheRecursive("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheRecursive(String string) {
        Object object;
        FileObject fileObject = this.cacheFile().getFileObject(string);
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            object = fileObjectArray[i];
            if (!object.isFolder()) continue;
            this.loadCacheRecursive(string + "/" + object.getNameExt());
        }
        try {
            String string2;
            FileObject fileObject2 = fileObject.getFileObject("errors");
            if (fileObject2 == null) {
                return;
            }
            object = fileObject2.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                    File file = new File(string2);
                    FileObject fileObject3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    if (fileObject3 == null) continue;
                    hashSet.add(fileObject3);
                }
            }
            finally {
                bufferedReader.close();
            }
            string2 = FileUtil.toFileObject((File)new File("/", string));
            if (string2 != null) {
                fo2ContainedErrorFiles.put((FileObject)string2, hashSet);
                knownObjects.add((FileObject)string2);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

