/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.options;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.editor.hints.options.AdvancedHintsPanel;
import org.netbeans.modules.editor.hints.options.ProvidersListAccessor;
import org.netbeans.spi.editor.hints.ProvidersList;
import org.netbeans.spi.editor.hints.Severity;

public class ModelImpl {
    private AdvancedHintsPanel panel;
    private Map<String, Boolean> key2Enabled;
    private Map<String, Map<String, Severity>> key2Error2Severity;
    private int eagerness;

    public ModelImpl(AdvancedHintsPanel advancedHintsPanel) {
        this.panel = advancedHintsPanel;
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public synchronized boolean isProviderEnabled(String string) {
        Boolean bl = this.key2Enabled.get(string);
        if (bl == null) {
            return ProvidersList.isProviderEnabled(string);
        }
        return bl;
    }

    public synchronized Severity getErrorSeverity(String string, String string2) {
        Map<String, Severity> map = this.key2Error2Severity.get(string);
        if (map == null) {
            return ProvidersList.getErrorSeverity(string, string2);
        }
        Severity severity = map.get(string2);
        if (severity == null) {
            return ProvidersList.getErrorSeverity(string, string2);
        }
        return severity;
    }

    public synchronized void setProviderEnabled(String string, boolean bl) {
        this.key2Enabled.put(string, bl);
        this.panel.firePropertyChange("changed", null, null);
    }

    public synchronized void setSeverity(String string, String string2, Severity severity) {
        Map<String, Severity> map = this.key2Error2Severity.get(string);
        if (map == null) {
            map = new HashMap<String, Severity>();
            this.key2Error2Severity.put(string, map);
        }
        map.put(string2, severity);
        this.panel.firePropertyChange("changed", null, null);
    }

    public synchronized List getDescriptions() {
        return ProvidersListAccessor.INSTANCE.getDescriptions();
    }

    public void rollBack() {
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public void commit() {
        Object object;
        String string;
        for (Map.Entry<String, Boolean> entry : this.key2Enabled.entrySet()) {
            string = entry.getKey();
            object = entry.getValue();
            ProvidersListAccessor.INSTANCE.setProviderEnabled(string, (Boolean)object);
        }
        for (Map.Entry<String, Object> entry : this.key2Error2Severity.entrySet()) {
            string = entry.getKey();
            object = (Map)entry.getValue();
            for (Map.Entry entry2 : object.entrySet()) {
                String string2 = (String)entry2.getKey();
                Severity severity = (Severity)((Object)entry2.getValue());
                ProvidersListAccessor.INSTANCE.setSeverity(string, string2, severity);
            }
        }
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public boolean isModified() {
        return !this.key2Enabled.isEmpty() || !this.key2Error2Severity.isEmpty() || this.eagerness != -1;
    }
}

