/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.hints.HintsControllerImpl;
import org.netbeans.modules.editor.hints.options.SeverityComboRenderer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProblemTopComponent
extends TopComponent {
    private static Object PTC_TAG = new Object();
    private static ProblemTopComponent instance;
    private static final String PREFERRED_ID = "ProblemTopComponent";
    private ProblemTableModel model;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private Lookup.Result<DataObject> resultDO = null;
    private Lookup.Result resultTag = null;
    private Lookup.Result<Project> resultProject = null;
    private ProjectListener listener = null;
    private Set<Project> activeProjects = null;
    private ChangeListenerImpl changeListener = null;

    private ProblemTopComponent() {
        super(Lookups.singleton((Object)PTC_TAG));
        this.initComponents();
        this.setName(NbBundle.getMessage(ProblemTopComponent.class, (String)"CTL_ProblemTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ProblemTopComponent.class, (String)"HINT_ProblemTopComponent"));
        this.jTable1.setDefaultRenderer(Integer.class, new SeverityComboRenderer());
        this.jTable1.setDefaultRenderer(ErrorDescription.class, new PositionCellRenderer());
        this.model = new ProblemTableModel();
        this.jTable1.setModel(this.model);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }

    public static synchronized ProblemTopComponent getDefault() {
        if (instance == null) {
            instance = new ProblemTopComponent();
        }
        return instance;
    }

    public static synchronized ProblemTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return ProblemTopComponent.getDefault();
        }
        if (topComponent instanceof ProblemTopComponent) {
            return (ProblemTopComponent)topComponent;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ProblemTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ProblemTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.resultDO = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
        this.resultTag = Utilities.actionsGlobalContext().lookup(new Lookup.Template(null, null, PTC_TAG));
        this.resultProject = Utilities.actionsGlobalContext().lookupResult(Project.class);
        this.listener = new ProjectListener();
        this.resultDO.addLookupListener((LookupListener)this.listener);
        this.resultTag.addLookupListener((LookupListener)this.listener);
        this.changeListener = new ChangeListenerImpl();
        HintsControllerImpl.addChangeListener(this.changeListener);
        this.listener.resultChanged(null);
    }

    public void componentClosed() {
        HintsControllerImpl.removeChangeListener(this.changeListener);
        this.changeListener = null;
        this.resultDO.removeLookupListener((LookupListener)this.listener);
        this.resultTag.removeLookupListener((LookupListener)this.listener);
        this.resultProject.removeLookupListener((LookupListener)this.listener);
        this.listener = null;
        this.resultDO = null;
        this.resultTag = null;
        this.resultProject = null;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private synchronized void updateErrors() {
        if (this.activeProjects == null) {
            return;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        for (FileObject fileObject : HintsControllerImpl.coveredFiles()) {
            if (!this.activeProjects.contains(FileOwnerQuery.getOwner((FileObject)fileObject))) continue;
            arrayList.addAll(HintsControllerImpl.getErrors(fileObject));
        }
        this.model.errors = arrayList;
        this.model.fireTableDataChanged();
    }

    private synchronized void setActiveProjects(Set<Project> set) {
        this.activeProjects = set;
        this.updateErrors();
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ProblemTopComponent.this.updateErrors();
        }
    }

    private static final class PositionCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ErrorDescription errorDescription = (ErrorDescription)object;
            try {
                String string = errorDescription.getFile().getNameExt() + ":" + errorDescription.getRange().getBegin().getLine();
                return this.delegateTo.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
            catch (IOException iOException) {
                return this.delegateTo.getTableCellRendererComponent(jTable, iOException.getLocalizedMessage(), bl, bl2, n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProblemTableModel
    extends AbstractTableModel {
        private List<ErrorDescription> errors = Collections.emptyList();

        private ProblemTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.errors.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Description";
                }
                case 1: {
                    return "Severity";
                }
                case 2: {
                    return "Position";
                }
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return ErrorDescription.class;
                }
            }
            throw new IllegalArgumentException("Invalid column: " + n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this.errors.size()) {
                throw new IllegalArgumentException("Invalid row: " + n + ", max=" + this.errors.size());
            }
            ErrorDescription errorDescription = this.errors.get(n);
            assert (errorDescription != null);
            switch (n2) {
                case 0: {
                    return errorDescription.getDescription();
                }
                case 1: {
                    return errorDescription.getSeverity();
                }
                case 2: {
                    return errorDescription;
                }
            }
            throw new IllegalArgumentException("Invalid column: " + n2);
        }
    }

    private class ProjectListener
    implements LookupListener {
        private ProjectListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            assert (ProblemTopComponent.this.resultDO != null && ProblemTopComponent.this.resultTag != null && ProblemTopComponent.this.resultProject != null);
            if (!ProblemTopComponent.this.resultTag.allInstances().isEmpty()) {
                return;
            }
            HashSet<Project> hashSet = new HashSet<Project>();
            for (DataObject dataObject : ProblemTopComponent.this.resultDO.allInstances()) {
                hashSet.add(FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()));
            }
            hashSet.addAll(ProblemTopComponent.this.resultProject.allInstances());
            ProblemTopComponent.this.setActiveProjects(hashSet);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ProblemTopComponent.getDefault();
        }
    }
}

