/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.RecentFiles;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class RecentFileAction
extends AbstractAction
implements Presenter.Menu,
PopupMenuListener {
    private static final String FO_PROP = "RecentFileAction.Recent_FO";
    private static final int MAX_COUNT = 15;
    private JMenu menu;

    public RecentFileAction() {
        super(NbBundle.getMessage(RecentFileAction.class, (String)"LBL_RecentFileAction_Name"));
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new UpdatingMenu(this);
            this.menu.setMnemonic(NbBundle.getMessage(RecentFileAction.class, (String)"MNE_RecentFileAction_Name").charAt(0));
            this.menu.getPopupMenu().addPopupMenuListener(this);
        }
        return this.menu;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.fillSubMenu();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.menu.removeAll();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private void fillSubMenu() {
        List<RecentFiles.HistoryItem> list = RecentFiles.getRecentFiles();
        int n = 0;
        for (RecentFiles.HistoryItem historyItem : list) {
            Object object;
            if (++n > 15) break;
            Image image = null;
            try {
                object = DataObject.find((FileObject)historyItem.getFile());
                image = object.getNodeDelegate().getIcon(1);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
                continue;
            }
            object = null;
            object = image != null ? new JMenuItem(historyItem.getFile().getNameExt(), new ImageIcon(image)) : new JMenuItem(historyItem.getFile().getNameExt());
            ((JComponent)object).putClientProperty(FO_PROP, historyItem.getFile());
            ((AbstractButton)object).addActionListener(this);
            this.menu.add((JMenuItem)object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        FileObject fileObject = (FileObject)jMenuItem.getClientProperty(FO_PROP);
        if (fileObject != null) {
            OpenFile.open(fileObject, -1);
        }
    }

    private static class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] content = new JComponent[]{this};

        public UpdatingMenu(Action action) {
            super(action);
        }

        public JComponent[] getMenuPresenters() {
            this.setEnabled(!RecentFiles.getRecentFiles().isEmpty());
            return this.content;
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }
    }
}

