/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecentFiles {
    private static List<HistoryItem> history = new ArrayList<HistoryItem>();
    private static Preferences prefs;
    private static final Object HISTORY_LOCK;
    private static final String PREFS_NODE = "RecentFilesHistory";
    private static final String SEPARATOR = "; time=";
    private static final int MAX_HISTORY_ITEMS = 20;

    private RecentFiles() {
    }

    public static void init() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List<HistoryItem> list = RecentFiles.load();
                Object object = HISTORY_LOCK;
                synchronized (object) {
                    history.addAll(0, list);
                }
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowRegistryL());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HistoryItem> getRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory();
            return Collections.unmodifiableList(history);
        }
    }

    static List<HistoryItem> load() {
        String[] stringArray;
        Preferences preferences = RecentFiles.getPrefs();
        try {
            stringArray = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.WARNING, backingStoreException.getMessage(), backingStoreException);
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>(stringArray.length + 10);
        for (String string : stringArray) {
            HistoryItem historyItem = RecentFiles.decode(preferences.get(string, null));
            if (historyItem != null) {
                arrayList.add(historyItem);
                continue;
            }
            preferences.remove(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static HistoryItem decode(String string) {
        int n = string.lastIndexOf(SEPARATOR);
        if (n <= 0) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(string.substring(0, n));
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, malformedURLException.getMessage(), malformedURLException);
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return null;
        }
        long l = 0L;
        try {
            l = Long.decode(string.substring(n + SEPARATOR.length()));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
            return null;
        }
        return new HistoryItem(fileObject, l);
    }

    static void storeRemoved(HistoryItem historyItem) {
        String string = null;
        URL uRL = URLMapper.findURL((FileObject)historyItem.getFile(), (int)1);
        if (uRL == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, "storeRemoved: URL can't be found for FileObject " + historyItem.getFile());
            return;
        }
        string = uRL.toExternalForm();
        RecentFiles.getPrefs().remove(RecentFiles.trimToKeySize(string));
    }

    static void storeAdded(HistoryItem historyItem) {
        String string = null;
        URL uRL = URLMapper.findURL((FileObject)historyItem.getFile(), (int)1);
        if (uRL == null) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.INFO, "storeAdded: URL can't be found for FileObject " + historyItem.getFile());
            return;
        }
        string = uRL.toExternalForm();
        String string2 = string + SEPARATOR + String.valueOf(historyItem.getTime());
        RecentFiles.getPrefs().put(RecentFiles.trimToKeySize(string), string2);
    }

    private static String trimToKeySize(String string) {
        int n = string.length();
        if (n > 80) {
            string = string.substring(n - 80, n);
        }
        return string;
    }

    static Preferences getPrefs() {
        if (prefs == null) {
            prefs = NbPreferences.forModule(RecentFiles.class).node(PREFS_NODE);
        }
        return prefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(TopComponent topComponent) {
        FileObject fileObject;
        if (topComponent instanceof CloneableTopComponent && (fileObject = RecentFiles.obtainFileObject(topComponent)) != null) {
            boolean bl = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem historyItem = RecentFiles.findHistoryItem(fileObject);
                if (historyItem == null) {
                    historyItem = new HistoryItem(fileObject, System.currentTimeMillis());
                    history.add(0, historyItem);
                    RecentFiles.storeAdded(historyItem);
                    bl = true;
                    if (history.size() > 20) {
                        HistoryItem historyItem2 = history.get(history.size() - 1);
                        history.remove(historyItem2);
                        RecentFiles.storeRemoved(historyItem2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFile(TopComponent topComponent) {
        FileObject fileObject;
        if (topComponent instanceof CloneableTopComponent && (fileObject = RecentFiles.obtainFileObject(topComponent)) != null) {
            boolean bl = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem historyItem = RecentFiles.findHistoryItem(fileObject);
                if (historyItem != null) {
                    history.remove(historyItem);
                    RecentFiles.storeRemoved(historyItem);
                    bl = true;
                }
            }
        }
    }

    private static FileObject obtainFileObject(TopComponent topComponent) {
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    private static HistoryItem findHistoryItem(FileObject fileObject) {
        for (HistoryItem historyItem : history) {
            if (!fileObject.equals(historyItem.getFile())) continue;
            return historyItem;
        }
        return null;
    }

    private static void checkHistory() {
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>(3);
        for (HistoryItem historyItem : history) {
            if (historyItem.getFile().isValid()) continue;
            arrayList.add(historyItem);
        }
        for (HistoryItem<Object> historyItem : arrayList) {
            history.remove(historyItem);
        }
    }

    static {
        HISTORY_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HistoryItem<T extends HistoryItem>
    implements Comparable<T> {
        private long time;
        private FileObject file;

        HistoryItem(FileObject fileObject, long l) {
            this.file = fileObject;
            this.time = l;
        }

        public FileObject getFile() {
            return this.file;
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public int compareTo(T t) {
            long l = this.time - ((HistoryItem)t).getTime();
            return l < 0L ? 1 : (l > 0L ? -1 : 0);
        }
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("tcClosed".equals(propertyChangeEvent.getPropertyName())) {
                RecentFiles.addFile((TopComponent)propertyChangeEvent.getNewValue());
            }
            if ("tcOpened".equals(propertyChangeEvent.getPropertyName())) {
                RecentFiles.removeFile((TopComponent)propertyChangeEvent.getNewValue());
            }
        }
    }
}

