/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.SearchPerformer;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class FindActionManager
implements PropertyChangeListener,
Runnable {
    private static final String MAPPED_FIND_ACTION = FindActionManager.class.getName() + " - FindActionImpl";
    private static FindActionManager instance;
    private final SearchPerformer performer;
    private final WeakSet activatedOnWindows = new WeakSet(8);
    private Object findActionMapKey;

    private FindActionManager() {
        this.performer = (SearchPerformer)SharedClassObject.findObject(SearchPerformer.class, (boolean)true);
    }

    static FindActionManager getInstance() {
        if (instance == null) {
            instance = new FindActionManager();
        }
        return instance;
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
    }

    void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                FindActionManager.this.cleanupWindowRegistry();
                return null;
            }
        });
    }

    public void run() {
        this.someoneActivated();
    }

    private void cleanupWindowRegistry() {
        Object object = this.getFindActionMapKey();
        for (TopComponent topComponent : this.activatedOnWindows) {
            Object t;
            Action action = null;
            Action action2 = null;
            Object object2 = topComponent.getClientProperty((Object)MAPPED_FIND_ACTION);
            if (object2 instanceof Reference && (t = ((Reference)object2).get()) instanceof Action) {
                action = (Action)t;
            }
            if (action != null) {
                action2 = topComponent.getActionMap().get(object);
            }
            if (action2 != null && action2 == action) {
                topComponent.getActionMap().put(object, null);
            } else {
                ErrorManager.getDefault().log(16, "ActionMap mapping of FindAction changed for window " + topComponent.getName());
            }
            if (object2 == null) continue;
            topComponent.putClientProperty((Object)MAPPED_FIND_ACTION, null);
        }
        this.activatedOnWindows.clear();
    }

    private void someoneActivated() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null || topComponent instanceof CloneableEditorSupport.Pane) {
            return;
        }
        Object object = this.getFindActionMapKey();
        ActionMap actionMap = topComponent.getActionMap();
        if (actionMap.get(object) == null && this.activatedOnWindows.add((Object)topComponent)) {
            Action action = this.performer.createContextAwareInstance(topComponent.getLookup());
            actionMap.put(object, action);
            topComponent.putClientProperty((Object)MAPPED_FIND_ACTION, new WeakReference<Action>(action));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.someoneActivated();
        }
    }

    private Object getFindActionMapKey() {
        if (this.findActionMapKey == null) {
            SharedClassObject sharedClassObject = SharedClassObject.findObject(FindAction.class);
            assert (sharedClassObject != null);
            this.findActionMapKey = ((FindAction)sharedClassObject).getActionMapKey();
        }
        return this.findActionMapKey;
    }
}

