/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.awt.HtmlRenderer;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NodeRenderer
extends JComponent
implements TreeCellRenderer {
    private static Rectangle checkBounds;
    private final HtmlRenderer.Renderer nodeRenderer;
    private final Image rootIconImage;
    private final JCheckBox checkBox;
    private Image deletedObjectIconImage;
    private String deletedObjectHtmlSuffix;
    private Component stringDisplayer = new JLabel(" ");

    NodeRenderer(boolean bl) {
        this.nodeRenderer = HtmlRenderer.createRenderer();
        this.rootIconImage = Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif", (boolean)true);
        this.setLayout(null);
        if (!bl) {
            this.checkBox = null;
        } else {
            this.checkBox = new JCheckBox();
            this.checkBox.setBorderPaintedFlat(true);
            Color color = UIManager.getColor("Tree.textBackground");
            if (color == null) {
                color = Color.WHITE;
            }
            this.checkBox.setBackground(color);
            Dimension dimension = this.checkBox.getPreferredSize();
            this.checkBox.setPreferredSize(new Dimension(dimension.width, dimension.height - 5));
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        boolean bl5;
        Image image;
        boolean bl6;
        String string;
        boolean bl7;
        boolean bl8 = bl7 = n == 0;
        if (bl7) {
            assert (object instanceof ResultTreeModel);
            ResultTreeModel resultTreeModel = (ResultTreeModel)object;
            string = resultTreeModel.getRootDisplayName();
            bl6 = false;
            image = this.rootIconImage;
            bl5 = this.checkBox != null ? resultTreeModel.isSelected() : false;
        } else if (object.getClass() == MatchingObject.class) {
            MatchingObject matchingObject = (MatchingObject)object;
            DataObject dataObject = (DataObject)matchingObject.object;
            boolean bl9 = matchingObject.isObjectValid();
            if (bl9) {
                Node node = dataObject.getNodeDelegate();
                string = node.getHtmlDisplayName();
                boolean bl10 = bl6 = string != null;
                if (!bl6) {
                    string = node.getDisplayName();
                }
                image = node.getIcon(1);
            } else {
                string = dataObject.getName() + this.getDeletedObjectHtmlSuffix();
                bl6 = true;
                image = this.getDeletedObjectIconImage();
            }
            bl5 = this.checkBox != null ? matchingObject.isSelected() : false;
        } else {
            assert (object instanceof Node);
            Node node = (Node)object;
            string = node.getHtmlDisplayName();
            boolean bl11 = bl6 = string != null;
            if (!bl6) {
                string = node.getDisplayName();
            }
            image = node.getIcon(1);
            if (this.checkBox == null) {
                bl5 = false;
            } else {
                TreePath treePath = jTree.getPathForRow(n);
                if (treePath == null) {
                    bl5 = true;
                } else {
                    MatchingObject matchingObject = (MatchingObject)treePath.getPathComponent(1);
                    if (matchingObject.isUniformSelection()) {
                        bl5 = matchingObject.isSelected();
                    } else {
                        int n2 = jTree.getRowForPath(treePath.getParentPath());
                        int n3 = n - n2 - 1;
                        bl5 = matchingObject.isSubnodeSelected(n3);
                    }
                }
            }
        }
        this.stringDisplayer = this.nodeRenderer.getTreeCellRendererComponent(jTree, (Object)string, bl, bl2, bl3, n, bl4);
        this.nodeRenderer.setHtml(bl6);
        this.nodeRenderer.setIcon((Icon)new ImageIcon(image));
        if (this.stringDisplayer.getBackground() == null) {
            this.stringDisplayer.setBackground(jTree.getBackground());
        }
        if (this.stringDisplayer.getForeground() == null) {
            this.stringDisplayer.setForeground(jTree.getForeground());
        }
        if (this.checkBox != null) {
            this.checkBox.setSelected(bl5);
            return this;
        }
        return this.stringDisplayer;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.checkBox.getSize();
        Dimension dimension2 = this.stringDisplayer.getPreferredSize();
        int n = dimension.height >= dimension2.height ? (dimension.height - dimension2.height) / 2 : 0;
        this.checkBox.paint(graphics);
        assert (this.stringDisplayer.getBounds().x == 0 && this.stringDisplayer.getBounds().y == 0);
        graphics.translate(dimension.width, n);
        this.stringDisplayer.paint(graphics);
        graphics.translate(-dimension.width, -n);
    }

    public Dimension getPreferredSize() {
        this.stringDisplayer.setFont(this.getFont());
        Dimension dimension = new Dimension(this.stringDisplayer.getPreferredSize());
        Dimension dimension2 = this.checkBox.getPreferredSize();
        dimension.width += dimension2.width;
        dimension.height = Math.max(dimension.height, dimension2.height);
        return dimension;
    }

    public void doLayout() {
        Dimension dimension = this.checkBox.getPreferredSize();
        Dimension dimension2 = this.stringDisplayer.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        int n5 = n4 - n2;
        int n6 = n5 > 2 ? n5 / 2 - 1 : 0;
        int n7 = n5 < 0 ? -n5 / 2 : 0;
        this.checkBox.setBounds(0, n6, n, n2);
        this.stringDisplayer.setBounds(n, n7, n3, n4);
        if (checkBounds == null) {
            checkBounds = this.checkBox.getBounds();
        }
    }

    private Image getDeletedObjectIconImage() {
        if (this.deletedObjectIconImage == null) {
            this.deletedObjectIconImage = Utilities.loadImage((String)"org/netbeans/modules/search/res/invalid.png", (boolean)true);
        }
        return this.deletedObjectIconImage;
    }

    private String getDeletedObjectHtmlSuffix() {
        if (this.deletedObjectHtmlSuffix == null) {
            this.deletedObjectHtmlSuffix = "&nbsp;&nbsp;<font color=\"#ff0000\">" + NbBundle.getMessage(this.getClass(), (String)"LBL_InvalidFile") + "</font>";
        }
        return this.deletedObjectHtmlSuffix;
    }

    static Rectangle getCheckBoxRectangle() {
        return (Rectangle)checkBounds.clone();
    }
}

