/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.netbeans.modules.search.Utils;

class SearchTypeInputStream
extends ObjectInputStream {
    private Class extSearchType = null;
    private ClassLoader extClassLoader = null;

    public SearchTypeInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz = this.resolveExtClass(objectStreamClass.getName());
            if (clazz != null) {
                return clazz;
            }
            throw classNotFoundException;
        }
    }

    private Class resolveExtClass(String string) {
        if (this.extSearchType == null) {
            this.extSearchType = Utils.searchTypeForName(string);
            return this.extSearchType;
        }
        if (this.extClassLoader == null) {
            try {
                this.extClassLoader = this.extSearchType.getClassLoader();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        try {
            return this.extClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

