/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.Action;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.search.types.TextDetail;
import org.netbeans.modules.search.types.TextType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextType
extends TextType {
    private static final long serialVersionUID = 1L;
    private static final Collection searchableXMimeTypes = new HashSet(17);
    private String replaceString;
    private transient Map<DataObject, List<TextDetail>> detailsMap;
    private static final int MAX_REPORTED_OCCURENCES_ON_LINE = 5;
    private static final int MAX_REPORTED_OCCURENCES_IN_FILE = 200;

    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String string) {
        if (string == null) {
            this.setValid(false);
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            string = null;
        }
        this.replaceString = string;
    }

    public Object clone() {
        FullTextType fullTextType = (FullTextType)((Object)super.clone());
        fullTextType.detailsMap = new HashMap<DataObject, List<TextDetail>>(20);
        fullTextType.replaceString = this.replaceString;
        return fullTextType;
    }

    public void destroy() {
        if (this.detailsMap != null) {
            this.detailsMap.clear();
        }
    }

    protected String displayName() {
        return NbBundle.getMessage(FullTextType.class, (String)"TEXT_FULLTEXT_CRITERION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DataObject, List<TextDetail>> getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        FullTextType fullTextType = this;
        synchronized (fullTextType) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap<DataObject, List<TextDetail>>(20);
            }
        }
        return this.detailsMap;
    }

    public static Charset getCharset(FileObject fileObject) {
        return FileEncodingQuery.getEncoding((FileObject)fileObject);
    }

    public LineNumberReader getFileObjectReader(FileObject fileObject) throws FileNotFoundException {
        InputStream inputStream = fileObject.getInputStream();
        Charset charset = FullTextType.getCharset(fileObject);
        return new LineNumberReader(new InputStreamReader(inputStream, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testDataObject(DataObject dataObject) {
        BufferedReader bufferedReader = null;
        SearchPattern searchPattern = this.createSearchPattern();
        try {
            int n;
            String string = "";
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject == null) {
                boolean bl = false;
                return bl;
            }
            bufferedReader = this.getFileObjectReader(fileObject);
            ArrayList<TextDetail> arrayList = new ArrayList<TextDetail>(5);
            int n2 = 0;
            while (n2 < 200 && (string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                int n3;
                if (this.matchString != null) {
                    int n4;
                    if (string.length() < this.matchString.length()) continue;
                    n = ((LineNumberReader)bufferedReader).getLineNumber();
                    int n5 = this.matchString.length();
                    String string2 = this.caseSensitive ? string : string.toUpperCase();
                    n3 = 1;
                    int n6 = string2.length() - this.matchString.length() + 1;
                    int n7 = 0;
                    do {
                        if ((n4 = this.matchString(string2, n3)) > 0) {
                            TextDetail textDetail = new TextDetail(dataObject, searchPattern);
                            textDetail.setLine(n);
                            textDetail.setColumn(n4);
                            textDetail.setLineText(string);
                            textDetail.setMarkLength(n5);
                            arrayList.add(textDetail);
                            ++n7;
                            ++n2;
                        }
                        n3 = Math.abs(n4) + 1;
                    } while (n4 != 0 && n3 <= n6 && n7 < 5);
                    continue;
                }
                if (!this.matchRE(string)) continue;
                TextDetail textDetail = new TextDetail(dataObject, searchPattern);
                textDetail.setLine(((LineNumberReader)bufferedReader).getLineNumber());
                textDetail.setLineText(string);
                Matcher matcher = this.getMatcher();
                int n8 = matcher.start();
                n3 = matcher.end() - n8;
                textDetail.setColumn(n8 + 1);
                textDetail.setMarkLength(n3);
                arrayList.add(textDetail);
                ++n2;
            }
            if (arrayList.isEmpty()) {
                n = 0;
                return n != 0;
            }
            arrayList.trimToSize();
            this.getDetailsMap().put(dataObject, arrayList);
            n = 1;
            return n != 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    protected boolean acceptSearchObject(Object object) {
        DataObject dataObject = (DataObject)object;
        FileObject fileObject = dataObject.getPrimaryFile();
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown") || string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || string2.startsWith("x-") && searchableXMimeTypes.contains(string2.substring(2));
        }
        return false;
    }

    public Node[] getDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        if (list == null) {
            return null;
        }
        ArrayList<DetailNode> arrayList = new ArrayList<DetailNode>(list.size());
        for (TextDetail textDetail : list) {
            DetailNode detailNode = new DetailNode(textDetail);
            arrayList.add(detailNode);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? list.size() : 0;
    }

    public List<TextDetail> getTextDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? new ArrayList<TextDetail>(list) : null;
    }

    public SearchPattern createSearchPattern() {
        return SearchPattern.create((String)(this.matchString != null ? this.matchString : this.reString), (boolean)this.wholeWords, (boolean)this.caseSensitive, (this.matchString == null ? 1 : 0) != 0);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FullTextType.class);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
    }

    private static class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;

        public DetailNode(TextDetail textDetail) {
            super(Children.LEAF);
            this.txtDetail = textDetail;
            this.setShortDescription(DetailNode.getShortDesc(textDetail));
            this.setValue("output line", DetailNode.getFullDesc(textDetail));
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public Action getPreferredAction() {
            return SystemAction.get(GotoDetailAction.class);
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == DetailNode.class && ((DetailNode)((Object)object)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            String string;
            if (this.txtDetail.getMarkLength() > 0 && this.txtDetail.getColumn() > 0) {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = this.txtDetail.getLineText();
                    int n = this.txtDetail.getColumn() - 1;
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(0, n)));
                    stringBuffer.append("<b>");
                    int n2 = n + this.txtDetail.getMarkLength();
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n, n2)));
                    stringBuffer.append("</b>");
                    if (this.txtDetail.getLineText().length() > n2) {
                        stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n2)));
                    }
                    string = stringBuffer.toString();
                }
                catch (CharConversionException charConversionException) {
                    return null;
                }
            }
            try {
                string = XMLUtil.toElementContent((String)this.txtDetail.getLineText());
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            try {
                return string + "      <font color='!controlShadow'>[" + XMLUtil.toElementContent((String)DetailNode.getName(this.txtDetail)) + "]";
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }

        private void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
            return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(n));
        }

        private static String getShortDesc(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(n));
        }

        private static String getFullDesc(TextDetail textDetail) {
            String string = textDetail.getDataObject().getPrimaryFile().getNameExt();
            String string2 = textDetail.getLineText();
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{string2, string, Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(FullTextType.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{string2, string, Integer.toString(n)});
        }
    }

    private static class GotoDetailAction
    extends NodeAction {
        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle(FullTextType.class).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(GotoDetailAction.class);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length != 0 && nodeArray[0] instanceof DetailNode;
        }

        protected void performAction(Node[] nodeArray) {
            if (this.enable(nodeArray)) {
                ((DetailNode)nodeArray[0]).gotoDetail();
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }
}

