/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.types;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.search.types.ObjectTypeType;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ObjectTypeCustomizer
extends JPanel
implements Customizer,
HierarchyListener {
    private static final String FOLDER_LOADER_NAME = "org.openide.loaders.DataFolder";
    private ObjectTypeType peer;
    private boolean setting = false;
    private boolean discovered = false;
    private transient Collection loaders;
    private JScrollPane jScrollPane1;
    private JLabel lblType;
    private JList typeList;

    public ObjectTypeCustomizer() {
        this.initComponents();
        this.initAccessibility();
        this.addHierarchyListener(this);
        TitledBorder titledBorder = new TitledBorder(NbBundle.getBundle(ObjectTypeCustomizer.class).getString("TEXT_LABEL_OBJECT_TYPE"));
        titledBorder.setBorder(new CompoundBorder());
        this.setBorder(titledBorder);
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ObjectTypeCustomizer.class);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("TEXT_LABEL_OBJECT_TYPE"));
        this.typeList.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_TypeList"));
        this.typeList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TypeList"));
        this.jScrollPane1.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_HScrollBar"));
        this.jScrollPane1.getVerticalScrollBar().getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_VScrollBar"));
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.typeList = new JList();
        this.setLayout(new BorderLayout(0, 6));
        this.lblType.setLabelFor(this.typeList);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(ObjectTypeCustomizer.class, (String)"LBL_Type"));
        this.add((Component)this.lblType, "North");
        this.typeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ObjectTypeCustomizer.this.typeListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.typeList);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void typeListValueChanged(ListSelectionEvent listSelectionEvent) {
        Object object2;
        if (this.setting) {
            return;
        }
        if (this.loaders == null) {
            this.peer.setMask(new Class[0]);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.typeList.getSelectedValues();
        block0: for (Object object2 : this.loaders) {
            String string = object2.getDisplayName();
            if (string == null) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null || !string.equals((String)objectArray[i])) continue;
                arrayList.add(object2);
                continue block0;
            }
        }
        Class[] classArray = new Class[arrayList.size()];
        object2 = arrayList.iterator();
        int n = 0;
        while (object2.hasNext()) {
            classArray[n++] = object2.next().getClass();
        }
        this.peer.setMask(classArray);
    }

    public void setObject(Object object) {
        this.peer = (ObjectTypeType)((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjectTypes() {
        assert (this.loaders == null);
        this.setting = true;
        try {
            Object object;
            Object object2;
            Enumeration enumeration = ((DataLoaderPool)Lookup.getDefault().lookup(DataLoaderPool.class)).allLoaders();
            TreeSet<String> treeSet = new TreeSet<String>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            Class[] classArray = this.peer.getMask();
            if (classArray != null && classArray.length == 0) {
                classArray = null;
            }
            int n = classArray != null ? classArray.length : 0;
            this.loaders = new ArrayList();
            block7: while (enumeration.hasMoreElements()) {
                Class clazz;
                object2 = (DataLoader)enumeration.nextElement();
                this.loaders.add(object2);
                if (!bl && FOLDER_LOADER_NAME.equals(object2.getRepresentationClassName())) {
                    bl = true;
                    continue;
                }
                try {
                    object = object2.getDisplayName();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(16, (Throwable)exception);
                    continue;
                }
                if (object == null) continue;
                treeSet.add((String)object);
                if (n <= 0 || (clazz = object2.getRepresentationClass()) == null) continue;
                for (int i = 0; i < classArray.length; ++i) {
                    DataLoader dataLoader;
                    if (classArray[i] == null || (dataLoader = DataLoader.getLoader((Class)classArray[i])) == null || !clazz.equals(dataLoader.getRepresentationClass())) continue;
                    arrayList.add(object);
                    --n;
                    classArray[i] = null;
                    continue block7;
                }
            }
            ((ArrayList)this.loaders).trimToSize();
            this.typeList.setListData(treeSet.toArray(new String[treeSet.size()]));
            if (arrayList.size() > 0) {
                object2 = new int[arrayList.size()];
                object = new ArrayList(treeSet);
                for (int i = 0; i < ((DataLoader)object2).length; ++i) {
                    object2[i] = (DataLoader)((ArrayList)object).indexOf(arrayList.get(i));
                }
                this.typeList.setSelectedIndices((int[])object2);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        finally {
            this.setting = false;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.discovered) {
            return;
        }
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.isShowing()) {
            this.discovered = true;
            this.loadObjectTypes();
        }
    }

    public void requestFocus() {
        this.typeList.requestFocus();
    }
}

